/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.AddReplicaPropertyRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class ReplicaPropertiesApi {

    public static class DeleteReplicaProperty
    extends SolrRequest<DeleteReplicaPropertyResponse> {
        private final String collName;
        private final String shardName;
        private final String replicaName;
        private final String propName;

        public DeleteReplicaProperty(String collName, String shardName, String replicaName, String propName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/collections/{collName}/shards/{shardName}/replicas/{replicaName}/properties/{propName}".replace("{collName}", collName).replace("{shardName}", shardName).replace("{replicaName}", replicaName).replace("{propName}", propName));
            this.collName = collName;
            this.shardName = shardName;
            this.replicaName = replicaName;
            this.propName = propName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected DeleteReplicaPropertyResponse createResponse(SolrClient client) {
            return new DeleteReplicaPropertyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteReplicaPropertyResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public DeleteReplicaPropertyResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class AddReplicaProperty
    extends SolrRequest<AddReplicaPropertyResponse> {
        private final AddReplicaPropertyRequestBody requestBody;
        private final String collName;
        private final String shardName;
        private final String replicaName;
        private final String propName;

        public AddReplicaProperty(String collName, String shardName, String replicaName, String propName) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/collections/{collName}/shards/{shardName}/replicas/{replicaName}/properties/{propName}".replace("{collName}", collName).replace("{shardName}", shardName).replace("{replicaName}", replicaName).replace("{propName}", propName));
            this.collName = collName;
            this.shardName = shardName;
            this.replicaName = replicaName;
            this.propName = propName;
            this.requestBody = new AddReplicaPropertyRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setValue(String value) {
            this.requestBody.value = value;
        }

        public void setShardUnique(Boolean shardUnique) {
            this.requestBody.shardUnique = shardUnique;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected AddReplicaPropertyResponse createResponse(SolrClient client) {
            return new AddReplicaPropertyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class AddReplicaPropertyResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public AddReplicaPropertyResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

