/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

class GeometryLock {
    Thread threadId = null;
    boolean lockOwned = false;
    int count = 0;
    int waiting = 0;

    GeometryLock() {
    }

    synchronized void getLock() {
        Thread thread = Thread.currentThread();
        if (this.threadId == thread) {
            ++this.count;
            return;
        }
        while (this.lockOwned) {
            try {
                ++this.waiting;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                System.err.println(interruptedException);
            }
            --this.waiting;
        }
        ++this.count;
        this.lockOwned = true;
        this.threadId = thread;
    }

    synchronized void unLock() {
        Thread thread = Thread.currentThread();
        if (this.threadId == thread) {
            if (--this.count > 0) {
                return;
            }
            this.lockOwned = false;
            this.threadId = null;
            if (this.waiting > 0) {
                this.notify();
            }
        }
    }
}

