/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.common;

import com.dickimawbooks.bibgls.common.Bib2GlsSyntaxException;
import com.dickimawbooks.bibgls.common.BibGlsArgValueType;
import com.dickimawbooks.bibgls.common.BibGlsTeXApp;

public class BibGlsArgValue {
    private String stringValue;
    private int intValue;
    private String[] listValue;

    public BibGlsArgValue(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.stringValue = string;
    }

    public BibGlsArgValue(String string, int n) {
        this(string);
        this.intValue = n;
    }

    public static BibGlsArgValue create(BibGlsTeXApp bibGlsTeXApp, String string, String string2, BibGlsArgValueType bibGlsArgValueType) throws Bib2GlsSyntaxException {
        if (string2 == null) {
            throw new Bib2GlsSyntaxException(bibGlsTeXApp.getMessage("error.missing.value", string));
        }
        BibGlsArgValue bibGlsArgValue = new BibGlsArgValue(string2);
        switch (bibGlsArgValueType) {
            case INT: {
                try {
                    bibGlsArgValue.intValue = Integer.parseInt(string2);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Bib2GlsSyntaxException(bibGlsTeXApp.getMessage("error.invalid.opt.int.value", string, string2));
                }
            }
            case LIST: {
                bibGlsArgValue.listValue = string2.trim().split(" *, *");
            }
        }
        return bibGlsArgValue;
    }

    public String toString() {
        return this.stringValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public String[] listValue() {
        return this.listValue;
    }
}

