/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import jakarta.servlet.descriptor.TaglibDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.jasper.compiler.JarScannerFactory;
import org.apache.jasper.compiler.Localizer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.Jar;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.descriptor.tld.TaglibXml;
import org.apache.tomcat.util.descriptor.tld.TldParser;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.xml.sax.SAXException;

public class TldScanner {
    private final Log log = LogFactory.getLog(TldScanner.class);
    private static final String MSG = "org.apache.jasper.servlet.TldScanner";
    private static final String TLD_EXT = ".tld";
    private static final String WEB_INF = "/WEB-INF/";
    private final ServletContext context;
    private final TldParser tldParser;
    private final Map<String, TldResourcePath> uriTldResourcePathMap = new HashMap<String, TldResourcePath>();
    private final Map<TldResourcePath, TaglibXml> tldResourcePathTaglibXmlMap = new HashMap<TldResourcePath, TaglibXml>();
    private final List<String> listeners = new ArrayList<String>();

    public TldScanner(ServletContext servletContext, boolean bl, boolean bl2, boolean bl3) {
        this.context = servletContext;
        this.tldParser = new TldParser(bl, bl2, bl3);
    }

    public void scan() throws IOException, SAXException {
        this.scanPlatform();
        this.scanJspConfig();
        this.scanResourcePaths(WEB_INF);
        this.scanJars();
    }

    public Map<String, TldResourcePath> getUriTldResourcePathMap() {
        return this.uriTldResourcePathMap;
    }

    public Map<TldResourcePath, TaglibXml> getTldResourcePathTaglibXmlMap() {
        return this.tldResourcePathTaglibXmlMap;
    }

    public List<String> getListeners() {
        return this.listeners;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.tldParser.setClassLoader(classLoader);
    }

    protected void scanPlatform() {
    }

    protected void scanJspConfig() throws IOException, SAXException {
        JspConfigDescriptor jspConfigDescriptor = this.context.getJspConfigDescriptor();
        if (jspConfigDescriptor == null) {
            return;
        }
        Collection collection = jspConfigDescriptor.getTaglibs();
        for (TaglibDescriptor taglibDescriptor : collection) {
            URL uRL;
            String string = taglibDescriptor.getTaglibURI();
            Object object = taglibDescriptor.getTaglibLocation();
            if (!((String)object).startsWith("/")) {
                object = WEB_INF + (String)object;
            }
            if (this.uriTldResourcePathMap.containsKey(string)) {
                this.log.warn((Object)Localizer.getMessage("org.apache.jasper.servlet.TldScanner.webxmlSkip", object, string));
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)Localizer.getMessage("org.apache.jasper.servlet.TldScanner.webxmlAdd", object, string));
            }
            if ((uRL = this.context.getResource((String)object)) != null) {
                TldResourcePath tldResourcePath = ((String)object).endsWith(".jar") ? new TldResourcePath(uRL, (String)object, "META-INF/taglib.tld") : new TldResourcePath(uRL, (String)object);
                TaglibXml taglibXml = this.tldParser.parse(tldResourcePath);
                this.uriTldResourcePathMap.put(string, tldResourcePath);
                this.tldResourcePathTaglibXmlMap.put(tldResourcePath, taglibXml);
                if (taglibXml.getListeners() == null) continue;
                this.listeners.addAll(taglibXml.getListeners());
                continue;
            }
            this.log.warn((Object)Localizer.getMessage("org.apache.jasper.servlet.TldScanner.webxmlFailPathDoesNotExist", object, string));
        }
    }

    protected void scanResourcePaths(String string) throws IOException, SAXException {
        boolean bl = false;
        Set set = this.context.getResourcePaths(string);
        if (set != null) {
            for (String string2 : set) {
                if (string2.startsWith("/WEB-INF/classes/") || string2.startsWith("/WEB-INF/lib/")) continue;
                if (string2.endsWith("/")) {
                    this.scanResourcePaths(string2);
                    continue;
                }
                if (string2.startsWith("/WEB-INF/tags/")) {
                    if (!string2.endsWith("/implicit.tld")) continue;
                    bl = true;
                    this.parseTld(string2);
                    continue;
                }
                if (!string2.endsWith(TLD_EXT)) continue;
                bl = true;
                this.parseTld(string2);
            }
        }
        if (bl) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)Localizer.getMessage("jsp.tldCache.tldInResourcePath", string));
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)Localizer.getMessage("jsp.tldCache.noTldInResourcePath", string));
        }
    }

    public void scanJars() {
        JarScanner jarScanner = JarScannerFactory.getJarScanner(this.context);
        TldScannerCallback tldScannerCallback = new TldScannerCallback();
        jarScanner.scan(JarScanType.TLD, this.context, (JarScannerCallback)tldScannerCallback);
        if (tldScannerCallback.scanFoundNoTLDs()) {
            this.log.info((Object)Localizer.getMessage("jsp.tldCache.noTldSummary"));
        }
    }

    protected void parseTld(String string) throws IOException, SAXException {
        TldResourcePath tldResourcePath = new TldResourcePath(this.context.getResource(string), string);
        this.parseTld(tldResourcePath);
    }

    protected void parseTld(TldResourcePath tldResourcePath) throws IOException, SAXException {
        TaglibXml taglibXml = this.tldParser.parse(tldResourcePath);
        String string = taglibXml.getUri();
        if (string != null && !this.uriTldResourcePathMap.containsKey(string)) {
            this.uriTldResourcePathMap.put(string, tldResourcePath);
        }
        if (this.tldResourcePathTaglibXmlMap.containsKey(tldResourcePath)) {
            return;
        }
        this.tldResourcePathTaglibXmlMap.put(tldResourcePath, taglibXml);
        if (taglibXml.getListeners() != null) {
            this.listeners.addAll(taglibXml.getListeners());
        }
    }

    class TldScannerCallback
    implements JarScannerCallback {
        private boolean foundJarWithoutTld = false;
        private boolean foundFileWithoutTld = false;

        TldScannerCallback() {
        }

        public void scan(Jar jar, String string, boolean bl) throws IOException {
            boolean bl2 = false;
            URL uRL = jar.getJarFileURL();
            jar.nextEntry();
            String string2 = jar.getEntryName();
            while (string2 != null) {
                if (string2.startsWith("META-INF/") && string2.endsWith(TldScanner.TLD_EXT)) {
                    bl2 = true;
                    TldResourcePath tldResourcePath = new TldResourcePath(uRL, string, string2);
                    try {
                        TldScanner.this.parseTld(tldResourcePath);
                    }
                    catch (SAXException sAXException) {
                        throw new IOException(sAXException);
                    }
                }
                jar.nextEntry();
                string2 = jar.getEntryName();
            }
            if (bl2) {
                if (TldScanner.this.log.isTraceEnabled()) {
                    TldScanner.this.log.trace((Object)Localizer.getMessage("jsp.tldCache.tldInJar", uRL.toString()));
                }
            } else {
                this.foundJarWithoutTld = true;
                if (TldScanner.this.log.isTraceEnabled()) {
                    TldScanner.this.log.trace((Object)Localizer.getMessage("jsp.tldCache.noTldInJar", uRL.toString()));
                }
            }
        }

        public void scan(File file, final String string, boolean bl) throws IOException {
            File file2 = new File(file, "META-INF");
            if (!file2.isDirectory()) {
                return;
            }
            this.foundFileWithoutTld = false;
            final Path path = file.toPath();
            Files.walkFileTree(file2.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                    Object object;
                    String string2;
                    Path path2 = path3.getFileName();
                    if (path2 == null || !path2.toString().toLowerCase(Locale.ENGLISH).endsWith(TldScanner.TLD_EXT)) {
                        return FileVisitResult.CONTINUE;
                    }
                    TldScannerCallback.this.foundFileWithoutTld = true;
                    if (string == null) {
                        string2 = null;
                    } else {
                        object = path3.subpath(path.getNameCount(), path3.getNameCount()).toString();
                        if ('/' != File.separatorChar) {
                            object = ((String)object).replace(File.separatorChar, '/');
                        }
                        string2 = string + "/" + (String)object;
                    }
                    try {
                        object = path3.toUri().toURL();
                        TldResourcePath tldResourcePath = new TldResourcePath((URL)object, string2);
                        TldScanner.this.parseTld(tldResourcePath);
                    }
                    catch (SAXException sAXException) {
                        throw new IOException(sAXException);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (this.foundFileWithoutTld) {
                if (TldScanner.this.log.isTraceEnabled()) {
                    TldScanner.this.log.trace((Object)Localizer.getMessage("jsp.tldCache.tldInDir", file.getAbsolutePath()));
                }
            } else if (TldScanner.this.log.isTraceEnabled()) {
                TldScanner.this.log.trace((Object)Localizer.getMessage("jsp.tldCache.noTldInDir", file.getAbsolutePath()));
            }
        }

        public void scanWebInfClasses() throws IOException {
            Set set = TldScanner.this.context.getResourcePaths("/WEB-INF/classes/META-INF");
            if (set == null) {
                return;
            }
            for (String string : set) {
                if (!string.endsWith(TldScanner.TLD_EXT)) continue;
                try {
                    TldScanner.this.parseTld(string);
                }
                catch (SAXException sAXException) {
                    throw new IOException(sAXException);
                }
            }
        }

        boolean scanFoundNoTLDs() {
            return this.foundJarWithoutTld;
        }
    }
}

