/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.EndpointInfo;
import com.zeroc.Ice.EndpointParseException;
import com.zeroc.Ice.EndpointSelectionType;
import com.zeroc.Ice.FormatType;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.OpaqueEndpointInfo;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.Util;
import com.zeroc.Ice.VersionParseException;
import com.zeroc.IceInternal.Acceptor;
import com.zeroc.IceInternal.Connector;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.EndpointI_connectors;
import com.zeroc.IceInternal.HashUtil;
import com.zeroc.IceInternal.Transceiver;
import com.zeroc.IceUtilInternal.Base64;
import java.util.ArrayList;
import java.util.List;

final class OpaqueEndpointI
extends EndpointI {
    private short _type;
    private EncodingVersion _rawEncoding;
    private byte[] _rawBytes;
    private int _hashCode;

    public OpaqueEndpointI(ArrayList<String> args) {
        this._type = (short)-1;
        this._rawEncoding = Util.Encoding_1_0;
        this._rawBytes = new byte[0];
        this.initWithOptions(args);
        if (this._type < 0) {
            throw new EndpointParseException("no -t option in endpoint " + this.toString());
        }
        if (this._rawBytes.length == 0) {
            throw new EndpointParseException("no -v option in endpoint " + this.toString());
        }
        this.calcHashValue();
    }

    public OpaqueEndpointI(short type, InputStream s) {
        this._type = type;
        this._rawEncoding = s.getEncoding();
        int sz = s.getEncapsulationSize();
        this._rawBytes = s.readBlob(sz);
        this.calcHashValue();
    }

    @Override
    public void streamWrite(OutputStream s) {
        s.startEncapsulation(this._rawEncoding, FormatType.DefaultFormat);
        s.writeBlob(this._rawBytes);
        s.endEncapsulation();
    }

    @Override
    public void streamWriteImpl(OutputStream s) {
        assert (false);
    }

    @Override
    public EndpointInfo getInfo() {
        return new OpaqueEndpointInfo(null, -1, false, this._rawEncoding, this._rawBytes){

            @Override
            public short type() {
                return OpaqueEndpointI.this._type;
            }

            @Override
            public boolean datagram() {
                return false;
            }

            @Override
            public boolean secure() {
                return false;
            }
        };
    }

    @Override
    public short type() {
        return this._type;
    }

    @Override
    public String protocol() {
        return "opaque";
    }

    @Override
    public int timeout() {
        return -1;
    }

    @Override
    public EndpointI timeout(int t) {
        return this;
    }

    @Override
    public String connectionId() {
        return "";
    }

    @Override
    public EndpointI connectionId(String connectionId) {
        return this;
    }

    @Override
    public boolean compress() {
        return false;
    }

    @Override
    public EndpointI compress(boolean compress) {
        return this;
    }

    @Override
    public boolean datagram() {
        return false;
    }

    @Override
    public boolean secure() {
        return false;
    }

    @Override
    public Transceiver transceiver() {
        return null;
    }

    @Override
    public void connectors_async(EndpointSelectionType selType, EndpointI_connectors callback) {
        callback.connectors(new ArrayList<Connector>());
    }

    @Override
    public Acceptor acceptor(String adapterName) {
        return null;
    }

    @Override
    public List<EndpointI> expandIfWildcard() {
        ArrayList<EndpointI> endps = new ArrayList<EndpointI>();
        endps.add(this);
        return endps;
    }

    @Override
    public EndpointI.ExpandHostResult expandHost() {
        EndpointI.ExpandHostResult result = new EndpointI.ExpandHostResult(this);
        result.endpoints = new ArrayList<EndpointI>();
        result.endpoints.add(this);
        return result;
    }

    @Override
    public boolean equivalent(EndpointI endpoint) {
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public String options() {
        String s = "";
        if (this._type > -1) {
            s = s + " -t " + this._type;
        }
        s = s + " -e " + Util.encodingVersionToString(this._rawEncoding);
        if (this._rawBytes.length > 0) {
            s = s + " -v " + Base64.encode(this._rawBytes);
        }
        return s;
    }

    @Override
    public int compareTo(EndpointI obj) {
        if (!(obj instanceof OpaqueEndpointI)) {
            return this.type() < obj.type() ? -1 : 1;
        }
        OpaqueEndpointI p = (OpaqueEndpointI)obj;
        if (this == p) {
            return 0;
        }
        if (this._type < p._type) {
            return -1;
        }
        if (p._type < this._type) {
            return 1;
        }
        if (this._rawEncoding.major < p._rawEncoding.major) {
            return -1;
        }
        if (p._rawEncoding.major < this._rawEncoding.major) {
            return 1;
        }
        if (this._rawEncoding.minor < p._rawEncoding.minor) {
            return -1;
        }
        if (p._rawEncoding.minor < this._rawEncoding.minor) {
            return 1;
        }
        if (this._rawBytes.length < p._rawBytes.length) {
            return -1;
        }
        if (p._rawBytes.length < this._rawBytes.length) {
            return 1;
        }
        for (int i = 0; i < this._rawBytes.length; ++i) {
            if (this._rawBytes[i] < p._rawBytes[i]) {
                return -1;
            }
            if (p._rawBytes[i] >= this._rawBytes[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    protected boolean checkOption(String option, String argument, String endpoint) {
        switch (option.charAt(1)) {
            case 't': {
                int t;
                if (this._type > -1) {
                    throw new EndpointParseException("multiple -t options in endpoint " + endpoint);
                }
                if (argument == null) {
                    throw new EndpointParseException("no argument provided for -t option in endpoint " + endpoint);
                }
                try {
                    t = Integer.parseInt(argument);
                }
                catch (NumberFormatException ex) {
                    throw new EndpointParseException("invalid type value `" + argument + "' in endpoint " + endpoint);
                }
                if (t < 0 || t > 65535) {
                    throw new EndpointParseException("type value `" + argument + "' out of range in endpoint " + endpoint);
                }
                this._type = (short)t;
                return true;
            }
            case 'v': {
                if (this._rawBytes.length > 0) {
                    throw new EndpointParseException("multiple -v options in endpoint " + endpoint);
                }
                if (argument == null) {
                    throw new EndpointParseException("no argument provided for -v option in endpoint " + endpoint);
                }
                try {
                    this._rawBytes = Base64.decode(argument);
                }
                catch (IllegalArgumentException ex) {
                    throw new EndpointParseException("base64 decoding failed in endpoint " + endpoint, ex);
                }
                return true;
            }
            case 'e': {
                if (argument == null) {
                    throw new EndpointParseException("no argument provided for -e option in endpoint " + endpoint);
                }
                try {
                    this._rawEncoding = Util.stringToEncodingVersion(argument);
                }
                catch (VersionParseException e) {
                    throw new EndpointParseException("invalid encoding version `" + argument + "' in endpoint " + endpoint + ":\n" + e.str);
                }
                return true;
            }
        }
        return false;
    }

    private void calcHashValue() {
        int h = 5381;
        h = HashUtil.hashAdd(h, this._type);
        h = HashUtil.hashAdd(h, this._rawEncoding);
        this._hashCode = h = HashUtil.hashAdd(h, this._rawBytes);
    }
}

