---
stage: GitLab Dedicated
group: Environment Automation
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLab Dedicatedインスタンスの目標リカバリー、フェイルオーバープロセス、およびリージョンバックアップ戦略。
title: GitLab Dedicatedのディザスターリカバリー
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab Dedicated

{{< /details >}}

GitLab Dedicatedには、プライマリリージョンが使用できなくなった場合にインスタンスを復元するためのディザスターリカバリー機能が含まれています。

オンボーディング中に、複数のAWSリージョンにインスタンスをデプロイできます:

- インスタンスが実行されるプライマリリージョン。
- 選択した場合、プライマリリージョンで失敗が発生した場合にバックアップとして機能するセカンダリリージョン。
- データのバックアップがレプリケートされ、保護が強化されるバックアップリージョン。プライマリリージョンまたはセカンダリリージョンと同じリージョンを使用することも、冗長性を高めるために別のリージョンを選択することもできます。

プライマリリージョンが停止または重大なシステム障害により使用できなくなった場合、GitLabはセカンダリリージョンへのフェイルオーバーを開始します。セカンダリリージョンが設定されていない場合、リカバリーではバックアップリージョンからのバックアップの復元が使用されます。

## 前提要件 {#prerequisites}

完全なリカバリー目標の対象となるには、以下が必要です:

- [オンボーディング](create_instance/_index.md)中に、プライマリリージョンとセカンダリリージョンの両方を指定します。セカンダリリージョンを指定しない場合、リカバリーはバックアップの復元に限定されます。
- 両方のリージョンが[GitLab Dedicatedでサポートされている](create_instance/data_residency_high_availability.md#primary-regions)ことを確認してください。[サポートが制限されている](create_instance/data_residency_high_availability.md#secondary-regions-with-limited-support)セカンダリリージョンを選択した場合、リカバリー時間と目標ポイントは適用されません。

## リカバリー目標 {#recovery-objectives}

GitLab Dedicatedは、これらのリカバリー目標によりディザスターリカバリーを提供します:

- 目標リカバリー時間（RTO）: サービスは、8時間以内にセカンダリリージョンに復元されます。
- 目標リカバリー時点（RPO）: データ損失は、最後のバックアップに対するディザスターの発生時期に応じて、最大4時間の最新の変更に制限されます。

## コンポーネント {#components}

GitLab Dedicatedは、ディザスターリカバリーのコミットメントを果たすために、2つの主要なコンポーネントを活用します:

- Geoレプリケーション
- 自動バックアップ

### Geoレプリケーション {#geo-replication}

GitLab Dedicatedにオンボーディングすると、環境のプライマリリージョンとセカンダリリージョンを選択します。Geoは、これらのリージョン間でデータを継続的にレプリケートします。内容は次のとおりです:

- データベースの内容
- リポジトリのストレージ
- オブジェクトストレージ

### 自動バックアップ {#automated-backups}

GitLabは、スナップショットを作成することにより、4時間ごと（1日6回）、すべてのGitLab Dedicatedデータストア（データベースおよびGitリポジトリを含む）の自動バックアップを実行します。

バックアップはテストされ、30日間保持され、選択したセカンダリリージョンに保存されます。また、保護を強化するためにAWSによって地理的にレプリケートされます。

データベースのバックアップ:

- 特定の時点でのリカバリーのために、プライマリリージョンで継続的なログベースのバックアップを使用します。
- セカンダリリージョンへのストリームレプリケーションにより、ほぼリアルタイムのコピーを提供します。

オブジェクトストレージのバックアップ:

- 地理的なレプリケーションとバージョニングを使用して、バックアップ保護を提供します。

これらのバックアップは、ディザスターリカバリー操作中のリカバリーポイントとして機能します。4時間のバックアップ頻度は、目標リカバリー時点（RPO）をサポートし、データの損失が4時間を超えないようにします。

## ディザスターカバレッジ {#disaster-coverage}

ディザスターリカバリーは、保証されたリカバリー目標により、次のシナリオを対象としています:

- 部分的なリージョンの停止（たとえば、アベイラビリティーゾーンの失敗）
- プライマリリージョンの完全な停止

ディザスターリカバリーは、保証されたリカバリー目標なしに、最善を尽くして次のシナリオに対応します:

- プライマリリージョンとセカンダリリージョンの両方の損失
- グローバルインターネット停止
- データの破損に関するイシュー

ディザスターリカバリーには、次のサービスの制限があります:

- 高度な検索インデックスは継続的にレプリケートされません。フェイルオーバー後、これらのインデックスはセカンダリリージョンがプロモートされると再構築されます。再構築中も基本的な検索は利用可能です。
- ClickHouse Cloudは、プライマリリージョンでのみプロビジョニングされます。プライマリリージョンが完全に停止している場合、このサービスを必要とする機能は利用できない場合があります。
- 本番環境のプレビュー環境には、セカンダリインスタンスがありません。
- ホストされたランナーは、プライマリリージョンでのみサポートされており、セカンダリインスタンスで再構築することはできません。
- 一部のセカンダリリージョンはサポートが制限されており、RPOおよびRTOのターゲットの対象ではありません。これらのリージョンでは、AWSの制限により、フェイルオーバーインスタンスでのメール機能と耐性が制限されています。これらの制限は、ディザスターリカバリー時間とフェイルオーバー操作中の特定の機能にも影響を与える可能性があります。詳細については、[サポートが制限されているセカンダリリージョン](create_instance/data_residency_high_availability.md#secondary-regions-with-limited-support)を参照してください。

GitLabは以下を提供しません:

- フェイルオーバーイベントのプログラムによるモニタリング
- 顧客が開始したディザスターリカバリーテスト

## ディザスターリカバリーワークフロー {#disaster-recovery-workflow}

ディザスターリカバリーは、ほとんどのユーザーがインスタンスにアクセスできなくなった場合に開始されます。理由は次のとおりです:

- リージョンの完全な失敗（たとえば、AWSリージョンの停止）。
- 迅速にリカバリーできないGitLabサービスまたはインフラストラクチャの重大なコンポーネントの失敗。

### フェイルオーバープロセス {#failover-process}

インスタンスが使用できなくなると、GitLab Dedicatedチームは次の操作を行います:

1. モニタリングシステムによってアラートが送信されます。
1. フェイルオーバーが必要かどうかを調査します。
1. フェイルオーバーが必要な場合:
   1. フェイルオーバーが進行中であることを通知します。
   1. セカンダリリージョンをプロモートしてプライマリにします。
   1. `<customer>.gitlab-dedicated.com`のDNSレコードを更新して、新しくプロモートされたリージョンを指すようにします。
   1. フェイルオーバーが完了すると通知されます。

プライベートネットワーキングを使用する場合は、内部ネットワーキング設定を更新して、セカンダリリージョンのプライベートネットワーキングエンドポイントをターゲットにする必要があります。ダウンタイムを最小限に抑えるために、ディザスターが発生する前に、セカンダリリージョンで同等のプライベートネットワーキングエンドポイントを設定します。

フェイルオーバープロセスは、通常90分以内に完了します。

### ディザスター発生時のコミュニケーション {#communication-during-a-disaster}

ディザスターイベント中、GitLabは次の1つ以上の方法であなたと通信します:

- スイッチボードの運用連絡先情報
- Slack
- サポートチケット

GitLabは、リカバリープロセス全体を通してチームと連携するために、一時的なSlackチャンネルとZoomブリッジを確立する場合があります。

## 関連トピック {#related-topics}

- [データレジデンシーと高可用性](create_instance/data_residency_high_availability.md)
- [GitLab Dedicatedアーキテクチャ](architecture.md)
