---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Discord client secret'
---

## Description

The response body contains content that matches the pattern of a Discord client secret.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate a Discord client secret:

- Sign in and visit <https://discord.com/developers/applications/>.
- Select the application which the identified secret belongs to.
- Select the "OAuth 2" menu item in the left-hand side menu.
- Under the "Client information" section of the page, select "Reset Secret".
- When prompted, select "Yes, do it!".

For more information, please see [Discord's documentation on OAuth](https://discord.com/developers/docs/topics/oauth2).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.28 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
