/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.NumberUtils;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;

public class Altitude {
    private boolean _valid = false;
    private double _value = 0.0;
    private Unit _unit = null;
    private String _stringValue = null;
    public static final Altitude NONE = new Altitude(null, null);

    public Altitude(String string, Unit unit) {
        this.set(string, unit);
    }

    public Altitude(double d, Unit unit) {
        this._value = d;
        this._unit = unit;
        this._valid = true;
        this._stringValue = "" + d;
    }

    public Altitude(Altitude altitude) {
        this._value = altitude._value;
        this._unit = altitude._unit;
        this._valid = altitude._valid;
        this._stringValue = altitude._stringValue;
    }

    public void set(String string, Unit unit) {
        this._stringValue = string;
        this._unit = unit;
        String string2 = string == null ? "" : string.trim();
        Double d = NumberUtils.parseDoubleUsingLocale(string2);
        this._value = d != null ? d : 0.0;
        this._valid = d != null;
    }

    public boolean isValid() {
        return this._valid;
    }

    public double getValue() {
        return this._value;
    }

    public double getValue(Unit unit) {
        if (unit == null) {
            return this.getValue();
        }
        return this.getMetricValue() * unit.getMultFactorFromStd();
    }

    public int getIntValue(Unit unit) {
        return (int)Math.round(this.getValue(unit));
    }

    public Unit getUnit() {
        return this._unit;
    }

    public double getMetricValue() {
        if (this._unit == UnitSetLibrary.UNITS_METRES || this._unit == null) {
            return this._value;
        }
        return this._value / this._unit.getMultFactorFromStd();
    }

    public String getStringValue(Unit unit) {
        if (!this._valid) {
            return "";
        }
        if (!(unit != this._unit && unit != null || this._stringValue == null || this._stringValue.equals(""))) {
            return this._stringValue;
        }
        return "" + this.getValue(unit);
    }

    public String getLocalStringValue(Unit unit) {
        if (!this._valid) {
            return "";
        }
        return NumberUtils.formatNumberLocalToMatch(this.getValue(unit), this._stringValue);
    }

    public static Altitude interpolate(Altitude altitude, Altitude altitude2, int n, int n2) {
        return Altitude.interpolate(altitude, altitude2, 1.0 * (double)(n + 1) / (double)(n2 + 1));
    }

    public static Altitude interpolate(Altitude altitude, Altitude altitude2, double d) {
        if (altitude == null || altitude2 == null || !altitude.isValid() || !altitude2.isValid()) {
            return NONE;
        }
        Unit unit = altitude.getUnit();
        double d2 = altitude.getValue();
        double d3 = altitude2.getValue(unit);
        double d4 = d2 + (d3 - d2) * d;
        return new Altitude(d4, unit);
    }
}

