/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.xmlsec.signature.Signature;
import org.w3c.dom.Attr;

public abstract class StatusResponseTypeUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Override
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        StatusResponseType sr = (StatusResponseType)parentObject;
        if (childObject instanceof Issuer) {
            sr.setIssuer((Issuer)childObject);
        } else if (childObject instanceof Signature) {
            sr.setSignature((Signature)childObject);
        } else if (childObject instanceof Extensions) {
            sr.setExtensions((Extensions)childObject);
        } else if (childObject instanceof Status) {
            sr.setStatus((Status)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    @Override
    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        StatusResponseType sr = (StatusResponseType)xmlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("Version")) {
                sr.setVersion(this.parseSAMLVersion(attribute));
            } else if (attribute.getLocalName().equals("ID")) {
                sr.setID(attribute.getValue());
                attribute.getOwnerElement().setIdAttributeNode(attribute, true);
            } else if (attribute.getLocalName().equals("InResponseTo")) {
                sr.setInResponseTo(attribute.getValue());
            } else if (attribute.getLocalName().equals("IssueInstant") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                sr.setIssueInstant(DOMTypeSupport.stringToInstant(attribute.getValue()));
            } else if (attribute.getLocalName().equals("Destination")) {
                sr.setDestination(attribute.getValue());
            } else if (attribute.getLocalName().equals("Consent")) {
                sr.setConsent(attribute.getValue());
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            super.processAttribute(xmlObject, attribute);
        }
    }
}

