# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Optional
from typing_extensions import Literal

from ..._models import BaseModel

__all__ = ["ResponseCompactionItem"]


class ResponseCompactionItem(BaseModel):
    """
    A compaction item generated by the [`v1/responses/compact` API](https://platform.openai.com/docs/api-reference/responses/compact).
    """

    id: str
    """The unique ID of the compaction item."""

    encrypted_content: str
    """The encrypted content that was produced by compaction."""

    type: Literal["compaction"]
    """The type of the item. Always `compaction`."""

    created_by: Optional[str] = None
    """The identifier of the actor that created the item."""
