/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.el.MethodInfo;
import jakarta.el.MethodReference;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import org.apache.el.util.MessageFactory;
import org.apache.el.util.ReflectionUtil;

public class MethodExpressionLiteral
extends MethodExpression
implements Externalizable {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private Class<?> expectedType;
    private String expr;
    private Class<?>[] paramTypes;

    public MethodExpressionLiteral() {
    }

    public MethodExpressionLiteral(String string, Class<?> clazz, Class<?>[] classArray) {
        this.expr = string;
        this.expectedType = clazz;
        this.paramTypes = classArray;
    }

    public MethodInfo getMethodInfo(ELContext eLContext) throws ELException {
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        MethodInfo methodInfo = this.getMethodInfoInternal();
        eLContext.notifyAfterEvaluation(this.getExpressionString());
        return methodInfo;
    }

    private MethodInfo getMethodInfoInternal() throws ELException {
        return new MethodInfo(this.expr, this.expectedType, (Class[])this.paramTypes);
    }

    public Object invoke(ELContext eLContext, Object[] objectArray) throws ELException {
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        Object object = this.expectedType != null ? eLContext.convertToType((Object)this.expr, this.expectedType) : this.expr;
        eLContext.notifyAfterEvaluation(this.getExpressionString());
        return object;
    }

    public MethodReference getMethodReference(ELContext eLContext) {
        if (eLContext == null) {
            throw new NullPointerException(MessageFactory.get("error.context.null"));
        }
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        MethodReference methodReference = new MethodReference(null, this.getMethodInfoInternal(), EMPTY_ANNOTATION_ARRAY, EMPTY_OBJECT_ARRAY);
        eLContext.notifyAfterEvaluation(this.getExpressionString());
        return methodReference;
    }

    public String getExpressionString() {
        return this.expr;
    }

    public boolean equals(Object object) {
        return object instanceof MethodExpressionLiteral && this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        return this.expr.hashCode();
    }

    public boolean isLiteralText() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.expr = objectInput.readUTF();
        String string = objectInput.readUTF();
        if (!string.isEmpty()) {
            this.expectedType = ReflectionUtil.forName(string);
        }
        this.paramTypes = ReflectionUtil.toTypeArray((String[])objectInput.readObject());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.expr);
        objectOutput.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        objectOutput.writeObject(ReflectionUtil.toTypeNameArray(this.paramTypes));
    }
}

