/* Copyright (C) 2021-2024 Cisco Systems, Inc. and/or its affiliates. All rights reserved. */

#ifndef __CLAMAV_RUST_H
#define __CLAMAV_RUST_H

/* Warning, this file is autogenerated by cbindgen. Don't modify this manually. */

#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
#include "clamav.h"
#include "matcher-ac.h"
#include "htmlnorm.h"
typedef struct cli_matcher cli_matcher; typedef struct cli_ctx_tag cli_ctx;

typedef enum IndicatorType {
  /**
   * For hash-based indicators.
   */
  IndicatorType_Strong,
  /**
   * For potentially unwanted applications/programs that are not malicious but may be used maliciously.
   */
  IndicatorType_PotentiallyUnwanted,
  /**
   * Weak indicators that together with other indicators can be used to form a stronger indicator.
   * This type of indicator should NEVER alert the user on its own.
   */
  IndicatorType_Weak,
} IndicatorType;

/**
 * A generic container for any error that implements `Into<std::error::Error>`
 */
typedef struct FFIError FFIError;

bool script2cdiff(const char *script, const char *builder, const char *server);

/**
 * This function is only meant to be called from sigtool.c
 */
int32_t cdiff_apply(int32_t fd, uint16_t mode);

/**
 * C interface to handle HTML style blocks.
 *
 * This function looks through the style block for images found in HTML style blocks.
 * It will extract each image and scan it.
 *
 * # Safety
 *
 * `file_bytes` must not be NULL
 */
cl_error_t html_style_block_handler(cli_ctx *ctx, const char *file_bytes);

/**
 * Initialize a match vector
 */
evidence_t evidence_new(void);

/**
 * Free the evidence
 */
void evidence_free(evidence_t evidence);

/**
 * C interface for Evidence::render_verdict().
 * Handles all the unsafe ffi stuff.
 *
 * Render a verdict based on the evidence, depending on the severity of the
 * indicators found and the scan configuration.
 *
 * The individual alerting-indicators would have already been printed at this point.
 *
 * # Safety
 *
 * No parameters may be NULL
 */
bool evidence_render_verdict(evidence_t evidence);

/**
 * C interface to get a string name for one of the alerts.
 * Will first check for one from the strong indicators, then pua.
 *
 * # Safety
 *
 * Returns a string that is either static, or allocated when reading the database.
 * So the lifetime of the string is good at least until you reload or unload the databases.
 *
 * No parameters may be NULL
 */
const char *evidence_get_last_alert(evidence_t evidence);

/**
 * C interface to get a string name for one of the alerts.
 * Will first check for one from the strong indicators, then pua.
 *
 * # Safety
 *
 * Returns a string that is either static, or allocated when reading the database.
 * So the lifetime of the string is good at least until you reload or unload the databases.
 *
 * No parameters may be NULL
 */
const char *evidence_get_indicator(evidence_t evidence,
                                   enum IndicatorType indicator_type,
                                   uintptr_t index);

/**
 * C interface to check number of alerting indicators in evidence.
 *
 * # Safety
 *
 * No parameters may be NULL
 */
uintptr_t evidence_num_alerts(evidence_t evidence);

/**
 * C interface to check number of indicators in evidence.
 * Handles all the unsafe ffi stuff.
 *
 * # Safety
 *
 * No parameters may be NULL
 */
uintptr_t evidence_num_indicators_type(evidence_t evidence, enum IndicatorType indicator_type);

/**
 * C interface for Evidence::add_indicator().
 * Handles all the unsafe ffi stuff.
 *
 * Add an indicator to the evidence.
 *
 * # Safety
 *
 * `hexsig` and `err` must not be NULL
 */
bool evidence_add_indicator(evidence_t evidence,
                            const char *name,
                            enum IndicatorType indicator_type,
                            struct FFIError **err);

/**
 * Compute (and cache) a formatted error string from the provided [`FFIError`] pointer.
 *
 * # Safety
 *
 * `err` must not be NULL
 */
const char *ffierror_fmt(struct FFIError *err);

/**
 * Free a [`FFIError`] structure
 *
 * # Safety
 *
 * `err` must not be NULL
 */
void ffierror_free(struct FFIError *err);

/**
 * Initialize the hashmap
 */
fuzzyhashmap_t fuzzy_hashmap_new(void);

/**
 * Free the hashmap
 */
void fuzzy_hash_free_hashmap(fuzzyhashmap_t fuzzy_hashmap);

/**
 * C interface for FuzzyHashMap::check().
 * Handles all the unsafe ffi stuff.
 *
 * # Safety
 *
 * No parameters may be NULL
 */
bool fuzzy_hash_check(fuzzyhashmap_t fuzzy_hashmap,
                      cli_ac_data *mdata,
                      image_fuzzy_hash_t image_fuzzy_hash);

/**
 * C interface for FuzzyHashMap::load_subsignature().
 * Handles all the unsafe ffi stuff.
 *
 * # Safety
 *
 * `hexsig` and `err` must not be NULL
 */
bool fuzzy_hash_load_subsignature(fuzzyhashmap_t fuzzy_hashmap,
                                  const char *hexsig,
                                  uint32_t lsig_id,
                                  uint32_t subsig_id,
                                  struct FFIError **err);

/**
 * C interface for fuzzy_hash_calculate_image().
 * Handles all the unsafe ffi stuff.
 *
 * # Safety
 *
 * `file_bytes` and `hash_out` must not be NULL
 */
bool fuzzy_hash_calculate_image(const uint8_t *file_bytes,
                                uintptr_t file_size,
                                uint8_t *hash_out,
                                uintptr_t hash_out_len,
                                struct FFIError **err);

bool clrs_log_init(void);

/**
 * API exported for C code to log to standard error using Rust.
 * This would be an alternative to fputs, and reliably prints
 * non-ASCII UTF8 characters on Windows, where fputs does not.
 *
 * # Safety
 *
 * This function dereferences the c_buff raw pointer. Pointer must be valid.
 */
void clrs_eprint(const char *c_buf);

/**
 * Scan a OneNote file for attachments
 *
 * # Safety
 *
 * Must be a valid ctx pointer.
 */
cl_error_t scan_onenote(cli_ctx *ctx);

/**
 * Scan the contents of a LHA or LZH archive
 *
 * # Safety
 *
 * Must be a valid ctx pointer.
 */
cl_error_t scan_lha_lzh(cli_ctx *ctx);

/**
 * Scan an Alz file for attachments
 *
 * # Safety
 *
 * Must be a valid ctx pointer.
 */
cl_error_t cli_scanalz(cli_ctx *ctx);

#endif /* __CLAMAV_RUST_H */
