// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomWebauthnMetrics_h
#define mozilla_GleanDomWebauthnMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace webauthn_create {
  /**
   * generated from webauthn_create.authenticator_attachment
   */
  enum class AuthenticatorAttachmentLabel: uint16_t {
    eCrossPlatform = 0,
    ePlatform = 1,
    eUnknown = 2,
    e__Other__,
  };
  /**
   * The number of successfully created credentials by authenticator attachment modality.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, AuthenticatorAttachmentLabel> authenticator_attachment(3887);

  /**
   * generated from webauthn_create.failure
   * The total number of failed calls to navigator.credentials.create.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> failure(3888);

  /**
   * generated from webauthn_create.passkey
   * The number of client-side discoverable credentials (passkeys) created.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> passkey(3889);

  /**
   * generated from webauthn_create.success
   * The total number of successful calls to navigator.credentials.create.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> success(3890);
}

namespace webauthn_get {
  /**
   * generated from webauthn_get.authenticator_attachment
   */
  enum class AuthenticatorAttachmentLabel: uint16_t {
    eCrossPlatform = 0,
    ePlatform = 1,
    eUnknown = 2,
    e__Other__,
  };
  /**
   * The number of successfully asserted credentials by authenticator attachment modality.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, AuthenticatorAttachmentLabel> authenticator_attachment(3891);

  /**
   * generated from webauthn_get.failure
   * The total number of failed calls to navigator.credentials.get.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> failure(3892);

  /**
   * generated from webauthn_get.success
   * The total number of successful calls to navigator.credentials.get.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> success(3893);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomWebauthnMetrics_h
