/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM CloseEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "CloseEvent.h"
#include "CloseEventBinding.h"
#include "EventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/CloseEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


CloseEvent::CloseEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

CloseEvent::~CloseEvent()
{
}

CloseEvent*
CloseEvent::AsCloseEvent()
{
  return this;
}

JSObject*
CloseEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return CloseEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<CloseEvent>
CloseEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const CloseEventInit& aEventInitDict)
{
  RefPtr<CloseEvent> e = new CloseEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mWasClean = aEventInitDict.mWasClean;
  e->mCode = aEventInitDict.mCode;
  e->mReason = aEventInitDict.mReason;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<CloseEvent>
CloseEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const CloseEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

bool
CloseEvent::WasClean() const
{
  return mWasClean;
}

uint16_t
CloseEvent::Code() const
{
  return mCode;
}

void
CloseEvent::GetReason(nsString& aRetVal) const
{
  aRetVal = mReason;
}


} // namespace mozilla::dom
