/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM TCPSocketErrorEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "TCPSocketErrorEvent.h"
#include "TCPSocketErrorEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/TCPSocket.h"
#include "mozilla/dom/TCPSocketErrorEvent.h"

namespace mozilla::dom {


TCPSocketErrorEvent::TCPSocketErrorEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

TCPSocketErrorEvent::~TCPSocketErrorEvent()
{
}

TCPSocketErrorEvent*
TCPSocketErrorEvent::AsTCPSocketErrorEvent()
{
  return this;
}

JSObject*
TCPSocketErrorEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return TCPSocketErrorEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<TCPSocketErrorEvent>
TCPSocketErrorEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const TCPSocketErrorEventInit& aEventInitDict)
{
  RefPtr<TCPSocketErrorEvent> e = new TCPSocketErrorEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mName = aEventInitDict.mName;
  e->mMessage = aEventInitDict.mMessage;
  e->mErrorCode = aEventInitDict.mErrorCode;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<TCPSocketErrorEvent>
TCPSocketErrorEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const TCPSocketErrorEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
TCPSocketErrorEvent::GetName(nsString& aRetVal) const
{
  aRetVal = mName;
}

void
TCPSocketErrorEvent::GetMessage(nsString& aRetVal) const
{
  aRetVal = mMessage;
}

uint32_t
TCPSocketErrorEvent::ErrorCode() const
{
  return mErrorCode;
}


} // namespace mozilla::dom
