/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM TaskPriorityChangeEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "TaskPriorityChangeEvent.h"
#include "TaskPriorityChangeEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/TaskPriorityChangeEvent.h"

namespace mozilla::dom {


TaskPriorityChangeEvent::TaskPriorityChangeEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

TaskPriorityChangeEvent::~TaskPriorityChangeEvent()
{
}

TaskPriorityChangeEvent*
TaskPriorityChangeEvent::AsTaskPriorityChangeEvent()
{
  return this;
}

JSObject*
TaskPriorityChangeEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return TaskPriorityChangeEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<TaskPriorityChangeEvent>
TaskPriorityChangeEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const TaskPriorityChangeEventInit& aPriorityChangeEventInitDict)
{
  RefPtr<TaskPriorityChangeEvent> e = new TaskPriorityChangeEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aPriorityChangeEventInitDict.mBubbles, aPriorityChangeEventInitDict.mCancelable);
  e->mPreviousPriority = aPriorityChangeEventInitDict.mPreviousPriority;
  e->SetTrusted(trusted);
  e->SetComposed(aPriorityChangeEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<TaskPriorityChangeEvent>
TaskPriorityChangeEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const TaskPriorityChangeEventInit& aPriorityChangeEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aPriorityChangeEventInitDict);
}

TaskPriority
TaskPriorityChangeEvent::PreviousPriority() const
{
  return mPreviousPriority;
}


} // namespace mozilla::dom
