#include <wtf/FastMalloc.h>
#include <wtf/Noncopyable.h>
#include <JavaScriptCore/JSCInlines.h>

#pragma once

namespace WebCore {

enum class DOMConstructorID : uint16_t {
    InternalSettingsGenerated,
    BarcodeDetector,
    FaceDetector,
    TextDetector,
    GPU,
    GPUAdapter,
    GPUAdapterInfo,
    GPUBindGroup,
    GPUBindGroupLayout,
    GPUBuffer,
    GPUBufferUsage,
    GPUColorWrite,
    GPUCommandBuffer,
    GPUCommandEncoder,
    GPUCompilationInfo,
    GPUCompilationMessage,
    GPUComputePassEncoder,
    GPUComputePipeline,
    GPUDevice,
    GPUDeviceLostInfo,
    GPUExternalTexture,
    GPUInternalError,
    GPUMapMode,
    GPUOutOfMemoryError,
    GPUPipelineError,
    GPUPipelineLayout,
    GPUQuerySet,
    GPUQueue,
    GPURenderBundle,
    GPURenderBundleEncoder,
    GPURenderPassEncoder,
    GPURenderPipeline,
    GPUSampler,
    GPUShaderModule,
    GPUShaderStage,
    GPUSupportedFeatures,
    GPUSupportedLimits,
    GPUTexture,
    GPUTextureUsage,
    GPUTextureView,
    GPUUncapturedErrorEvent,
    GPUValidationError,
    WGSLLanguageFeatures,
    WebKitPlaybackTargetAvailabilityEvent,
    Clipboard,
    ClipboardItem,
    DOMAudioSession,
    DOMCache,
    DOMCacheStorage,
    CompressionStream,
    CompressionStreamEncoder,
    DecompressionStream,
    DecompressionStreamDecoder,
    ContactsManager,
    CookieChangeEvent,
    CookieStore,
    CookieStoreManager,
    ExtendableCookieChangeEvent,
    BasicCredential,
    CredentialsContainer,
    MediaKeyMessageEvent,
    MediaKeySession,
    MediaKeyStatusMap,
    MediaKeySystemAccess,
    MediaKeys,
    WebKitMediaKeyMessageEvent,
    WebKitMediaKeyNeededEvent,
    WebKitMediaKeySession,
    WebKitMediaKeys,
    DOMFileSystem,
    FileSystemDirectoryEntry,
    FileSystemDirectoryReader,
    FileSystemEntry,
    FileSystemFileEntry,
    FetchHeaders,
    FetchRequest,
    FetchResponse,
    FileSystemDirectoryHandle,
    FileSystemFileHandle,
    FileSystemHandle,
    FileSystemSyncAccessHandle,
    Gamepad,
    GamepadButton,
    GamepadEvent,
    GamepadHapticActuator,
    Geolocation,
    GeolocationCoordinates,
    GeolocationPosition,
    GeolocationPositionError,
    Highlight,
    HighlightRegistry,
    DigitalCredential,
    IDBCursor,
    IDBCursorWithValue,
    IDBDatabase,
    IDBFactory,
    IDBIndex,
    IDBKeyRange,
    IDBObjectStore,
    IDBOpenDBRequest,
    IDBRequest,
    IDBTransaction,
    IDBVersionChangeEvent,
    MediaCapabilities,
    MediaControlsHost,
    BlobEvent,
    MediaRecorder,
    MediaRecorderErrorEvent,
    MediaMetadata,
    MediaSession,
    MediaSessionCoordinator,
    BufferedChangeEvent,
    ManagedMediaSource,
    ManagedSourceBuffer,
    MediaSource,
    MediaSourceHandle,
    SourceBuffer,
    SourceBufferList,
    VideoPlaybackQuality,
    CanvasCaptureMediaStreamTrack,
    ImageCapture,
    InputDeviceInfo,
    MediaDeviceInfo,
    MediaDevices,
    MediaStream,
    MediaStreamTrack,
    MediaStreamTrackEvent,
    MediaStreamTrackProcessor,
    OverconstrainedError,
    OverconstrainedErrorEvent,
    RTCCertificate,
    RTCDTMFSender,
    RTCDTMFToneChangeEvent,
    RTCDataChannel,
    RTCDataChannelEvent,
    RTCDtlsTransport,
    RTCEncodedAudioFrame,
    RTCEncodedVideoFrame,
    RTCError,
    RTCErrorEvent,
    RTCIceCandidate,
    RTCIceTransport,
    RTCPeerConnection,
    RTCPeerConnectionIceErrorEvent,
    RTCPeerConnectionIceEvent,
    RTCRtpReceiver,
    RTCRtpSFrameTransform,
    RTCRtpSFrameTransformErrorEvent,
    RTCRtpScriptTransform,
    RTCRtpScriptTransformer,
    RTCRtpSender,
    RTCRtpTransceiver,
    RTCSctpTransport,
    RTCSessionDescription,
    RTCStatsReport,
    RTCTrackEvent,
    RTCTransformEvent,
    VideoTrackGenerator,
    HTMLModelElement,
    Notification,
    NotificationEvent,
    MerchantValidationEvent,
    PaymentAddress,
    PaymentMethodChangeEvent,
    PaymentRequest,
    PaymentRequestUpdateEvent,
    PaymentResponse,
    PermissionStatus,
    Permissions,
    PictureInPictureEvent,
    PictureInPictureWindow,
    PushEvent,
    PushManager,
    PushMessageData,
    PushNotificationEvent,
    PushSubscription,
    PushSubscriptionChangeEvent,
    PushSubscriptionOptions,
    RemotePlayback,
    DeprecationReportBody,
    Report,
    ReportBody,
    ReportingObserver,
    TestReportBody,
    WakeLock,
    WakeLockSentinel,
    SpeechRecognition,
    SpeechRecognitionAlternative,
    SpeechRecognitionErrorEvent,
    SpeechRecognitionEvent,
    SpeechRecognitionResult,
    SpeechRecognitionResultList,
    SpeechSynthesis,
    SpeechSynthesisErrorEvent,
    SpeechSynthesisEvent,
    SpeechSynthesisUtterance,
    SpeechSynthesisVoice,
    StorageManager,
    ByteLengthQueuingStrategy,
    CountQueuingStrategy,
    ReadableByteStreamController,
    ReadableStream,
    ReadableStreamBYOBReader,
    ReadableStreamBYOBRequest,
    ReadableStreamDefaultController,
    ReadableStreamDefaultReader,
    ReadableStreamSink,
    ReadableStreamSource,
    TransformStream,
    TransformStreamDefaultController,
    WritableStream,
    WritableStreamDefaultController,
    WritableStreamDefaultWriter,
    WritableStreamSink,
    WebLock,
    WebLockManager,
    AnalyserNode,
    AudioBuffer,
    AudioBufferSourceNode,
    AudioContext,
    AudioDestinationNode,
    AudioListener,
    AudioNode,
    AudioParam,
    AudioParamMap,
    AudioProcessingEvent,
    AudioScheduledSourceNode,
    AudioWorklet,
    AudioWorkletGlobalScope,
    AudioWorkletNode,
    AudioWorkletProcessor,
    BaseAudioContext,
    BiquadFilterNode,
    ChannelMergerNode,
    ChannelSplitterNode,
    ConstantSourceNode,
    ConvolverNode,
    DelayNode,
    DynamicsCompressorNode,
    GainNode,
    IIRFilterNode,
    MediaElementAudioSourceNode,
    MediaStreamAudioDestinationNode,
    MediaStreamAudioSourceNode,
    OfflineAudioCompletionEvent,
    OfflineAudioContext,
    OscillatorNode,
    PannerNode,
    PeriodicWave,
    ScriptProcessorNode,
    StereoPannerNode,
    WaveShaperNode,
    AuthenticatorAssertionResponse,
    AuthenticatorAttestationResponse,
    AuthenticatorResponse,
    PublicKeyCredential,
    VideoColorSpace,
    WebCodecsAudioData,
    WebCodecsAudioDecoder,
    WebCodecsAudioEncoder,
    WebCodecsEncodedAudioChunk,
    WebCodecsEncodedVideoChunk,
    WebCodecsVideoDecoder,
    WebCodecsVideoEncoder,
    WebCodecsVideoFrame,
    Database,
    SQLError,
    SQLResultSet,
    SQLResultSetRowList,
    SQLTransaction,
    CloseEvent,
    WebSocket,
    WebTransport,
    WebTransportBidirectionalStream,
    WebTransportDatagramDuplexStream,
    WebTransportError,
    WebTransportReceiveStream,
    WebTransportSendStream,
    WebXRBoundedReferenceSpace,
    WebXRFrame,
    WebXRHand,
    WebXRInputSource,
    WebXRInputSourceArray,
    WebXRJointPose,
    WebXRJointSpace,
    WebXRLayer,
    WebXRPose,
    WebXRReferenceSpace,
    WebXRRenderState,
    WebXRRigidTransform,
    WebXRSession,
    WebXRSpace,
    WebXRSystem,
    WebXRView,
    WebXRViewerPose,
    WebXRViewport,
    WebXRWebGLLayer,
    XRCompositionLayer,
    XRCubeLayer,
    XRCylinderLayer,
    XREquirectLayer,
    XRGPUBinding,
    XRGPUSubImage,
    XRInputSourceEvent,
    XRInputSourcesChangeEvent,
    XRLayerEvent,
    XRProjectionLayer,
    XRQuadLayer,
    XRReferenceSpaceEvent,
    XRSessionEvent,
    XRSubImage,
    XRWebGLBinding,
    XRWebGLSubImage,
    AnimationEffect,
    AnimationPlaybackEvent,
    AnimationTimeline,
    CSSAnimation,
    CSSAnimationEvent,
    CSSTransition,
    CSSTransitionEvent,
    CustomEffect,
    DocumentTimeline,
    KeyframeEffect,
    ScrollTimeline,
    ViewTimeline,
    WebAnimation,
    CryptoKey,
    SubtleCrypto,
    CSSConditionRule,
    CSSContainerRule,
    CSSCounterStyleRule,
    CSSFontFaceRule,
    CSSFontFeatureValuesRule,
    CSSFontPaletteValuesRule,
    CSSGroupingRule,
    CSSImportRule,
    CSSKeyframeRule,
    CSSKeyframesRule,
    CSSLayerBlockRule,
    CSSLayerStatementRule,
    CSSMediaRule,
    CSSNamespaceRule,
    CSSPageRule,
    CSSPaintSize,
    CSSPropertyRule,
    CSSRule,
    CSSRuleList,
    CSSScopeRule,
    CSSStartingStyleRule,
    CSSStyleDeclaration,
    CSSStyleRule,
    CSSStyleSheet,
    CSSSupportsRule,
    CSSUnknownRule,
    CSSViewTransitionRule,
    DOMCSSNamespace,
    DOMMatrix,
    DOMMatrixReadOnly,
    DeprecatedCSSOMCounter,
    DeprecatedCSSOMPrimitiveValue,
    DeprecatedCSSOMRGBColor,
    DeprecatedCSSOMRect,
    DeprecatedCSSOMValue,
    DeprecatedCSSOMValueList,
    FontFace,
    FontFaceSet,
    MediaList,
    MediaQueryList,
    MediaQueryListEvent,
    StyleMedia,
    StyleSheet,
    StyleSheetList,
    CSSKeywordValue,
    CSSNumericValue,
    CSSOMVariableReferenceValue,
    CSSStyleImageValue,
    CSSStyleValue,
    CSSUnitValue,
    CSSUnparsedValue,
    StylePropertyMap,
    StylePropertyMapReadOnly,
    CSSColor,
    CSSColorValue,
    CSSHSL,
    CSSHWB,
    CSSLCH,
    CSSLab,
    CSSOKLCH,
    CSSOKLab,
    CSSRGB,
    CSSMathClamp,
    CSSMathInvert,
    CSSMathMax,
    CSSMathMin,
    CSSMathNegate,
    CSSMathProduct,
    CSSMathSum,
    CSSMathValue,
    CSSNumericArray,
    CSSMatrixComponent,
    CSSPerspective,
    CSSRotate,
    CSSScale,
    CSSSkew,
    CSSSkewX,
    CSSSkewY,
    CSSTransformComponent,
    CSSTransformValue,
    CSSTranslate,
    AbortController,
    AbortSignal,
    AbstractRange,
    Attr,
    BeforeUnloadEvent,
    BroadcastChannel,
    CDATASection,
    CharacterData,
    ClipboardEvent,
    CommandEvent,
    Comment,
    CompositionEvent,
    ContentVisibilityAutoStateChangeEvent,
    CustomElementRegistry,
    CustomEvent,
    CustomStateSet,
    DOMException,
    DOMImplementation,
    DOMPoint,
    DOMPointReadOnly,
    DOMQuad,
    DOMRect,
    DOMRectList,
    DOMRectReadOnly,
    DOMStringList,
    DOMStringMap,
    DataTransfer,
    DataTransferItem,
    DataTransferItemList,
    DeviceMotionEvent,
    DeviceOrientationEvent,
    Document,
    DocumentFragment,
    DocumentType,
    DragEvent,
    Element,
    ElementInternals,
    ErrorEvent,
    Event,
    EventTarget,
    FocusEvent,
    FormDataEvent,
    HashChangeEvent,
    IdleDeadline,
    InputEvent,
    KeyboardEvent,
    MessageChannel,
    MessageEvent,
    MessagePort,
    MouseEvent,
    MutationEvent,
    MutationObserver,
    MutationRecord,
    NamedNodeMap,
    Node,
    NodeFilter,
    NodeIterator,
    NodeList,
    Observable,
    PageRevealEvent,
    PageSwapEvent,
    PageTransitionEvent,
    PointerEvent,
    PopStateEvent,
    ProcessingInstruction,
    ProgressEvent,
    PromiseRejectionEvent,
    Range,
    SecurityPolicyViolationEvent,
    ShadowRoot,
    StaticRange,
    Subscriber,
    Text,
    TextDecoder,
    TextDecoderStream,
    TextDecoderStreamDecoder,
    TextEncoder,
    TextEncoderStream,
    TextEncoderStreamEncoder,
    TextEvent,
    ToggleEvent,
    Touch,
    TouchEvent,
    TouchList,
    TreeWalker,
    TrustedHTML,
    TrustedScript,
    TrustedScriptURL,
    TrustedTypePolicy,
    TrustedTypePolicyFactory,
    UIEvent,
    ViewTransition,
    ViewTransitionTypeSet,
    WheelEvent,
    XMLDocument,
    Blob,
    File,
    FileList,
    FileReader,
    FileReaderSync,
    DOMFormData,
    DOMTokenList,
    DOMURL,
    HTMLAllCollection,
    HTMLAnchorElement,
    HTMLAreaElement,
    HTMLAttachmentElement,
    HTMLAudioElement,
    HTMLAudioElementLegacyFactory,
    HTMLBRElement,
    HTMLBaseElement,
    HTMLBodyElement,
    HTMLButtonElement,
    HTMLCanvasElement,
    HTMLCollection,
    HTMLDListElement,
    HTMLDataElement,
    HTMLDataListElement,
    HTMLDetailsElement,
    HTMLDialogElement,
    HTMLDirectoryElement,
    HTMLDivElement,
    HTMLDocument,
    HTMLElement,
    HTMLEmbedElement,
    HTMLFieldSetElement,
    HTMLFontElement,
    HTMLFormControlsCollection,
    HTMLFormElement,
    HTMLFrameElement,
    HTMLFrameSetElement,
    HTMLHRElement,
    HTMLHeadElement,
    HTMLHeadingElement,
    HTMLHtmlElement,
    HTMLIFrameElement,
    HTMLImageElement,
    HTMLImageElementLegacyFactory,
    HTMLInputElement,
    HTMLLIElement,
    HTMLLabelElement,
    HTMLLegendElement,
    HTMLLinkElement,
    HTMLMapElement,
    HTMLMarqueeElement,
    HTMLMediaElement,
    HTMLMenuElement,
    HTMLMetaElement,
    HTMLMeterElement,
    HTMLModElement,
    HTMLOListElement,
    HTMLObjectElement,
    HTMLOptGroupElement,
    HTMLOptionElement,
    HTMLOptionElementLegacyFactory,
    HTMLOptionsCollection,
    HTMLOutputElement,
    HTMLParagraphElement,
    HTMLParamElement,
    HTMLPictureElement,
    HTMLPreElement,
    HTMLProgressElement,
    HTMLQuoteElement,
    HTMLScriptElement,
    HTMLSelectElement,
    HTMLSlotElement,
    HTMLSourceElement,
    HTMLSpanElement,
    HTMLStyleElement,
    HTMLTableCaptionElement,
    HTMLTableCellElement,
    HTMLTableColElement,
    HTMLTableElement,
    HTMLTableRowElement,
    HTMLTableSectionElement,
    HTMLTemplateElement,
    HTMLTextAreaElement,
    HTMLTimeElement,
    HTMLTitleElement,
    HTMLTrackElement,
    HTMLUListElement,
    HTMLUnknownElement,
    HTMLVideoElement,
    ImageBitmap,
    ImageData,
    MediaController,
    MediaEncryptedEvent,
    MediaError,
    OffscreenCanvas,
    RadioNodeList,
    SubmitEvent,
    TextMetrics,
    TimeRanges,
    URLSearchParams,
    UserActivation,
    ValidityState,
    WebKitMediaKeyError,
    ANGLEInstancedArrays,
    CanvasGradient,
    CanvasPattern,
    CanvasRenderingContext2D,
    EXTBlendMinMax,
    EXTClipControl,
    EXTColorBufferFloat,
    EXTColorBufferHalfFloat,
    EXTConservativeDepth,
    EXTDepthClamp,
    EXTDisjointTimerQuery,
    EXTDisjointTimerQueryWebGL2,
    EXTFloatBlend,
    EXTFragDepth,
    EXTPolygonOffsetClamp,
    EXTRenderSnorm,
    EXTShaderTextureLOD,
    EXTTextureCompressionBPTC,
    EXTTextureCompressionRGTC,
    EXTTextureFilterAnisotropic,
    EXTTextureMirrorClampToEdge,
    EXTTextureNorm16,
    EXTsRGB,
    GPUCanvasContext,
    ImageBitmapRenderingContext,
    KHRParallelShaderCompile,
    NVShaderNoperspectiveInterpolation,
    OESDrawBuffersIndexed,
    OESElementIndexUint,
    OESFBORenderMipmap,
    OESSampleVariables,
    OESShaderMultisampleInterpolation,
    OESStandardDerivatives,
    OESTextureFloat,
    OESTextureFloatLinear,
    OESTextureHalfFloat,
    OESTextureHalfFloatLinear,
    OESVertexArrayObject,
    OffscreenCanvasRenderingContext2D,
    PaintRenderingContext2D,
    Path2D,
    WebGL2RenderingContext,
    WebGLActiveInfo,
    WebGLBlendFuncExtended,
    WebGLBuffer,
    WebGLClipCullDistance,
    WebGLColorBufferFloat,
    WebGLCompressedTextureASTC,
    WebGLCompressedTextureETC,
    WebGLCompressedTextureETC1,
    WebGLCompressedTexturePVRTC,
    WebGLCompressedTextureS3TC,
    WebGLCompressedTextureS3TCsRGB,
    WebGLContextEvent,
    WebGLDebugRendererInfo,
    WebGLDebugShaders,
    WebGLDepthTexture,
    WebGLDrawBuffers,
    WebGLDrawInstancedBaseVertexBaseInstance,
    WebGLFramebuffer,
    WebGLLoseContext,
    WebGLMultiDraw,
    WebGLMultiDrawInstancedBaseVertexBaseInstance,
    WebGLPolygonMode,
    WebGLProgram,
    WebGLProvokingVertex,
    WebGLQuery,
    WebGLRenderSharedExponent,
    WebGLRenderbuffer,
    WebGLRenderingContext,
    WebGLSampler,
    WebGLShader,
    WebGLShaderPrecisionFormat,
    WebGLStencilTexturing,
    WebGLSync,
    WebGLTexture,
    WebGLTimerQueryEXT,
    WebGLTransformFeedback,
    WebGLUniformLocation,
    WebGLVertexArrayObject,
    WebGLVertexArrayObjectOES,
    AudioTrack,
    AudioTrackConfiguration,
    AudioTrackList,
    DataCue,
    TextTrack,
    TextTrackCue,
    TextTrackCueGeneric,
    TextTrackCueList,
    TextTrackList,
    TrackEvent,
    VTTCue,
    VTTRegion,
    VTTRegionList,
    VideoTrack,
    VideoTrackConfiguration,
    VideoTrackList,
    CommandLineAPIHost,
    InspectorAuditAccessibilityObject,
    InspectorAuditDOMObject,
    InspectorAuditResourcesObject,
    InspectorFrontendHost,
    COEPInheritenceViolationReportBody,
    CORPViolationReportBody,
    DOMApplicationCache,
    MathMLElement,
    MathMLMathElement,
    BarProp,
    Crypto,
    DOMSelection,
    DOMWindow,
    EventSource,
    FragmentDirective,
    History,
    IntersectionObserver,
    IntersectionObserverEntry,
    Location,
    NavigateEvent,
    Navigation,
    NavigationActivation,
    NavigationCurrentEntryChangeEvent,
    NavigationDestination,
    NavigationHistoryEntry,
    NavigationTransition,
    Navigator,
    Performance,
    PerformanceEntry,
    PerformanceMark,
    PerformanceMeasure,
    PerformanceNavigation,
    PerformanceNavigationTiming,
    PerformanceObserver,
    PerformanceObserverEntryList,
    PerformancePaintTiming,
    PerformanceResourceTiming,
    PerformanceServerTiming,
    PerformanceTiming,
    ResizeObserver,
    ResizeObserverEntry,
    ResizeObserverSize,
    Screen,
    ScreenOrientation,
    ShadowRealmGlobalScope,
    UndoItem,
    UndoManager,
    UserMessageHandler,
    UserMessageHandlersNamespace,
    VisualViewport,
    WebKitNamespace,
    WebKitPoint,
    WorkerNavigator,
    CSPViolationReportBody,
    DOMMimeType,
    DOMMimeTypeArray,
    DOMPlugin,
    DOMPluginArray,
    Storage,
    StorageEvent,
    SVGAElement,
    SVGAngle,
    SVGAnimateElement,
    SVGAnimateMotionElement,
    SVGAnimateTransformElement,
    SVGAnimatedAngle,
    SVGAnimatedBoolean,
    SVGAnimatedEnumeration,
    SVGAnimatedInteger,
    SVGAnimatedLength,
    SVGAnimatedLengthList,
    SVGAnimatedNumber,
    SVGAnimatedNumberList,
    SVGAnimatedPreserveAspectRatio,
    SVGAnimatedRect,
    SVGAnimatedString,
    SVGAnimatedTransformList,
    SVGAnimationElement,
    SVGCircleElement,
    SVGClipPathElement,
    SVGComponentTransferFunctionElement,
    SVGDefsElement,
    SVGDescElement,
    SVGElement,
    SVGEllipseElement,
    SVGFEBlendElement,
    SVGFEColorMatrixElement,
    SVGFEComponentTransferElement,
    SVGFECompositeElement,
    SVGFEConvolveMatrixElement,
    SVGFEDiffuseLightingElement,
    SVGFEDisplacementMapElement,
    SVGFEDistantLightElement,
    SVGFEDropShadowElement,
    SVGFEFloodElement,
    SVGFEFuncAElement,
    SVGFEFuncBElement,
    SVGFEFuncGElement,
    SVGFEFuncRElement,
    SVGFEGaussianBlurElement,
    SVGFEImageElement,
    SVGFEMergeElement,
    SVGFEMergeNodeElement,
    SVGFEMorphologyElement,
    SVGFEOffsetElement,
    SVGFEPointLightElement,
    SVGFESpecularLightingElement,
    SVGFESpotLightElement,
    SVGFETileElement,
    SVGFETurbulenceElement,
    SVGFilterElement,
    SVGForeignObjectElement,
    SVGGElement,
    SVGGeometryElement,
    SVGGradientElement,
    SVGGraphicsElement,
    SVGImageElement,
    SVGLength,
    SVGLengthList,
    SVGLineElement,
    SVGLinearGradientElement,
    SVGMPathElement,
    SVGMarkerElement,
    SVGMaskElement,
    SVGMatrix,
    SVGMetadataElement,
    SVGNumber,
    SVGNumberList,
    SVGPathElement,
    SVGPathSeg,
    SVGPathSegArcAbs,
    SVGPathSegArcRel,
    SVGPathSegClosePath,
    SVGPathSegCurvetoCubicAbs,
    SVGPathSegCurvetoCubicRel,
    SVGPathSegCurvetoCubicSmoothAbs,
    SVGPathSegCurvetoCubicSmoothRel,
    SVGPathSegCurvetoQuadraticAbs,
    SVGPathSegCurvetoQuadraticRel,
    SVGPathSegCurvetoQuadraticSmoothAbs,
    SVGPathSegCurvetoQuadraticSmoothRel,
    SVGPathSegLinetoAbs,
    SVGPathSegLinetoHorizontalAbs,
    SVGPathSegLinetoHorizontalRel,
    SVGPathSegLinetoRel,
    SVGPathSegLinetoVerticalAbs,
    SVGPathSegLinetoVerticalRel,
    SVGPathSegList,
    SVGPathSegMovetoAbs,
    SVGPathSegMovetoRel,
    SVGPatternElement,
    SVGPoint,
    SVGPointList,
    SVGPolygonElement,
    SVGPolylineElement,
    SVGPreserveAspectRatio,
    SVGRadialGradientElement,
    SVGRect,
    SVGRectElement,
    SVGSVGElement,
    SVGScriptElement,
    SVGSetElement,
    SVGStopElement,
    SVGStringList,
    SVGStyleElement,
    SVGSwitchElement,
    SVGSymbolElement,
    SVGTSpanElement,
    SVGTextContentElement,
    SVGTextElement,
    SVGTextPathElement,
    SVGTextPositioningElement,
    SVGTitleElement,
    SVGTransform,
    SVGTransformList,
    SVGUnitTypes,
    SVGUseElement,
    SVGViewElement,
    SVGViewSpec,
    GCObservation,
    InternalSettings,
    Internals,
    InternalsMapLike,
    InternalsSetLike,
    MallocStatistics,
    MemoryInfo,
    MockCDMFactory,
    MockContentFilterSettings,
    MockPageOverlay,
    ServiceWorkerInternals,
    TypeConversions,
    DedicatedWorkerGlobalScope,
    Worker,
    WorkerGlobalScope,
    WorkerLocation,
    ExtendableEvent,
    ExtendableMessageEvent,
    FetchEvent,
    NavigationPreloadManager,
    ServiceWorker,
    ServiceWorkerClient,
    ServiceWorkerClients,
    ServiceWorkerContainer,
    ServiceWorkerGlobalScope,
    ServiceWorkerRegistration,
    ServiceWorkerWindowClient,
    BackgroundFetchEvent,
    BackgroundFetchManager,
    BackgroundFetchRecord,
    BackgroundFetchRegistration,
    BackgroundFetchUpdateUIEvent,
    SharedWorker,
    SharedWorkerGlobalScope,
    PaintWorkletGlobalScope,
    Worklet,
    WorkletGlobalScope,
    CustomXPathNSResolver,
    DOMParser,
    XMLHttpRequest,
    XMLHttpRequestEventTarget,
    XMLHttpRequestProgressEvent,
    XMLHttpRequestUpload,
    XMLSerializer,
    XPathEvaluator,
    XPathExpression,
    XPathNSResolver,
    XPathResult,
    XSLTProcessor,
};

static constexpr unsigned numberOfDOMConstructors = 932;

class DOMConstructors {
    WTF_MAKE_NONCOPYABLE(DOMConstructors);
    WTF_MAKE_FAST_ALLOCATED(DOMConstructors);
public:
    using ConstructorArray = std::array<JSC::WriteBarrier<JSC::JSObject>, numberOfDOMConstructors>;
    DOMConstructors() = default;
    ConstructorArray& array() { return m_array; }
    const ConstructorArray& array() const { return m_array; }

private:
    ConstructorArray m_array { };
};

} // namespace WebCore
