/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleRule.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCSSRuleList.h"
#include "JSCSSStyleDeclaration.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSStylePropertyMap.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleRulePrototypeFunction_insertRule);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleRulePrototypeFunction_deleteRule);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleRuleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleRule_selectorText);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleRule_selectorText);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleRule_style);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleRule_style);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleRule_styleMap);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleRule_cssRules);

class JSCSSStyleRulePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSStyleRulePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSStyleRulePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSStyleRulePrototype>(vm)) JSCSSStyleRulePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStyleRulePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSStyleRulePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStyleRulePrototype, JSCSSStyleRulePrototype::Base);

using JSCSSStyleRuleDOMConstructor = JSDOMConstructorNotConstructable<JSCSSStyleRule>;

template<> const ClassInfo JSCSSStyleRuleDOMConstructor::s_info = { "CSSStyleRule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleRuleDOMConstructor) };

template<> JSValue JSCSSStyleRuleDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSRule::getConstructor(vm, &globalObject);
}

template<> void JSCSSStyleRuleDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSStyleRule"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSStyleRule::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSStyleRulePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleRuleConstructor, 0 } },
    { "selectorText"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleRule_selectorText, setJSCSSStyleRule_selectorText } },
    { "style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleRule_style, setJSCSSStyleRule_style } },
    { "styleMap"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleRule_styleMap, 0 } },
    { "cssRules"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleRule_cssRules, 0 } },
    { "insertRule"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleRulePrototypeFunction_insertRule, 1 } },
    { "deleteRule"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleRulePrototypeFunction_deleteRule, 1 } },
};

const ClassInfo JSCSSStyleRulePrototype::s_info = { "CSSStyleRule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleRulePrototype) };

void JSCSSStyleRulePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSStyleRule::info(), JSCSSStyleRulePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssNestingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "insertRule"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssNestingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "deleteRule"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssNestingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "cssRules"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSStyleRule::s_info = { "CSSStyleRule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleRule) };

JSCSSStyleRule::JSCSSStyleRule(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSStyleRule>&& impl)
    : JSCSSRule(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSStyleRule> JSCSSStyleRule::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSStyleRule>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSStyleRule::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSStyleRulePrototype::createStructure(vm, &globalObject, JSCSSRule::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSStyleRulePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSStyleRule::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSStyleRule>(vm, globalObject);
}

JSValue JSCSSStyleRule::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStyleRuleDOMConstructor, DOMConstructorID::CSSStyleRule>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleRuleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSStyleRulePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSStyleRule::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSStyleRule_selectorTextGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleRule& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.selectorText())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleRule_selectorText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleRule>::get<jsCSSStyleRule_selectorTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleRule_selectorTextSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleRule& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSelectorText(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleRule_selectorText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleRule>::set<setJSCSSStyleRule_selectorTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSStyleRule_styleGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleRule& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSStyleDeclaration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.style())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleRule_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleRule>::get<jsCSSStyleRule_styleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleRule_styleSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleRule& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto id = Identifier::fromString(vm, "style"_s);
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, "cssText"_s);
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable()->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleRule_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleRule>::set<setJSCSSStyleRule_styleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSStyleRule_styleMapGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleRule& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<StylePropertyMap>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.styleMap())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleRule_styleMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleRule>::get<jsCSSStyleRule_styleMapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSStyleRule_cssRulesGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleRule& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSRuleList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.cssRules())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleRule_cssRules, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleRule>::get<jsCSSStyleRule_cssRulesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsCSSStyleRulePrototypeFunction_insertRuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleRule>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto ruleConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(ruleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.insertRule(ruleConversionResult.releaseReturnValue(), indexConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleRulePrototypeFunction_insertRule, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleRule>::call<jsCSSStyleRulePrototypeFunction_insertRuleBody>(*lexicalGlobalObject, *callFrame, "insertRule");
}

static inline JSC::EncodedJSValue jsCSSStyleRulePrototypeFunction_deleteRuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleRule>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteRule(indexConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleRulePrototypeFunction_deleteRule, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleRule>::call<jsCSSStyleRulePrototypeFunction_deleteRuleBody>(*lexicalGlobalObject, *callFrame, "deleteRule");
}

JSC::GCClient::IsoSubspace* JSCSSStyleRule::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSStyleRule, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSStyleRule.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSStyleRule = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSStyleRule.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSStyleRule = std::forward<decltype(space)>(space); }
    );
}

void JSCSSStyleRule::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSStyleRule*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
