/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSTransformComponent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMMatrix.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCSSTransformComponentPrototypeFunction_toMatrix);
static JSC_DECLARE_HOST_FUNCTION(jsCSSTransformComponentPrototypeFunction_toString);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSTransformComponentConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSTransformComponent_is2D);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSTransformComponent_is2D);

class JSCSSTransformComponentPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSTransformComponentPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSTransformComponentPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSTransformComponentPrototype>(vm)) JSCSSTransformComponentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSTransformComponentPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSTransformComponentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSTransformComponentPrototype, JSCSSTransformComponentPrototype::Base);

using JSCSSTransformComponentDOMConstructor = JSDOMConstructorNotConstructable<JSCSSTransformComponent>;

template<> const ClassInfo JSCSSTransformComponentDOMConstructor::s_info = { "CSSTransformComponent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSTransformComponentDOMConstructor) };

template<> JSValue JSCSSTransformComponentDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCSSTransformComponentDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSTransformComponent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSTransformComponent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSTransformComponentPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSTransformComponentConstructor, 0 } },
    { "is2D"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSTransformComponent_is2D, setJSCSSTransformComponent_is2D } },
    { "toMatrix"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSTransformComponentPrototypeFunction_toMatrix, 0 } },
    { "toString"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSTransformComponentPrototypeFunction_toString, 0 } },
};

const ClassInfo JSCSSTransformComponentPrototype::s_info = { "CSSTransformComponent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSTransformComponentPrototype) };

void JSCSSTransformComponentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSTransformComponent::info(), JSCSSTransformComponentPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSTransformComponent::s_info = { "CSSTransformComponent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSTransformComponent) };

JSCSSTransformComponent::JSCSSTransformComponent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSTransformComponent>&& impl)
    : JSDOMWrapper<CSSTransformComponent>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSTransformComponent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSTransformComponent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSTransformComponentPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCSSTransformComponentPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSTransformComponent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSTransformComponent>(vm, globalObject);
}

JSValue JSCSSTransformComponent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSTransformComponentDOMConstructor, DOMConstructorID::CSSTransformComponent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCSSTransformComponent::destroy(JSC::JSCell* cell)
{
    JSCSSTransformComponent* thisObject = static_cast<JSCSSTransformComponent*>(cell);
    thisObject->JSCSSTransformComponent::~JSCSSTransformComponent();
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSTransformComponentConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSTransformComponentPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSTransformComponent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSTransformComponent_is2DGetter(JSGlobalObject& lexicalGlobalObject, JSCSSTransformComponent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.is2D())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSTransformComponent_is2D, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSTransformComponent>::get<jsCSSTransformComponent_is2DGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSTransformComponent_is2DSetter(JSGlobalObject& lexicalGlobalObject, JSCSSTransformComponent& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setIs2D(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSTransformComponent_is2D, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSTransformComponent>::set<setJSCSSTransformComponent_is2DSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsCSSTransformComponentPrototypeFunction_toMatrixBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSTransformComponent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.toMatrix())));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSTransformComponentPrototypeFunction_toMatrix, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSTransformComponent>::call<jsCSSTransformComponentPrototypeFunction_toMatrixBody>(*lexicalGlobalObject, *callFrame, "toMatrix");
}

static inline JSC::EncodedJSValue jsCSSTransformComponentPrototypeFunction_toStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSTransformComponent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.toString())));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSTransformComponentPrototypeFunction_toString, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSTransformComponent>::call<jsCSSTransformComponentPrototypeFunction_toStringBody>(*lexicalGlobalObject, *callFrame, "toString");
}

JSC::GCClient::IsoSubspace* JSCSSTransformComponent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSTransformComponent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSTransformComponent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSTransformComponent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSTransformComponent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSTransformComponent = std::forward<decltype(space)>(space); }
    );
}

void JSCSSTransformComponent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSTransformComponent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSCSSTransformComponentOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCSSTransformComponentOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCSSTransformComponent = static_cast<JSCSSTransformComponent*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCSSTransformComponent->protectedWrapped().ptr(), jsCSSTransformComponent);
}

CSSTransformComponent* JSCSSTransformComponent::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSTransformComponent*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
