/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMCacheStorage.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMCache.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSFetchRequest.h"
#include "JSMultiCacheQueryOptions.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDOMCacheStoragePrototypeFunction_match);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCacheStoragePrototypeFunction_has);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCacheStoragePrototypeFunction_open);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCacheStoragePrototypeFunction_delete);
static JSC_DECLARE_HOST_FUNCTION(jsDOMCacheStoragePrototypeFunction_keys);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMCacheStorageConstructor);

class JSDOMCacheStoragePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMCacheStoragePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMCacheStoragePrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMCacheStoragePrototype>(vm)) JSDOMCacheStoragePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMCacheStoragePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMCacheStoragePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMCacheStoragePrototype, JSDOMCacheStoragePrototype::Base);

using JSDOMCacheStorageDOMConstructor = JSDOMConstructorNotConstructable<JSDOMCacheStorage>;

template<> const ClassInfo JSDOMCacheStorageDOMConstructor::s_info = { "CacheStorage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMCacheStorageDOMConstructor) };

template<> JSValue JSDOMCacheStorageDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMCacheStorageDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CacheStorage"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDOMCacheStorage::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSDOMCacheStoragePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMCacheStorageConstructor, 0 } },
    { "match"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCacheStoragePrototypeFunction_match, 1 } },
    { "has"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCacheStoragePrototypeFunction_has, 1 } },
    { "open"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCacheStoragePrototypeFunction_open, 1 } },
    { "delete"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCacheStoragePrototypeFunction_delete, 1 } },
    { "keys"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMCacheStoragePrototypeFunction_keys, 0 } },
};

const ClassInfo JSDOMCacheStoragePrototype::s_info = { "CacheStorage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMCacheStoragePrototype) };

void JSDOMCacheStoragePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMCacheStorage::info(), JSDOMCacheStoragePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDOMCacheStorage::s_info = { "CacheStorage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMCacheStorage) };

JSDOMCacheStorage::JSDOMCacheStorage(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMCacheStorage>&& impl)
    : JSDOMWrapper<DOMCacheStorage>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, DOMCacheStorage>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSDOMCacheStorage::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDOMCacheStoragePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDOMCacheStoragePrototype::create(vm, &globalObject, structure);
}

JSObject* JSDOMCacheStorage::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMCacheStorage>(vm, globalObject);
}

JSValue JSDOMCacheStorage::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMCacheStorageDOMConstructor, DOMConstructorID::DOMCacheStorage>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMCacheStorage::destroy(JSC::JSCell* cell)
{
    JSDOMCacheStorage* thisObject = static_cast<JSDOMCacheStorage*>(cell);
    thisObject->JSDOMCacheStorage::~JSDOMCacheStorage();
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMCacheStorageConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMCacheStoragePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMCacheStorage::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsDOMCacheStoragePrototypeFunction_matchBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSDOMCacheStorage>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto requestConversionResult = convert<IDLUnion<IDLInterface<FetchRequest>, IDLUSVString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(requestConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<MultiCacheQueryOptions>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(optionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLAny>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.match(requestConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCacheStoragePrototypeFunction_match, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSDOMCacheStorage>::call<jsDOMCacheStoragePrototypeFunction_matchBody>(*lexicalGlobalObject, *callFrame, "match");
}

static inline JSC::EncodedJSValue jsDOMCacheStoragePrototypeFunction_hasBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSDOMCacheStorage>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cacheNameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(cacheNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLBoolean>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.has(cacheNameConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCacheStoragePrototypeFunction_has, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSDOMCacheStorage>::call<jsDOMCacheStoragePrototypeFunction_hasBody>(*lexicalGlobalObject, *callFrame, "has");
}

static inline JSC::EncodedJSValue jsDOMCacheStoragePrototypeFunction_openBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSDOMCacheStorage>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cacheNameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(cacheNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<DOMCache>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.open(cacheNameConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCacheStoragePrototypeFunction_open, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSDOMCacheStorage>::call<jsDOMCacheStoragePrototypeFunction_openBody>(*lexicalGlobalObject, *callFrame, "open");
}

static inline JSC::EncodedJSValue jsDOMCacheStoragePrototypeFunction_deleteBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSDOMCacheStorage>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cacheNameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(cacheNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLBoolean>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.remove(cacheNameConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCacheStoragePrototypeFunction_delete, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSDOMCacheStorage>::call<jsDOMCacheStoragePrototypeFunction_deleteBody>(*lexicalGlobalObject, *callFrame, "delete");
}

static inline JSC::EncodedJSValue jsDOMCacheStoragePrototypeFunction_keysBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSDOMCacheStorage>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLSequence<IDLDOMString>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.keys(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMCacheStoragePrototypeFunction_keys, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSDOMCacheStorage>::call<jsDOMCacheStoragePrototypeFunction_keysBody>(*lexicalGlobalObject, *callFrame, "keys");
}

JSC::GCClient::IsoSubspace* JSDOMCacheStorage::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMCacheStorage, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMCacheStorage.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMCacheStorage = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMCacheStorage.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMCacheStorage = std::forward<decltype(space)>(space); }
    );
}

void JSDOMCacheStorage::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMCacheStorage*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMCacheStorageOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsDOMCacheStorage = jsCast<JSDOMCacheStorage*>(handle.slot()->asCell());
    auto& wrapped = jsDOMCacheStorage->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDOMCacheStorageOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMCacheStorage = static_cast<JSDOMCacheStorage*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMCacheStorage->protectedWrapped().ptr(), jsDOMCacheStorage);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMCacheStorage@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15DOMCacheStorageE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, DOMCacheStorage>, void>> static inline void verifyVTable(DOMCacheStorage* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DOMCacheStorage@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15DOMCacheStorageE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DOMCacheStorage has subclasses. If DOMCacheStorage has subclasses that get passed
        // to toJS() we currently require DOMCacheStorage you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMCacheStorage>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<DOMCacheStorage>(impl.ptr());
#endif
    return createWrapper<DOMCacheStorage>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMCacheStorage& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMCacheStorage* JSDOMCacheStorage::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMCacheStorage*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
