/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUComputePassTimestampWrites.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSGPUQuerySet.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUComputePassTimestampWrites>> convertDictionary<GPUComputePassTimestampWrites>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUComputePassTimestampWrites result;
    JSValue beginningOfPassWriteIndexValue;
    if (isNullOrUndefined)
        beginningOfPassWriteIndexValue = jsUndefined();
    else {
        beginningOfPassWriteIndexValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "beginningOfPassWriteIndex"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!beginningOfPassWriteIndexValue.isUndefined()) {
        auto beginningOfPassWriteIndexConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, beginningOfPassWriteIndexValue);
        if (UNLIKELY(beginningOfPassWriteIndexConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.beginningOfPassWriteIndex = beginningOfPassWriteIndexConversionResult.releaseReturnValue();
    }
    JSValue endOfPassWriteIndexValue;
    if (isNullOrUndefined)
        endOfPassWriteIndexValue = jsUndefined();
    else {
        endOfPassWriteIndexValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endOfPassWriteIndex"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!endOfPassWriteIndexValue.isUndefined()) {
        auto endOfPassWriteIndexConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, endOfPassWriteIndexValue);
        if (UNLIKELY(endOfPassWriteIndexConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.endOfPassWriteIndex = endOfPassWriteIndexConversionResult.releaseReturnValue();
    }
    JSValue querySetValue;
    if (isNullOrUndefined)
        querySetValue = jsUndefined();
    else {
        querySetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "querySet"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (querySetValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "querySet"_s, "GPUComputePassTimestampWrites"_s, "GPUQuerySet"_s);
        return ConversionResultException { };
    }
    auto querySetConversionResult = convert<IDLInterface<GPUQuerySet>>(lexicalGlobalObject, querySetValue);
    if (UNLIKELY(querySetConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.querySet = querySetConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
