/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUExtent3DDict.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUExtent3DDict>> convertDictionary<GPUExtent3DDict>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUExtent3DDict result;
    JSValue depthOrArrayLayersValue;
    if (isNullOrUndefined)
        depthOrArrayLayersValue = jsUndefined();
    else {
        depthOrArrayLayersValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthOrArrayLayers"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto depthOrArrayLayersConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, depthOrArrayLayersValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 1 }; });
    if (UNLIKELY(depthOrArrayLayersConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.depthOrArrayLayers = depthOrArrayLayersConversionResult.releaseReturnValue();
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto heightConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, heightValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 1 }; });
    if (UNLIKELY(heightConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.height = heightConversionResult.releaseReturnValue();
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (widthValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "width"_s, "GPUExtent3DDict"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto widthConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, widthValue);
    if (UNLIKELY(widthConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.width = widthConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
