/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTrustedScriptURL.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsTrustedScriptURLPrototypeFunction_toJSON);
static JSC_DECLARE_HOST_FUNCTION(jsTrustedScriptURLPrototypeFunction_toString);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsTrustedScriptURLConstructor);

class JSTrustedScriptURLPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTrustedScriptURLPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTrustedScriptURLPrototype* ptr = new (NotNull, JSC::allocateCell<JSTrustedScriptURLPrototype>(vm)) JSTrustedScriptURLPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTrustedScriptURLPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTrustedScriptURLPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTrustedScriptURLPrototype, JSTrustedScriptURLPrototype::Base);

using JSTrustedScriptURLDOMConstructor = JSDOMConstructorNotConstructable<JSTrustedScriptURL>;

template<> const ClassInfo JSTrustedScriptURLDOMConstructor::s_info = { "TrustedScriptURL"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTrustedScriptURLDOMConstructor) };

template<> JSValue JSTrustedScriptURLDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTrustedScriptURLDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TrustedScriptURL"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSTrustedScriptURL::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSTrustedScriptURLPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsTrustedScriptURLConstructor, 0 } },
    { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTrustedScriptURLPrototypeFunction_toJSON, 0 } },
    { "toString"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTrustedScriptURLPrototypeFunction_toString, 0 } },
};

const ClassInfo JSTrustedScriptURLPrototype::s_info = { "TrustedScriptURL"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTrustedScriptURLPrototype) };

void JSTrustedScriptURLPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTrustedScriptURL::info(), JSTrustedScriptURLPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSTrustedScriptURL::s_info = { "TrustedScriptURL"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTrustedScriptURL) };

JSTrustedScriptURL::JSTrustedScriptURL(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TrustedScriptURL>&& impl)
    : JSDOMWrapper<TrustedScriptURL>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, TrustedScriptURL>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSTrustedScriptURL::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSTrustedScriptURLPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSTrustedScriptURLPrototype::create(vm, &globalObject, structure);
}

JSObject* JSTrustedScriptURL::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTrustedScriptURL>(vm, globalObject);
}

JSValue JSTrustedScriptURL::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTrustedScriptURLDOMConstructor, DOMConstructorID::TrustedScriptURL>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSTrustedScriptURL::destroy(JSC::JSCell* cell)
{
    JSTrustedScriptURL* thisObject = static_cast<JSTrustedScriptURL*>(cell);
    thisObject->JSTrustedScriptURL::~JSTrustedScriptURL();
}

JSC_DEFINE_CUSTOM_GETTER(jsTrustedScriptURLConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTrustedScriptURLPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTrustedScriptURL::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsTrustedScriptURLPrototypeFunction_toJSONBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTrustedScriptURL>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.toJSON())));
}

JSC_DEFINE_HOST_FUNCTION(jsTrustedScriptURLPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTrustedScriptURL>::call<jsTrustedScriptURLPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

static inline JSC::EncodedJSValue jsTrustedScriptURLPrototypeFunction_toStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTrustedScriptURL>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.toString())));
}

JSC_DEFINE_HOST_FUNCTION(jsTrustedScriptURLPrototypeFunction_toString, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTrustedScriptURL>::call<jsTrustedScriptURLPrototypeFunction_toStringBody>(*lexicalGlobalObject, *callFrame, "toString");
}

JSC::GCClient::IsoSubspace* JSTrustedScriptURL::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSTrustedScriptURL, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForTrustedScriptURL.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForTrustedScriptURL = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForTrustedScriptURL.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForTrustedScriptURL = std::forward<decltype(space)>(space); }
    );
}

void JSTrustedScriptURL::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTrustedScriptURL*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSTrustedScriptURLOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSTrustedScriptURLOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTrustedScriptURL = static_cast<JSTrustedScriptURL*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTrustedScriptURL->protectedWrapped().ptr(), jsTrustedScriptURL);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TrustedScriptURL@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16TrustedScriptURLE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, TrustedScriptURL>, void>> static inline void verifyVTable(TrustedScriptURL* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7TrustedScriptURL@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16TrustedScriptURLE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // TrustedScriptURL has subclasses. If TrustedScriptURL has subclasses that get passed
        // to toJS() we currently require TrustedScriptURL you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TrustedScriptURL>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<TrustedScriptURL>(impl.ptr());
#endif
    return createWrapper<TrustedScriptURL>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TrustedScriptURL& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TrustedScriptURL* JSTrustedScriptURL::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTrustedScriptURL*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
