/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSViewTimelineOptions.h"

#include "JSCSSKeywordValue.h"
#include "JSCSSNumericValue.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSElement.h"
#include "JSScrollAxis.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ViewTimelineOptions>> convertDictionary<ViewTimelineOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ViewTimelineOptions result;
    JSValue axisValue;
    if (isNullOrUndefined)
        axisValue = jsUndefined();
    else {
        axisValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "axis"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto axisConversionResult = convertOptionalWithDefault<IDLEnumeration<ScrollAxis>>(lexicalGlobalObject, axisValue, [&]() -> ConversionResult<IDLEnumeration<ScrollAxis>> { return Converter<IDLEnumeration<ScrollAxis>>::ReturnType { ScrollAxis::Block }; });
    if (UNLIKELY(axisConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.axis = axisConversionResult.releaseReturnValue();
    JSValue insetValue;
    if (isNullOrUndefined)
        insetValue = jsUndefined();
    else {
        insetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "inset"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto insetConversionResult = convertOptionalWithDefault<IDLUnion<IDLDOMString, IDLSequence<IDLUnion<IDLInterface<CSSNumericValue>, IDLInterface<CSSKeywordValue>>>>>(lexicalGlobalObject, insetValue, [&]() -> ConversionResult<IDLUnion<IDLDOMString, IDLSequence<IDLUnion<IDLInterface<CSSNumericValue>, IDLInterface<CSSKeywordValue>>>>> { return Converter<IDLUnion<IDLDOMString, IDLSequence<IDLUnion<IDLInterface<CSSNumericValue>, IDLInterface<CSSKeywordValue>>>>>::ReturnType { "auto"_s }; });
    if (UNLIKELY(insetConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.inset = insetConversionResult.releaseReturnValue();
    JSValue subjectValue;
    if (isNullOrUndefined)
        subjectValue = jsUndefined();
    else {
        subjectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "subject"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!subjectValue.isUndefined()) {
        auto subjectConversionResult = convert<IDLInterface<Element>>(lexicalGlobalObject, subjectValue);
        if (UNLIKELY(subjectConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.subject = subjectConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore
