/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLUniformLocation.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebGLUniformLocationConstructor);

class JSWebGLUniformLocationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLUniformLocationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLUniformLocationPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLUniformLocationPrototype>(vm)) JSWebGLUniformLocationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLUniformLocationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLUniformLocationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLUniformLocationPrototype, JSWebGLUniformLocationPrototype::Base);

using JSWebGLUniformLocationDOMConstructor = JSDOMConstructorNotConstructable<JSWebGLUniformLocation>;

template<> const ClassInfo JSWebGLUniformLocationDOMConstructor::s_info = { "WebGLUniformLocation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLUniformLocationDOMConstructor) };

template<> JSValue JSWebGLUniformLocationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLUniformLocationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebGLUniformLocation"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebGLUniformLocation::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLUniformLocationPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLUniformLocationConstructor, 0 } },
};

const ClassInfo JSWebGLUniformLocationPrototype::s_info = { "WebGLUniformLocation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLUniformLocationPrototype) };

void JSWebGLUniformLocationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLUniformLocation::info(), JSWebGLUniformLocationPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLUniformLocation::s_info = { "WebGLUniformLocation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLUniformLocation) };

JSWebGLUniformLocation::JSWebGLUniformLocation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLUniformLocation>&& impl)
    : JSDOMWrapper<WebGLUniformLocation>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLUniformLocation>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLUniformLocation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLUniformLocationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLUniformLocationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLUniformLocation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLUniformLocation>(vm, globalObject);
}

JSValue JSWebGLUniformLocation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLUniformLocationDOMConstructor, DOMConstructorID::WebGLUniformLocation>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLUniformLocation::destroy(JSC::JSCell* cell)
{
    JSWebGLUniformLocation* thisObject = static_cast<JSWebGLUniformLocation*>(cell);
    thisObject->JSWebGLUniformLocation::~JSWebGLUniformLocation();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLUniformLocationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLUniformLocationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGLUniformLocation::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSWebGLUniformLocation::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLUniformLocation, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLUniformLocation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLUniformLocation = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLUniformLocation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLUniformLocation = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLUniformLocation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLUniformLocation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLUniformLocationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGLUniformLocationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLUniformLocation = static_cast<JSWebGLUniformLocation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLUniformLocation->protectedWrapped().ptr(), jsWebGLUniformLocation);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLUniformLocation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20WebGLUniformLocationE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebGLUniformLocation>, void>> static inline void verifyVTable(WebGLUniformLocation* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLUniformLocation@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20WebGLUniformLocationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLUniformLocation has subclasses. If WebGLUniformLocation has subclasses that get passed
        // to toJS() we currently require WebGLUniformLocation you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLUniformLocation>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLUniformLocation>(impl.ptr());
#endif
    return createWrapper<WebGLUniformLocation>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLUniformLocation& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLUniformLocation* JSWebGLUniformLocation::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLUniformLocation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
