/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.portlet;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import org.apache.commons.fileupload2.core.AbstractFileUpload;
import org.apache.commons.fileupload2.core.AbstractFileUploadTest;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.fileupload2.portlet.JavaxPortletFileUpload;
import org.apache.commons.fileupload2.portlet.JavaxPortletMockActionRequest;
import org.apache.commons.fileupload2.portlet.JavaxPortletRequestContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class JavaxPortletFileUploadTest
extends AbstractFileUploadTest<JavaxPortletFileUpload<DiskFileItem, DiskFileItemFactory>, ActionRequest, DiskFileItem, DiskFileItemFactory> {
    public JavaxPortletFileUploadTest() {
        super((AbstractFileUpload)new JavaxPortletFileUpload((FileItemFactory)DiskFileItemFactory.builder().get()));
    }

    public List<DiskFileItem> parseUpload(JavaxPortletFileUpload<DiskFileItem, DiskFileItemFactory> upload, byte[] bytes, String contentType) throws FileUploadException {
        JavaxPortletMockActionRequest request = new JavaxPortletMockActionRequest(bytes, contentType);
        return upload.parseRequest((RequestContext)new JavaxPortletRequestContext((ActionRequest)request));
    }

    @Test
    void testParseParameterMap() throws Exception {
        String text = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n";
        byte[] bytes = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n".getBytes(StandardCharsets.US_ASCII);
        JavaxPortletMockActionRequest request = new JavaxPortletMockActionRequest(bytes, "multipart/form-data; boundary=---1234");
        Map mappedParameters = ((JavaxPortletFileUpload)this.upload).parseParameterMap((ActionRequest)request);
        Assertions.assertTrue((boolean)mappedParameters.containsKey("file"));
        Assertions.assertEquals((int)1, (int)((List)mappedParameters.get("file")).size());
        Assertions.assertTrue((boolean)mappedParameters.containsKey("field"));
        Assertions.assertEquals((int)1, (int)((List)mappedParameters.get("field")).size());
        Assertions.assertTrue((boolean)mappedParameters.containsKey("multi"));
        Assertions.assertEquals((int)2, (int)((List)mappedParameters.get("multi")).size());
    }
}

