/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.gif;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.gif.AbstractGifTest;
import org.apache.commons.imaging.formats.gif.DisposalMethod;
import org.apache.commons.imaging.formats.gif.GifImageMetadata;
import org.apache.commons.imaging.formats.gif.GifImageMetadataItem;
import org.apache.commons.imaging.formats.gif.GifImageParser;
import org.apache.commons.imaging.formats.gif.GifImagingParameters;
import org.apache.commons.imaging.test.TestResources;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class GifReadTest
extends AbstractGifTest {
    public static Stream<File> animatedImageData() throws Exception {
        return GifReadTest.getAnimatedGifImages().stream();
    }

    public static Stream<File> data() throws Exception {
        return GifReadTest.getGifImages().stream();
    }

    public static Stream<File> singleImageData() throws Exception {
        return GifReadTest.getGifImagesWithSingleImage().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testBufferedImage(File imageFile) throws Exception {
        BufferedImage image = Imaging.getBufferedImage((File)imageFile);
        Assertions.assertNotNull((Object)image);
    }

    @ParameterizedTest
    @MethodSource(value={"animatedImageData"})
    public void testBufferedImagesForAnimatedImageGif(File imageFile) throws Exception {
        List images = Imaging.getAllBufferedImages((File)imageFile);
        Assertions.assertTrue((images.size() > 1 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"singleImageData"})
    public void testBufferedImagesForSingleImageGif(File imageFile) throws Exception {
        List images = Imaging.getAllBufferedImages((File)imageFile);
        Assertions.assertEquals((int)1, (int)images.size());
    }

    @Test
    public void testConvertInvalidDisposalMethodValues() {
        Assertions.assertThrows(ImagingException.class, () -> GifImageParser.createDisposalMethodFromIntValue((int)8));
    }

    @Test
    public void testConvertValidDisposalMethodValues() throws ImagingException {
        DisposalMethod unspecified = GifImageParser.createDisposalMethodFromIntValue((int)0);
        DisposalMethod doNotDispose = GifImageParser.createDisposalMethodFromIntValue((int)1);
        DisposalMethod restoreToBackground = GifImageParser.createDisposalMethodFromIntValue((int)2);
        DisposalMethod restoreToPrevious = GifImageParser.createDisposalMethodFromIntValue((int)3);
        DisposalMethod toBeDefined1 = GifImageParser.createDisposalMethodFromIntValue((int)4);
        DisposalMethod toBeDefined2 = GifImageParser.createDisposalMethodFromIntValue((int)5);
        DisposalMethod toBeDefined3 = GifImageParser.createDisposalMethodFromIntValue((int)6);
        DisposalMethod toBeDefined4 = GifImageParser.createDisposalMethodFromIntValue((int)7);
        Assertions.assertEquals((Object)unspecified, (Object)DisposalMethod.UNSPECIFIED);
        Assertions.assertEquals((Object)doNotDispose, (Object)DisposalMethod.DO_NOT_DISPOSE);
        Assertions.assertEquals((Object)restoreToBackground, (Object)DisposalMethod.RESTORE_TO_BACKGROUND);
        Assertions.assertEquals((Object)restoreToPrevious, (Object)DisposalMethod.RESTORE_TO_PREVIOUS);
        Assertions.assertEquals((Object)toBeDefined1, (Object)DisposalMethod.TO_BE_DEFINED_1);
        Assertions.assertEquals((Object)toBeDefined2, (Object)DisposalMethod.TO_BE_DEFINED_2);
        Assertions.assertEquals((Object)toBeDefined3, (Object)DisposalMethod.TO_BE_DEFINED_3);
        Assertions.assertEquals((Object)toBeDefined4, (Object)DisposalMethod.TO_BE_DEFINED_4);
    }

    @Test
    public void testCreateMetadataWithDisposalMethods() {
        for (DisposalMethod disposalMethod : DisposalMethod.values()) {
            GifImageMetadataItem metadataItem = new GifImageMetadataItem(0, 0, 0, disposalMethod);
            Assertions.assertEquals((Object)disposalMethod, (Object)metadataItem.getDisposalMethod());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testImageDimensions(File imageFile) throws Exception {
        ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
        GifImageMetadata metadata = (GifImageMetadata)Imaging.getMetadata((File)imageFile);
        List images = Imaging.getAllBufferedImages((File)imageFile);
        int width = 0;
        int height = 0;
        for (int i = 0; i < images.size(); ++i) {
            BufferedImage image = (BufferedImage)images.get(i);
            GifImageMetadataItem metadataItem = (GifImageMetadataItem)metadata.getItems().get(i);
            int xOffset = metadataItem.getLeftPosition();
            int yOffset = metadataItem.getTopPosition();
            width = Math.max(width, image.getWidth() + xOffset);
            height = Math.max(height, image.getHeight() + yOffset);
        }
        Assertions.assertEquals((int)width, (int)metadata.getWidth());
        Assertions.assertEquals((int)height, (int)metadata.getHeight());
        Assertions.assertEquals((int)width, (int)imageInfo.getWidth());
        Assertions.assertEquals((int)height, (int)imageInfo.getHeight());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testImageInfo(File imageFile) throws Exception {
        ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
        Assertions.assertNotNull((Object)imageInfo);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testMetadata(File imageFile) throws IOException {
        ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
        Assertions.assertNotNull((Object)metadata);
        Assertions.assertInstanceOf(GifImageMetadata.class, (Object)metadata);
        Assertions.assertTrue((((GifImageMetadata)metadata).getWidth() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((((GifImageMetadata)metadata).getHeight() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)metadata.getItems());
    }

    @Test
    public void testUncaughtExceptionOssFuzz33464() throws IOException {
        File file = TestResources.resourceToFile("/images/gif/oss-fuzz-33464/clusterfuzz-testcase-minimized-ImagingGifFuzzer-5174009164595200");
        GifImageParser parser = new GifImageParser();
        Assertions.assertThrows(ImagingException.class, () -> parser.getBufferedImage(ByteSource.file((File)file), new GifImagingParameters()));
    }

    @Test
    public void testUncaughtExceptionOssFuzz33501() throws IOException {
        File file = TestResources.resourceToFile("/images/gif/oss-fuzz-33501/clusterfuzz-testcase-minimized-ImagingGifFuzzer-5914278319226880");
        GifImageParser parser = new GifImageParser();
        Assertions.assertThrows(ImagingException.class, () -> parser.getBufferedImage(ByteSource.file((File)file), new GifImagingParameters()));
    }

    @Test
    public void testUncaughtExceptionOssFuzz34185() throws IOException {
        File file = TestResources.resourceToFile("/images/gif/IMAGING-318/clusterfuzz-testcase-minimized-ImagingGifFuzzer-5005192379629568");
        GifImageParser parser = new GifImageParser();
        Assertions.assertThrows(ImagingException.class, () -> parser.getBufferedImage(ByteSource.file((File)file), new GifImagingParameters()));
    }
}

