/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Consumer;
import org.apache.commons.cli.Option;
import org.apache.rat.utils.DefaultLog;

public final class DeprecationReporter {
    private static Consumer<Option> consumer = DeprecationReporter.getDefault();

    private DeprecationReporter() {
    }

    public static Consumer<Option> getDefault() {
        return o -> {
            StringBuilder buff = new StringBuilder();
            if (o.getOpt() != null) {
                buff.append("-").append(o.getOpt());
                if (o.getLongOpt() != null) {
                    buff.append(", --").append(o.getLongOpt());
                }
            } else {
                buff.append("--").append(o.getLongOpt());
            }
            DefaultLog.getInstance().warn(String.format("Option [%s] used. %s", buff, o.getDeprecated().toString()));
        };
    }

    public static Consumer<Option> getLogReporter() {
        return consumer;
    }

    public static void setLogReporter(Consumer<Option> consumer) {
        DeprecationReporter.consumer = consumer;
    }

    public static void resetLogReporter() {
        consumer = DeprecationReporter.getDefault();
    }

    public static void logDeprecated(Class<?> clazz) {
        if (clazz.getAnnotation(Deprecated.class) != null) {
            String name = String.format("class used: %s ", clazz);
            Info info = clazz.getAnnotation(Info.class);
            if (info == null) {
                DefaultLog.getInstance().warn(DeprecationReporter.formatEntry(name, "", false, ""));
            } else {
                DefaultLog.getInstance().warn(DeprecationReporter.formatEntry(String.format(name, clazz), info.since(), info.forRemoval(), info.use()));
            }
        }
    }

    private static String formatEntry(String prefix, String since, boolean forRemoval, String use) {
        StringBuilder sb = new StringBuilder("Deprecated " + prefix);
        if (forRemoval) {
            sb.append(" Scheduled for removal");
            if (!since.isEmpty()) {
                sb.append(" since ").append(since);
            }
            sb.append(".");
        } else if (!since.isEmpty()) {
            sb.append(" Deprecated since ").append(since).append(".");
        }
        if (!use.isEmpty()) {
            sb.append(" Use ").append(use).append(" instead.");
        }
        return sb.toString();
    }

    public static void logDeprecated(String name, String since, boolean forRemoval, String use) {
        DefaultLog.getInstance().warn(DeprecationReporter.formatEntry(name, since, forRemoval, use));
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Info {
        public String since() default "";

        public boolean forRemoval() default false;

        public String use() default "";
    }
}

