/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion.plexus;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.rat.config.exclusion.plexus.MatchPattern;

public final class MatchPatterns {
    private final MatchPattern[] patterns;

    private MatchPatterns(MatchPattern[] patterns) {
        this.patterns = patterns;
    }

    public String toString() {
        return Arrays.stream(this.patterns).map(MatchPattern::toString).collect(Collectors.toList()).toString();
    }

    public String source() {
        return Arrays.stream(this.patterns).map(MatchPattern::source).collect(Collectors.toList()).toString();
    }

    public Iterable<MatchPattern> patterns() {
        return Arrays.asList(this.patterns);
    }

    public boolean matches(String name, boolean isCaseSensitive) {
        String[] tokenized = MatchPattern.tokenizePathToString(name, File.separator);
        return this.matches(name, tokenized, isCaseSensitive);
    }

    public boolean matches(String name, String[] tokenizedName, boolean isCaseSensitive) {
        char[][] tokenizedNameChar = new char[tokenizedName.length][];
        for (int i = 0; i < tokenizedName.length; ++i) {
            tokenizedNameChar[i] = tokenizedName[i].toCharArray();
        }
        return this.matches(name, tokenizedNameChar, isCaseSensitive);
    }

    public boolean matches(String name, char[][] tokenizedNameChar, boolean isCaseSensitive) {
        for (MatchPattern pattern : this.patterns) {
            if (!pattern.matchPath(name, tokenizedNameChar, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public static MatchPatterns from(String separator, String ... sources) {
        int length = sources.length;
        MatchPattern[] result = new MatchPattern[length];
        for (int i = 0; i < length; ++i) {
            result[i] = new MatchPattern(sources[i], separator);
        }
        return new MatchPatterns(result);
    }

    public static MatchPatterns from(String separator, Iterable<String> strings) {
        return new MatchPatterns(MatchPatterns.getMatchPatterns(separator, strings));
    }

    private static MatchPattern[] getMatchPatterns(String separator, Iterable<String> items) {
        ArrayList<MatchPattern> result = new ArrayList<MatchPattern>();
        for (String string : items) {
            result.add(new MatchPattern(string, separator));
        }
        return result.toArray(new MatchPattern[0]);
    }
}

