/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer.sink;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.module.xhtml.XhtmlSink;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteRendererSink
extends XhtmlSink
implements Sink,
org.codehaus.doxia.sink.Sink {
    private String date = "";
    private String title = "";
    private List<String> authors = new ArrayList<String>();
    private final StringWriter headWriter;
    private StringBuilder sectionTitleBuffer;
    private StringBuilder sectionTitleWriteBuffer;
    private boolean sectionHasID;
    private boolean isSectionTitle;
    private Set<String> anchorsInSectionTitle;
    private final Writer writer;
    private RenderingContext renderingContext;

    public SiteRendererSink(RenderingContext renderingContext) {
        this(new StringWriter(), renderingContext);
    }

    private SiteRendererSink(StringWriter writer, RenderingContext renderingContext) {
        super(writer);
        this.writer = writer;
        this.headWriter = new StringWriter();
        this.renderingContext = renderingContext;
    }

    @Override
    public void title_() {
        if (this.getTextBuffer().length() > 0) {
            this.title = this.getTextBuffer().toString();
        }
        this.resetTextBuffer();
    }

    @Override
    public void title() {
        this.resetTextBuffer();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void author() {
        this.resetTextBuffer();
    }

    @Override
    public void author_() {
        if (this.getTextBuffer().length() > 0) {
            String text = HtmlTools.escapeHTML(this.getTextBuffer().toString());
            text = StringUtils.replace(text, "&amp;#", "&#");
            this.authors.add(text.trim());
        }
        this.resetTextBuffer();
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    @Override
    public void date() {
        this.resetTextBuffer();
    }

    @Override
    public void date_() {
        if (this.getTextBuffer().length() > 0) {
            this.date = this.getTextBuffer().toString().trim();
        }
        this.resetTextBuffer();
    }

    public String getDate() {
        return this.date;
    }

    @Override
    public void body_() {
    }

    @Override
    public void body() {
    }

    public String getBody() {
        return this.writer.toString();
    }

    public String getHead() {
        return this.headWriter.toString();
    }

    @Override
    public void head_() {
        this.setHeadFlag(false);
    }

    @Override
    public void head() {
        this.setHeadFlag(true);
    }

    @Override
    public void anchor(String name, SinkEventAttributes attributes) {
        super.anchor(name, attributes);
        if (this.isSectionTitle) {
            if (this.anchorsInSectionTitle == null) {
                this.anchorsInSectionTitle = new HashSet<String>();
            }
            this.anchorsInSectionTitle.add(name);
        }
    }

    @Override
    protected void onSectionTitle(int depth, SinkEventAttributes attributes) {
        this.sectionHasID = attributes != null && attributes.isDefined(HTML.Attribute.ID.toString());
        this.isSectionTitle = true;
        super.onSectionTitle(depth, attributes);
        this.sectionTitleBuffer = new StringBuilder();
        this.sectionTitleWriteBuffer = new StringBuilder();
    }

    @Override
    protected void onSectionTitle_(int depth) {
        String sectionTitle = this.sectionTitleBuffer.toString();
        this.sectionTitleBuffer = null;
        String sectionWriteTitle = this.sectionTitleWriteBuffer.toString();
        this.sectionTitleWriteBuffer = null;
        if (!StringUtils.isEmpty(sectionTitle)) {
            if (this.sectionHasID) {
                this.sectionHasID = false;
            } else {
                String id = HtmlTools.encodeId(sectionTitle);
                if (this.anchorsInSectionTitle == null || !this.anchorsInSectionTitle.contains(id)) {
                    this.anchor(id);
                    this.anchor_();
                }
            }
        }
        super.write(sectionWriteTitle);
        this.isSectionTitle = false;
        this.anchorsInSectionTitle = null;
        super.onSectionTitle_(depth);
    }

    public RenderingContext getRenderingContext() {
        return this.renderingContext;
    }

    @Override
    public void text(String text) {
        if (this.sectionTitleBuffer != null) {
            this.sectionTitleBuffer.append(text);
        }
        super.text(text);
    }

    @Override
    protected void write(String text) {
        String txt = text;
        if (this.isHeadFlag()) {
            this.headWriter.write(SiteRendererSink.unifyEOLs(txt));
            return;
        }
        if (this.renderingContext != null) {
            String relativePathToBasedir = this.renderingContext.getRelativePath();
            txt = relativePathToBasedir == null ? StringUtils.replace(txt, "$relativePath", ".") : StringUtils.replace(txt, "$relativePath", relativePathToBasedir);
        }
        if (this.sectionTitleWriteBuffer != null) {
            this.sectionTitleWriteBuffer.append(txt);
        } else {
            super.write(txt);
        }
    }
}

