/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.commands;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.NoSuchDefinitionException;
import org.apache.struts.tiles.TilesUtil;

public class TilesPreProcessor
implements Command {
    private static final Log log = LogFactory.getLog(TilesPreProcessor.class);

    public boolean execute(Context context) throws Exception {
        ServletActionContext sacontext = (ServletActionContext)context;
        ForwardConfig forwardConfig = sacontext.getForwardConfig();
        if (forwardConfig == null || forwardConfig.getPath() == null) {
            log.debug("No forwardConfig or no path, so pass to next command.");
            return false;
        }
        ComponentDefinition definition = null;
        try {
            definition = TilesUtil.getDefinition(forwardConfig.getPath(), (ServletRequest)sacontext.getRequest(), sacontext.getContext());
        }
        catch (FactoryNotFoundException ex) {
            log.debug("Tiles DefinitionFactory not found, so pass to next command.");
            return false;
        }
        catch (NoSuchDefinitionException ex) {
            log.debug("NoSuchDefinitionException " + ex.getMessage());
        }
        boolean doInclude = false;
        ComponentContext tileContext = null;
        tileContext = ComponentContext.getContext((ServletRequest)sacontext.getRequest());
        doInclude = tileContext != null || sacontext.getResponse().isCommitted();
        Controller controller = null;
        String uri = null;
        if (definition != null) {
            uri = definition.getPath();
            controller = definition.getOrCreateController();
            if (tileContext == null) {
                tileContext = new ComponentContext(definition.getAttributes());
                ComponentContext.setContext(tileContext, (ServletRequest)sacontext.getRequest());
            } else {
                tileContext.addMissing(definition.getAttributes());
            }
        }
        if ((definition = DefinitionsUtil.getActionDefinition((ServletRequest)sacontext.getRequest())) != null) {
            if (definition.getPath() != null) {
                log.debug("Override forward uri " + uri + " with action uri " + definition.getPath());
                uri = definition.getPath();
            }
            if (definition.getOrCreateController() != null) {
                log.debug("Override forward controller with action controller");
                controller = definition.getOrCreateController();
            }
            if (tileContext == null) {
                tileContext = new ComponentContext(definition.getAttributes());
                ComponentContext.setContext(tileContext, (ServletRequest)sacontext.getRequest());
            } else {
                tileContext.addMissing(definition.getAttributes());
            }
        }
        if (uri == null) {
            log.debug("no uri computed, so pass to next command");
            return false;
        }
        if (controller != null) {
            log.trace("Execute controller: " + controller);
            controller.execute(tileContext, sacontext.getRequest(), sacontext.getResponse(), sacontext.getContext());
        }
        if (doInclude) {
            log.info("Tiles process complete; doInclude with " + uri);
            this.doInclude(sacontext, uri);
        } else {
            log.info("Tiles process complete; forward to " + uri);
            this.doForward(sacontext, uri);
        }
        log.debug("Tiles processed, so clearing forward config from context.");
        sacontext.setForwardConfig(null);
        return false;
    }

    protected void doInclude(ServletActionContext context, String uri) throws IOException, ServletException {
        RequestDispatcher rd = this.getRequiredDispatcher(context, uri);
        if (rd != null) {
            rd.include((ServletRequest)context.getRequest(), (ServletResponse)context.getResponse());
        }
    }

    protected void doForward(ServletActionContext context, String uri) throws IOException, ServletException {
        RequestDispatcher rd = this.getRequiredDispatcher(context, uri);
        if (rd != null) {
            rd.forward((ServletRequest)context.getRequest(), (ServletResponse)context.getResponse());
        }
    }

    private RequestDispatcher getRequiredDispatcher(ServletActionContext context, String uri) throws IOException {
        RequestDispatcher rd = context.getContext().getRequestDispatcher(uri);
        if (rd == null) {
            log.debug("No request dispatcher found for " + uri);
            HttpServletResponse response = context.getResponse();
            response.sendError(500, "Error getting RequestDispatcher for " + uri);
        }
        return rd;
    }
}

