/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.BaseMessage;
import org.jgroups.DefaultMessageFactory;
import org.jgroups.Message;
import org.jgroups.MessageFactory;
import org.jgroups.util.ByteArray;
import org.jgroups.util.Util;

public class BatchMessage
extends BaseMessage
implements Iterable<Message> {
    protected Message[] msgs;
    protected int index;
    protected Address orig_src;
    protected static final MessageFactory mf = new DefaultMessageFactory();

    public BatchMessage() {
    }

    public BatchMessage(Address dest, int capacity) {
        super(dest);
        this.msgs = new Message[capacity];
    }

    public BatchMessage(Address dest, Address src, Message[] msgs, int index) {
        super(dest);
        this.orig_src = src;
        this.msgs = msgs;
        this.index = index;
    }

    @Override
    public Supplier<Message> create() {
        return BatchMessage::new;
    }

    @Override
    public short getType() {
        return 7;
    }

    @Override
    public boolean hasPayload() {
        return this.msgs != null && this.index > 0;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    public int getNumberOfMessages() {
        return this.index;
    }

    @Override
    public int getOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BatchMessage setArray(byte[] b, int o, int l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BatchMessage setArray(ByteArray buf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BatchMessage setObject(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject() {
        throw new UnsupportedOperationException();
    }

    public Message[] getMessages() {
        return this.msgs;
    }

    public Address getOrigSender() {
        return this.orig_src;
    }

    public BatchMessage setOrigSender(Address s) {
        this.orig_src = s;
        return this;
    }

    @Override
    public int getLength() {
        int total = 0;
        for (int i = 0; i < this.index && this.msgs != null; ++i) {
            total += this.msgs[i].getLength();
        }
        return total;
    }

    public BatchMessage add(Message msg) {
        this.ensureSameDest(msg);
        this.ensureCapacity(this.index);
        this.msgs[this.index++] = Objects.requireNonNull(msg);
        return this;
    }

    public BatchMessage add(Message ... messages) {
        this.ensureCapacity(this.index + messages.length);
        for (Message msg : messages) {
            if (msg == null) break;
            this.msgs[this.index++] = Objects.requireNonNull(this.ensureSameDest(msg));
        }
        return this;
    }

    public <T extends Message> T get(int index) {
        return (T)this.msgs[index];
    }

    @Override
    public BatchMessage copy(boolean copy_payload, boolean copy_headers) {
        BatchMessage retval = (BatchMessage)super.copy(copy_payload, copy_headers);
        if (copy_payload && this.msgs != null) {
            Message[] copy = new Message[this.msgs.length];
            for (int i = 0; i < this.msgs.length; ++i) {
                if (this.msgs[i] == null) continue;
                copy[i] = this.msgs[i];
            }
            retval.msgs = copy;
            retval.index = this.index;
            retval.orig_src = this.orig_src;
        }
        return retval;
    }

    @Override
    public String toString() {
        return String.format("%s, %d message(s)", super.toString(), this.getNumberOfMessages());
    }

    @Override
    public int size() {
        int retval = super.size() + 4 + this.orig_src.serializedSize();
        if (this.msgs != null) {
            for (int i = 0; i < this.index; ++i) {
                retval += this.msgs[i].size() + 2;
            }
        }
        return retval;
    }

    @Override
    public Iterator<Message> iterator() {
        return new BatchMessageIterator();
    }

    @Override
    public void writePayload(DataOutput out) throws IOException {
        out.writeInt(this.index);
        Util.writeAddress(this.orig_src, out);
        if (this.msgs != null) {
            for (int i = 0; i < this.index; ++i) {
                Message msg = this.msgs[i];
                out.writeShort(msg.getType());
                msg.writeToNoAddrs(this.src(), out, new short[0]);
            }
        }
    }

    @Override
    public void readPayload(DataInput in) throws IOException, ClassNotFoundException {
        this.index = in.readInt();
        this.orig_src = Util.readAddress(in);
        if (this.index > 0) {
            this.msgs = new Message[this.index];
            for (int i = 0; i < this.index; ++i) {
                short type = in.readShort();
                this.msgs[i] = mf.create(type).setDest(this.dest()).setSrc(this.orig_src);
                this.msgs[i].readFrom(in);
            }
        }
    }

    protected void ensureCapacity(int size) {
        if (this.msgs == null) {
            this.msgs = new Message[size + 1];
        } else if (size >= this.msgs.length) {
            this.msgs = Arrays.copyOf(this.msgs, size + 1);
        }
    }

    protected Message ensureSameDest(Message msg) {
        if (!Objects.equals(this.dest, msg.dest())) {
            throw new IllegalStateException(String.format("message dest (%s) does not match dest of BatchMessage (%s)", msg.dest(), this.dest));
        }
        return msg;
    }

    protected class BatchMessageIterator
    implements Iterator<Message> {
        protected int current_index;

        protected BatchMessageIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current_index < BatchMessage.this.index;
        }

        @Override
        public Message next() {
            if (this.current_index >= BatchMessage.this.msgs.length) {
                throw new NoSuchElementException();
            }
            return BatchMessage.this.msgs[this.current_index++];
        }
    }
}

