/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hash;

import java.util.Random;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.hash.MurmurHash3FFM21;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MurmurHash3FFM21Test {
    private Random rand = new Random();
    private static final int trials = 0x100000;

    @Test
    public void compareLongArrLong() {
        int arrLen = 3;
        int iPer = 1;
        long[] key = new long[arrLen];
        for (int i = 0; i < 0x100000; ++i) {
            for (int j = 0; j < arrLen / iPer; ++j) {
                long r;
                key[j] = r = this.rand.nextLong();
            }
            long[] res1 = MurmurHash3FFM21Test.hashV1(key, 0L);
            long[] res2 = MurmurHash3FFM21Test.hashV2(key, 0L);
            Assert.assertEquals((long[])res2, (long[])res1);
        }
    }

    @Test
    public void compareIntArr() {
        int bytes = 4;
        int arrLen = 6;
        int[] key = new int[arrLen];
        int iPer = 8 / bytes;
        int nLongs = arrLen / iPer;
        int shift = 64 / iPer;
        for (int i = 0; i < 0x100000; ++i) {
            for (int j = 0; j < nLongs; ++j) {
                long r = this.rand.nextLong();
                for (int k = 0; k < iPer; ++k) {
                    int shft = k * shift;
                    key[k] = (int)(r >>> shft);
                }
            }
            long[] res1 = MurmurHash3FFM21Test.hashV1(key, 0L);
            long[] res2 = MurmurHash3FFM21Test.hashV2(key, 0L);
            Assert.assertEquals((long[])res2, (long[])res1);
        }
    }

    @Test
    public void compareCharArr() {
        int bytes = 2;
        int arrLen = 12;
        char[] key = new char[arrLen];
        int iPer = 8 / bytes;
        int nLongs = arrLen / iPer;
        int shift = 64 / iPer;
        for (int i = 0; i < 0x100000; ++i) {
            for (int j = 0; j < nLongs; ++j) {
                long r = this.rand.nextLong();
                for (int k = 0; k < iPer; ++k) {
                    int shft = k * shift;
                    key[k] = (char)(r >>> shft);
                }
            }
            long[] res1 = MurmurHash3FFM21Test.hashV1(key, 0L);
            long[] res2 = MurmurHash3FFM21Test.hashV2(key, 0L);
            Assert.assertEquals((long[])res2, (long[])res1);
        }
    }

    @Test
    public void compareByteArr() {
        int bytes = 1;
        int arrLen = 12;
        byte[] key = new byte[arrLen];
        int iPer = 8 / bytes;
        int nLongs = arrLen / iPer;
        int shift = 64 / iPer;
        for (int i = 0; i < 0x100000; ++i) {
            for (int j = 0; j < nLongs; ++j) {
                long r = this.rand.nextLong();
                for (int k = 0; k < iPer; ++k) {
                    int shft = k * shift;
                    key[k] = (byte)(r >>> shft);
                }
            }
            long[] res1 = MurmurHash3FFM21Test.hashV1(key, 0L);
            long[] res2 = MurmurHash3FFM21Test.hashV2(key, 0L);
            Assert.assertEquals((long[])res2, (long[])res1);
        }
    }

    @Test
    public void compareLongVsLongArr() {
        int arrLen = 1;
        long[] key = new long[arrLen];
        long[] out = new long[2];
        for (int i = 0; i < 0x100000; ++i) {
            long r;
            key[0] = r = this.rand.nextLong();
            long[] res1 = MurmurHash3FFM21Test.hashV1(key, 0L);
            long[] res2 = MurmurHash3FFM21Test.hashV2(r, 0L, out);
            Assert.assertEquals((long[])res2, (long[])res1);
        }
    }

    private static final long[] hashV1(long[] key, long seed) {
        return MurmurHash3.hash((long[])key, (long)seed);
    }

    private static final long[] hashV1(int[] key, long seed) {
        return MurmurHash3.hash((int[])key, (long)seed);
    }

    private static final long[] hashV1(char[] key, long seed) {
        return MurmurHash3.hash((char[])key, (long)seed);
    }

    private static final long[] hashV1(byte[] key, long seed) {
        return MurmurHash3.hash((byte[])key, (long)seed);
    }

    private static final long[] hashV2(long[] key, long seed) {
        return MurmurHash3FFM21.hash((long[])key, (long)seed);
    }

    private static final long[] hashV2(int[] key2, long seed) {
        return MurmurHash3FFM21.hash((int[])key2, (long)seed);
    }

    private static final long[] hashV2(char[] key, long seed) {
        return MurmurHash3FFM21.hash((char[])key, (long)seed);
    }

    private static final long[] hashV2(byte[] key, long seed) {
        return MurmurHash3FFM21.hash((byte[])key, (long)seed);
    }

    private static final long[] hashV2(long key, long seed, long[] out) {
        return MurmurHash3FFM21.hash((long)key, (long)seed, (long[])out);
    }

    @Test
    public void offsetChecks() {
        long seed = 12345L;
        int blocks = 6;
        int cap = blocks * 16;
        long[] hash1 = new long[2];
        WritableMemory wmem = WritableMemory.allocate((int)cap);
        for (int i = 0; i < cap; ++i) {
            wmem.putByte((long)i, (byte)(-128 + i));
        }
        for (int offset = 0; offset < 16; ++offset) {
            int arrLen = cap - offset;
            hash1 = MurmurHash3FFM21.hash((Memory)wmem, (long)offset, (long)arrLen, (long)seed, (long[])hash1);
            byte[] byteArr2 = new byte[arrLen];
            wmem.getByteArray((long)offset, byteArr2, 0, arrLen);
            long[] hash2 = MurmurHash3.hash((byte[])byteArr2, (long)seed);
            Assert.assertEquals((long[])hash1, (long[])hash2);
        }
    }

    @Test
    public void byteArrChecks() {
        long seed = 0L;
        int offset = 0;
        int bytes = 1024;
        long[] hash2 = new long[2];
        for (int j = 1; j < bytes; ++j) {
            byte[] in = new byte[bytes];
            WritableMemory wmem = WritableMemory.writableWrap((byte[])in);
            for (int i = 0; i < j; ++i) {
                wmem.putByte((long)i, (byte)(-128 + i));
            }
            long[] hash1 = MurmurHash3.hash((byte[])in, (long)0L);
            hash2 = MurmurHash3FFM21.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
            long[] hash3 = MurmurHash3FFM21.hash((byte[])in, (long)seed);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void charArrChecks() {
        long seed = 0L;
        int offset = 0;
        int chars = 16;
        int bytes = chars << 1;
        long[] hash2 = new long[2];
        for (int j = 1; j < chars; ++j) {
            char[] in = new char[chars];
            WritableMemory wmem = WritableMemory.writableWrap((char[])in);
            for (int i = 0; i < j; ++i) {
                wmem.putInt((long)i, i);
            }
            long[] hash1 = MurmurHash3.hash((char[])in, (long)0L);
            hash2 = MurmurHash3FFM21.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
            long[] hash3 = MurmurHash3FFM21.hash((char[])in, (long)seed);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void intArrChecks() {
        long seed = 0L;
        int offset = 0;
        int ints = 16;
        int bytes = ints << 2;
        long[] hash2 = new long[2];
        for (int j = 1; j < ints; ++j) {
            int[] in = new int[ints];
            WritableMemory wmem = WritableMemory.writableWrap((int[])in);
            for (int i = 0; i < j; ++i) {
                wmem.putInt((long)i, i);
            }
            long[] hash1 = MurmurHash3.hash((int[])in, (long)0L);
            hash2 = MurmurHash3FFM21.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
            long[] hash3 = MurmurHash3FFM21.hash((int[])in, (long)seed);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void longArrChecks() {
        long seed = 0L;
        int offset = 0;
        int longs = 16;
        int bytes = longs << 3;
        long[] hash2 = new long[2];
        for (int j = 1; j < longs; ++j) {
            long[] in = new long[longs];
            WritableMemory wmem = WritableMemory.writableWrap((long[])in);
            for (int i = 0; i < j; ++i) {
                wmem.putLong((long)i, (long)i);
            }
            long[] hash1 = MurmurHash3.hash((long[])in, (long)0L);
            hash2 = MurmurHash3FFM21.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
            long[] hash3 = MurmurHash3FFM21.hash((long[])in, (long)seed);
            Assert.assertEquals((long[])hash1, (long[])hash2);
            Assert.assertEquals((long[])hash1, (long[])hash3);
        }
    }

    @Test
    public void longCheck() {
        long seed = 0L;
        int offset = 0;
        int bytes = 8;
        long[] hash2 = new long[2];
        long[] in = new long[]{1L};
        WritableMemory wmem = WritableMemory.writableWrap((long[])in);
        long[] hash1 = MurmurHash3.hash((long[])in, (long)0L);
        hash2 = MurmurHash3FFM21.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
        long[] hash3 = MurmurHash3FFM21.hash((long[])in, (long)seed);
        Assert.assertEquals((long[])hash1, (long[])hash2);
        Assert.assertEquals((long[])hash1, (long[])hash3);
    }

    @Test
    public void checkEmptiesNulls() {
        long[] larr2;
        int[] iarr2;
        char[] carr2;
        byte[] barr2;
        String s2;
        long seed = 123L;
        long[] hashOut = new long[2];
        try {
            MurmurHash3FFM21.hash((Memory)Memory.wrap((long[])new long[0]), (long)0L, (long)0L, (long)seed, (long[])hashOut);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            s2 = "";
            MurmurHash3FFM21.hash((String)s2, (long)seed, (long[])hashOut);
            Assert.fail();
        }
        catch (IllegalArgumentException s2) {
            // empty catch block
        }
        try {
            s2 = null;
            MurmurHash3FFM21.hash((String)s2, (long)seed, (long[])hashOut);
            Assert.fail();
        }
        catch (IllegalArgumentException s3) {
            // empty catch block
        }
        try {
            barr2 = new byte[]{};
            MurmurHash3FFM21.hash((byte[])barr2, (long)seed);
            Assert.fail();
        }
        catch (IllegalArgumentException barr2) {
            // empty catch block
        }
        try {
            barr2 = null;
            MurmurHash3FFM21.hash((byte[])barr2, (long)seed);
            Assert.fail();
        }
        catch (IllegalArgumentException barr3) {
            // empty catch block
        }
        try {
            carr2 = new char[]{};
            MurmurHash3FFM21.hash((char[])carr2, (long)seed);
            Assert.fail();
        }
        catch (IllegalArgumentException carr2) {
            // empty catch block
        }
        try {
            carr2 = null;
            MurmurHash3FFM21.hash((char[])carr2, (long)seed);
            Assert.fail();
        }
        catch (IllegalArgumentException carr3) {
            // empty catch block
        }
        try {
            iarr2 = new int[]{};
            MurmurHash3FFM21.hash((int[])iarr2, (long)seed);
            Assert.fail();
        }
        catch (IllegalArgumentException iarr2) {
            // empty catch block
        }
        try {
            iarr2 = null;
            MurmurHash3FFM21.hash((int[])iarr2, (long)seed);
            Assert.fail();
        }
        catch (IllegalArgumentException iarr3) {
            // empty catch block
        }
        try {
            larr2 = new long[]{};
            MurmurHash3FFM21.hash((long[])larr2, (long)seed);
            Assert.fail();
        }
        catch (IllegalArgumentException larr2) {
            // empty catch block
        }
        try {
            larr2 = null;
            MurmurHash3FFM21.hash((long[])larr2, (long)seed);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkStringLong() {
        String s = "123";
        long seed = 123L;
        long[] hashOut = new long[2];
        Assert.assertTrue((MurmurHash3FFM21.hash((String)s, (long)seed, (long[])hashOut)[0] != 0L ? 1 : 0) != 0);
        long v = 123L;
        Assert.assertTrue((MurmurHash3FFM21.hash((long)v, (long)seed, (long[])hashOut)[0] != 0L ? 1 : 0) != 0);
    }

    @Test
    public void doubleCheck() {
        long[] hash1 = MurmurHash3FFM21Test.checkDouble(-0.0);
        long[] hash2 = MurmurHash3FFM21Test.checkDouble(0.0);
        Assert.assertEquals((long[])hash1, (long[])hash2);
        hash1 = MurmurHash3FFM21Test.checkDouble(Double.NaN);
        long nan = 9218868437227405313L;
        hash2 = MurmurHash3FFM21Test.checkDouble(Double.longBitsToDouble(nan));
        Assert.assertEquals((long[])hash1, (long[])hash2);
        MurmurHash3FFM21Test.checkDouble(1.0);
    }

    private static long[] checkDouble(double dbl) {
        long seed = 0L;
        int offset = 0;
        int bytes = 8;
        long[] hash2 = new long[2];
        double d = dbl == 0.0 ? 0.0 : dbl;
        long data = Double.doubleToLongBits(d);
        long[] dataArr = new long[]{data};
        WritableMemory wmem = WritableMemory.writableWrap((long[])dataArr);
        long[] hash1 = MurmurHash3.hash((long[])dataArr, (long)0L);
        hash2 = MurmurHash3FFM21.hash((Memory)wmem, (long)offset, (long)bytes, (long)seed, (long[])hash2);
        long[] hash3 = MurmurHash3FFM21.hash((double)dbl, (long)seed, (long[])hash2);
        Assert.assertEquals((long[])hash1, (long[])hash2);
        Assert.assertEquals((long[])hash1, (long[])hash3);
        return hash1;
    }
}

