/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;

public class DbFile {
    public static String stringFromFile(InputStream is) throws Exception {
        String l;
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringBuffer sb = new StringBuffer();
        while ((l = br.readLine()) != null) {
            sb.append(l);
            sb.append("<CR>");
        }
        is.close();
        return sb.toString();
    }

    public static URL getResourceURL(String packageName, String name) {
        String resourceName = "/" + packageName.replace('.', '/') + "/" + name;
        Class<?> c = resourceName.getClass();
        URL url = c.getResource(resourceName);
        return url;
    }

    public static InputStream getResourceAsStream(String packageName, String name) {
        String resourceName = "/" + packageName.replace('.', '/') + "/" + name;
        Class<?> c = resourceName.getClass();
        InputStream result = c.getResourceAsStream(resourceName);
        return result;
    }

    public static boolean deleteFile(String outputFileName) throws Exception {
        File f = new File(outputFileName);
        return f.delete();
    }

    public static String mkFileFromResource(String packageName, String resourceName) throws Exception {
        return DbFile.mkFileFromResource(packageName, resourceName, resourceName);
    }

    public static String mkFileFromResource(String packageName, String resourceName, String outputFileName) throws Exception {
        File f = new File(outputFileName);
        InputStream is = DbFile.getResourceAsStream(packageName, resourceName);
        BufferedInputStream bis = new BufferedInputStream(is);
        FileOutputStream os = new FileOutputStream(f);
        byte[] buf = new byte[4096];
        int readThisTime = 0;
        while ((readThisTime = bis.read(buf)) != -1) {
            ((OutputStream)os).write(buf, 0, readThisTime);
        }
        ((OutputStream)os).close();
        return f.getAbsolutePath();
    }
}

