/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DriverManagerConnector
implements Connector {
    private TestConfiguration config;

    @Override
    public void setConfiguration(TestConfiguration config) {
        this.config = config;
    }

    @Override
    public Connection openConnection() throws SQLException {
        return this.openConnection(this.config.getDefaultDatabaseName(), this.config.getUserName(), this.config.getUserPassword());
    }

    @Override
    public Connection openConnection(String databaseName) throws SQLException {
        return this.openConnection(databaseName, this.config.getUserName(), this.config.getUserPassword());
    }

    @Override
    public Connection openConnection(String user, String password) throws SQLException {
        return this.openConnection(this.config.getDefaultDatabaseName(), user, password);
    }

    @Override
    public Connection openConnection(String databaseName, String user, String password) throws SQLException {
        return this.openConnection(databaseName, user, password, null);
    }

    @Override
    public Connection openConnection(String databaseName, String user, String password, Properties connectionProperties) throws SQLException {
        String url = this.config.getJDBCUrl(databaseName);
        try {
            DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            this.loadJDBCDriver();
        }
        Properties connectionAttributes = new Properties(this.config.getConnectionAttributes());
        if (user != null) {
            connectionAttributes.setProperty("user", user);
        }
        if (password != null) {
            connectionAttributes.setProperty("password", password);
        }
        if (connectionProperties != null) {
            connectionAttributes.putAll((Map<?, ?>)connectionProperties);
        }
        try {
            return DriverManager.getConnection(url, connectionAttributes);
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            Properties attributes = new Properties(connectionAttributes);
            attributes.setProperty("create", "true");
            return DriverManager.getConnection(url, attributes);
        }
    }

    private static void printFullException(Throwable t, int indentLevel) {
        if (t == null) {
            return;
        }
        String tab = "    ";
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < indentLevel; ++i) {
            buffer.append(tab);
        }
        buffer.append("Message:  " + t.getMessage());
        SQLException nextSQLException = null;
        if (t instanceof SQLException) {
            SQLException se = (SQLException)t;
            buffer.append(se.getClass().getName() + " : SQLState = " + se.getSQLState());
            nextSQLException = se.getNextException();
        }
        System.out.println(buffer.toString());
        DriverManagerConnector.printFullException(nextSQLException, indentLevel + 1);
        DriverManagerConnector.printFullException(t.getCause(), indentLevel + 1);
    }

    @Override
    public void shutDatabase() throws SQLException {
        Properties p = new Properties();
        p.setProperty("shutdown", "true");
        this.getConnectionByAttributes(this.config.getJDBCUrl(), p);
        this.config.waitForShutdownComplete(this.getDatabaseName());
    }

    @Override
    public void shutEngine(boolean deregisterDriver) throws SQLException {
        Properties p = new Properties();
        p.setProperty("shutdown", "true");
        if (!deregisterDriver) {
            p.setProperty("deregister", "false");
        }
        this.getConnectionByAttributes("jdbc:derby:", p);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    private Connection getConnectionByAttributes(String url, Properties p) throws SQLException {
        Properties attributes = new Properties();
        attributes.setProperty("user", this.config.getUserName());
        attributes.setProperty("password", this.config.getUserPassword());
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            attributes.setProperty(key, p.getProperty(key));
        }
        try {
            DriverManager.getDriver(url);
        }
        catch (SQLException e2) {
            this.loadJDBCDriver();
        }
        return DriverManager.getConnection(url, attributes);
    }

    @Override
    public String getDatabaseName() {
        String databaseName = this.config.getDefaultDatabaseName();
        return databaseName;
    }

    private void loadJDBCDriver() throws SQLException {
        String driverClass = this.config.getJDBCClient().getJDBCDriverName();
        try {
            Class<?> clazz = Class.forName(driverClass);
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("Failed to load JDBC driver '" + driverClass + "': " + cnfe.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new SQLException("Failed to load JDBC driver '" + driverClass + "': " + iae.getMessage());
        }
        catch (InstantiationException ie) {
            throw new SQLException("Failed to load JDBC driver '" + driverClass + "': " + ie.getMessage());
        }
        catch (NoSuchMethodException ie) {
            throw new SQLException("Failed to load JDBC driver '" + driverClass + "': " + ie.getMessage());
        }
        catch (InvocationTargetException ie) {
            throw new SQLException("Failed to load JDBC driver '" + driverClass + "': " + ie.getMessage());
        }
    }
}

