/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Barrier;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LockTableVtiTest
extends BaseJDBCTestCase {
    private List<AsyncThread> threads = new ArrayList<AsyncThread>();

    public LockTableVtiTest(String name) {
        super(name);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.locks.waitTimeout", "60");
        Object suite = TestConfiguration.defaultSuite(LockTableVtiTest.class);
        suite = new DatabasePropertyTestSetup((Test)suite, properties, true);
        return new CleanDatabaseTestSetup((Test)suite);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table account (a int primary key not null, b int)");
        s.executeUpdate("insert into account values (0,1)");
        s.executeUpdate("insert into account values (1,1)");
        s.executeUpdate("insert into account values (2,1)");
        s.close();
        conn.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        block3: {
            this.rollback();
            for (AsyncThread thread : this.threads) {
                thread.waitFor();
            }
            this.threads = null;
            this.setAutoCommit(false);
            try {
                Statement s = this.createStatement();
                s.executeUpdate("drop table account");
                JDBC.dropSchema(this.getConnection().getMetaData(), "APP");
            }
            catch (SQLException sqe) {
                if (sqe.getSQLState().equalsIgnoreCase("42X05") || sqe.getSQLState().equalsIgnoreCase("42Y55")) break block3;
                LockTableVtiTest.fail((String)"oops in teardown, encountered some other error than 'object does not exist' or 'cannot drop object because it doesn't exist'");
                sqe.printStackTrace();
                sqe.getMessage();
            }
        }
        super.tearDown();
    }

    public void testDisplayWaitState() throws Exception {
        Statement s = this.createStatement();
        this.setAutoCommit(false);
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.locks.waitTimeout','-1')");
        BaseJDBCTestCase.assertUpdateCount(s, 3, "update account set b = b + 11");
        final Barrier barrier = new Barrier(2);
        new AsyncThread(new AsyncTask(){

            @Override
            public void doWork(Connection conn) throws Exception {
                conn.setAutoCommit(false);
                Statement s = conn.createStatement();
                s.executeUpdate("update account set b = b + 11");
                s.close();
                barrier.await();
            }
        });
        int totalWait = 0;
        boolean found = false;
        do {
            Thread.sleep(500L);
        } while (!(found = this.getWaitState()) && (totalWait += 500) < 6000);
        this.commit();
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.locks.waitTimeout','5')");
        this.commit();
        barrier.await();
        LockTableVtiTest.assertTrue((String)"expected to find a 'WAIT' state, but did not", (boolean)found);
        LockTableVtiTest.assertFalse((String)"expected to not find a 'WAIT' state, but did", (boolean)this.getWaitState());
    }

    private boolean getWaitState() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("SELECT state from syscs_diag.lock_table where state like 'WAIT' order by state");
        String result = "";
        try {
            rs.next();
            result = rs.getString(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        rs.close();
        return result != null && result.length() > 0;
    }

    private class AsyncThread
    implements Runnable {
        private final Thread thread = new Thread(this);
        private final AsyncTask task;
        private Exception error;

        public AsyncThread(AsyncTask task) {
            this.task = task;
            this.thread.start();
            LockTableVtiTest.this.threads.add(this);
        }

        @Override
        public void run() {
            try {
                Connection conn = LockTableVtiTest.this.openDefaultConnection();
                try {
                    this.task.doWork(conn);
                }
                finally {
                    JDBC.cleanup(conn);
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }

        void waitFor() throws Exception {
            this.thread.join();
            if (this.error != null) {
                throw this.error;
            }
        }
    }

    private static interface AsyncTask {
        public void doWork(Connection var1) throws Exception;
    }
}

