/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import org.apache.batik.util.gui.resource.ResourceManager;

public class StatusBar
extends JPanel {
    protected static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.StatusBarMessages";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.StatusBarMessages", Locale.getDefault());
    protected static ResourceManager rManager = new ResourceManager(bundle);
    protected JLabel xPosition;
    protected JLabel yPosition;
    protected JLabel zoom;
    protected JLabel message;
    protected String mainMessage;
    protected String temporaryMessage;
    protected DisplayThread displayThread;

    public StatusBar() {
        super(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.add("West", jPanel);
        this.xPosition = new JLabel();
        BevelBorder bevelBorder = new BevelBorder(1, this.getBackground().brighter().brighter(), this.getBackground(), this.getBackground().darker().darker(), this.getBackground());
        this.xPosition.setBorder(bevelBorder);
        this.xPosition.setPreferredSize(new Dimension(110, 16));
        jPanel.add("West", this.xPosition);
        this.yPosition = new JLabel();
        this.yPosition.setBorder(bevelBorder);
        this.yPosition.setPreferredSize(new Dimension(110, 16));
        jPanel.add("Center", this.yPosition);
        this.zoom = new JLabel();
        this.zoom.setBorder(bevelBorder);
        this.zoom.setPreferredSize(new Dimension(70, 16));
        jPanel.add("East", this.zoom);
        jPanel = new JPanel(new BorderLayout(0, 0));
        this.message = new JLabel();
        this.message.setBorder(bevelBorder);
        jPanel.add(this.message);
        this.add(jPanel);
        this.setMainMessage(rManager.getString("Panel.default_message"));
    }

    public void setXPosition(float f) {
        this.xPosition.setText("x: " + f);
    }

    public void setWidth(float f) {
        this.xPosition.setText(rManager.getString("Position.width_letters") + " " + f);
    }

    public void setYPosition(float f) {
        this.yPosition.setText("y: " + f);
    }

    public void setHeight(float f) {
        this.yPosition.setText(rManager.getString("Position.height_letters") + " " + f);
    }

    public void setZoom(float f) {
        float f2 = f = f > 0.0f ? f : -f;
        if (f == 1.0f) {
            this.zoom.setText("1:1");
        } else if (f >= 1.0f) {
            String string = Float.toString(f);
            if (string.length() > 6) {
                string = string.substring(0, 6);
            }
            this.zoom.setText("1:" + string);
        } else {
            String string = Float.toString(1.0f / f);
            if (string.length() > 6) {
                string = string.substring(0, 6);
            }
            this.zoom.setText(string + ":1");
        }
    }

    public void setMessage(String string) {
        this.setPreferredSize(new Dimension(0, this.getPreferredSize().height));
        if (this.displayThread != null) {
            this.displayThread.finish();
        }
        this.temporaryMessage = string;
        DisplayThread displayThread = this.displayThread;
        this.displayThread = new DisplayThread(displayThread);
        this.displayThread.start();
    }

    public void setMainMessage(String string) {
        this.mainMessage = string;
        this.mainMessage = string;
        this.message.setText(this.mainMessage);
        if (this.displayThread != null) {
            this.displayThread.finish();
            this.displayThread = null;
        }
        this.setPreferredSize(new Dimension(0, this.getPreferredSize().height));
    }

    protected class DisplayThread
    extends Thread {
        static final long DEFAULT_DURATION = 5000L;
        long duration;
        Thread toJoin;

        public DisplayThread() {
            this(5000L, null);
        }

        public DisplayThread(long l) {
            this(l, null);
        }

        public DisplayThread(Thread thread) {
            this(5000L, thread);
        }

        public DisplayThread(long l, Thread thread) {
            this.duration = l;
            this.toJoin = thread;
            this.setPriority(1);
        }

        public synchronized void finish() {
            this.duration = 0L;
            this.notifyAll();
        }

        public void run() {
            DisplayThread displayThread = this;
            synchronized (displayThread) {
                if (this.toJoin != null) {
                    while (this.toJoin.isAlive()) {
                        try {
                            this.toJoin.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.toJoin = null;
                }
                StatusBar.this.message.setText(StatusBar.this.temporaryMessage);
                long l = System.currentTimeMillis();
                while (this.duration > 0L) {
                    try {
                        this.wait(this.duration);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long l2 = System.currentTimeMillis();
                    this.duration -= l2 - l;
                    l = l2;
                }
                StatusBar.this.message.setText(StatusBar.this.mainMessage);
            }
        }
    }
}

