/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Connection;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TestJDBC40Exception
extends BaseJDBCTestCase {
    public TestJDBC40Exception(String string) {
        super(string);
    }

    public static Test suite() {
        Test test = TestConfiguration.defaultSuite(TestJDBC40Exception.class);
        return DatabasePropertyTestSetup.setLockTimeouts(test, -1, 2);
    }

    protected void setUp() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table EXCEPTION_TABLE1 (id integer primary key, data varchar (5))");
        statement.execute("insert into EXCEPTION_TABLE1 (id, data)values (1, 'data1')");
        statement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("drop table EXCEPTION_TABLE1");
        statement.close();
        this.commit();
        super.tearDown();
    }

    public void testIntegrityConstraintViolationException() throws SQLException {
        try {
            this.createStatement().execute("insert into EXCEPTION_TABLE1 (id, data) values (1, 'data1')");
            TestJDBC40Exception.fail((String)"Statement didn't fail.");
        }
        catch (SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException) {
            TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + sQLIntegrityConstraintViolationException.getSQLState()), (boolean)sQLIntegrityConstraintViolationException.getSQLState().startsWith("23"));
        }
    }

    public void testDataException() throws SQLException {
        try {
            this.createStatement().execute("insert into EXCEPTION_TABLE1 (id, data)values (2, 'data1234556')");
            TestJDBC40Exception.fail((String)"Statement didn't fail.");
        }
        catch (SQLDataException sQLDataException) {
            TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + sQLDataException.getSQLState()), (boolean)sQLDataException.getSQLState().startsWith("22"));
        }
    }

    public void testConnectionException() throws SQLException {
        Statement statement = this.createStatement();
        this.getConnection().close();
        try {
            statement.execute("select * from exception1");
            TestJDBC40Exception.fail((String)"Statement didn't fail.");
        }
        catch (SQLNonTransientConnectionException sQLNonTransientConnectionException) {
            TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + sQLNonTransientConnectionException.getSQLState()), (boolean)sQLNonTransientConnectionException.getSQLState().startsWith("08"));
        }
        if (TestJDBC40Exception.usingEmbedded()) {
            statement = this.createStatement();
            TestConfiguration.getCurrent().shutdownDatabase();
            try {
                statement.execute("select * from exception1");
                TestJDBC40Exception.fail((String)"Statement didn't fail.");
            }
            catch (SQLNonTransientConnectionException sQLNonTransientConnectionException) {
                TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + sQLNonTransientConnectionException.getSQLState()), (boolean)sQLNonTransientConnectionException.getSQLState().startsWith("08"));
            }
        }
        if (TestJDBC40Exception.usingDerbyNetClient()) {
            DataSource dataSource = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(dataSource, "portNumber", 0);
            try {
                dataSource.getConnection();
            }
            catch (SQLNonTransientConnectionException sQLNonTransientConnectionException) {
                TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + sQLNonTransientConnectionException.getSQLState()), (boolean)sQLNonTransientConnectionException.getSQLState().startsWith("08"));
            }
        }
    }

    public void testSyntaxErrorException() throws SQLException {
        try {
            this.createStatement().execute("insert into EXCEPTION_TABLE1 (id, data) values ('2', 'data1')");
            TestJDBC40Exception.fail((String)"Statement didn't fail.");
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + sQLSyntaxErrorException.getSQLState()), (boolean)sQLSyntaxErrorException.getSQLState().startsWith("42"));
        }
    }

    public void testTimeout() throws SQLException {
        Connection connection = this.openDefaultConnection();
        Connection connection2 = this.openDefaultConnection();
        connection.setAutoCommit(false);
        connection2.setAutoCommit(false);
        connection.setTransactionIsolation(8);
        connection2.setTransactionIsolation(8);
        connection.createStatement().execute("select * from EXCEPTION_TABLE1 for update");
        try {
            connection2.createStatement().execute("select * from EXCEPTION_TABLE1 for update");
            TestJDBC40Exception.fail((String)"Statement didn't fail.");
        }
        catch (SQLTransactionRollbackException sQLTransactionRollbackException) {
            TestJDBC40Exception.assertTrue((String)("Unexpected SQL State: " + sQLTransactionRollbackException.getSQLState()), (boolean)sQLTransactionRollbackException.getSQLState().startsWith("40"));
        }
        connection.rollback();
        connection.close();
        connection2.rollback();
        connection2.close();
    }
}

