/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementPoolingTest
extends BaseJDBCTestCase {
    private LogicalPooledConnectionFactory lpcf;

    public StatementPoolingTest(String string) {
        super(string);
    }

    @Override
    public void tearDown() throws Exception {
        this.closePooledConnectionFactory();
        super.tearDown();
    }

    private void closePooledConnectionFactory() throws SQLException {
        if (this.lpcf != null) {
            try {
                this.lpcf.close();
            }
            finally {
                this.lpcf = null;
            }
        }
    }

    private Connection getCachingConnection() throws SQLException {
        return this.getCachingConnection(7);
    }

    private Connection getCachingConnection(int n) throws SQLException {
        if (this.lpcf == null) {
            this.lpcf = new LogicalPooledConnectionFactory();
        }
        return this.lpcf.getConnection(n);
    }

    public void testCacheOverflow() throws SQLException {
        Connection connection = this.getCachingConnection(11);
        for (int i = 0; i < 150; ++i) {
            PreparedStatement preparedStatement = connection.prepareStatement("values " + i);
            ResultSet resultSet = preparedStatement.executeQuery();
            JDBC.assertSingleValueResultSet(resultSet, Integer.toString(i));
            preparedStatement.close();
        }
        connection.close();
    }

    public void testPoolingEnabledByCheckingImplementationDetails() throws SQLException {
        Connection connection = this.getCachingConnection();
        StatementPoolingTest.assertClassName(connection, "CachingLogicalConnection");
        StatementPoolingTest.assertClassName(connection.prepareStatement("values 1"), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(connection.prepareStatement("values 1", 1), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(connection.prepareStatement("values 1", 2), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(connection.prepareStatement("values 1", 1003, 1007), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(connection.prepareStatement("values 1", 1004, 1008), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(connection.prepareStatement("values 1", (String[])null), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(connection.prepareStatement("values 1", new String[0]), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(connection.prepareCall("values 1"), "LogicalCallableStatement");
        StatementPoolingTest.assertClassName(connection.prepareCall("values 1", 1003, 1007), "LogicalCallableStatement");
        StatementPoolingTest.assertClassName(connection.prepareCall("values 1", 1003, 1007, 2), "LogicalCallableStatement");
        StatementPoolingTest.assertClassName(connection.getMetaData(), "LogicalDatabaseMetaData");
    }

    private static void assertClassName(Object object, String object2) {
        StatementPoolingTest.assertNotNull((String)"The expected name cannot be <null>", (Object)object2);
        StatementPoolingTest.assertNotNull((String)"The object cannot be <null>", (Object)object);
        String[] stringArray = object.getClass().getName().split("\\.");
        String string = stringArray[stringArray.length - 1];
        if (JDBC.vmSupportsJDBC4() && !((String)object2).endsWith("40")) {
            if (JDBC.vmSupportsJDBC42() && ((String)object2).contains("Statement")) {
                object2 = (String)object2 + "42";
            } else if (StatementPoolingTest.usingEmbedded()) {
                object2 = (String)object2 + "40";
            }
        }
        StatementPoolingTest.assertEquals((String)object2, (String)string);
    }

    public void testPrepareStatementPath() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("values 9708");
        preparedStatement.close();
    }

    public void testPrepareCallPath() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        callableStatement.close();
    }

    public void testPrepareCallWithNoCallPath() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("values 1");
        callableStatement.close();
    }

    public void testClosingPSClosesRS() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("values 99");
        ResultSet resultSet = preparedStatement.executeQuery();
        preparedStatement.close();
        try {
            resultSet.next();
            StatementPoolingTest.fail((String)"Result set should have been closed");
        }
        catch (SQLException sQLException) {
            StatementPoolingTest.assertSQLState("XCL16", sQLException);
        }
    }

    public void testHoldabilityIsResetExplicitClose() throws SQLException {
        this.doTestHoldabilityIsReset(true);
    }

    public void testHoldabilityIsResetNoExplicitClose() throws SQLException {
        this.doTestHoldabilityIsReset(false);
    }

    private void doTestHoldabilityIsReset(boolean bl) throws SQLException {
        Connection connection = this.getCachingConnection();
        StatementPoolingTest.assertEquals((String)"Unexpected default holdability", (int)1, (int)connection.getHoldability());
        connection.setHoldability(2);
        StatementPoolingTest.assertEquals((String)"Holdability not updated", (int)2, (int)connection.getHoldability());
        if (bl) {
            connection.close();
        }
        connection = this.getCachingConnection();
        StatementPoolingTest.assertEquals((String)"Holdability not reset", (int)1, (int)connection.getHoldability());
    }

    public void testIsolationLevelIsResetExplicitCloseQuery() throws SQLException {
        this.doTestIsolationLevelIsReset(true, true);
    }

    public void testIsolationLevelIsResetExplicitCloseNoQuery() throws SQLException {
        this.doTestIsolationLevelIsReset(true, false);
    }

    public void testIsolationLevelIsResetNoExplicitCloseNoQuery() throws SQLException {
        this.doTestIsolationLevelIsReset(false, false);
    }

    public void testIsolationLevelIsResetNoExplicitCloseQuery() throws SQLException {
        this.doTestIsolationLevelIsReset(false, true);
    }

    private void doTestIsolationLevelIsReset(boolean bl, boolean bl2) throws SQLException {
        Connection connection = this.getCachingConnection();
        StatementPoolingTest.assertEquals((String)"Unexpected default isolation level", (int)2, (int)connection.getTransactionIsolation());
        connection.setTransactionIsolation(4);
        StatementPoolingTest.assertEquals((String)"Isolation level not updated", (int)4, (int)connection.getTransactionIsolation());
        if (bl2) {
            PreparedStatement preparedStatement = connection.prepareStatement("values 2");
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "2");
            preparedStatement.close();
        }
        if (bl) {
            connection.close();
        }
        connection = this.getCachingConnection();
        StatementPoolingTest.assertEquals((String)"Isolation level not reset", (int)2, (int)connection.getTransactionIsolation());
    }

    public void testCachingLogicalConnectionCloseLeavesPhysicalStatementsOpen() throws SQLException {
        Connection connection = this.getCachingConnection();
        connection.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table clcclso (id int)");
        PreparedStatement preparedStatement = connection.prepareStatement("select * from clcclso");
        connection.commit();
        connection.close();
        try {
            preparedStatement.execute();
            StatementPoolingTest.fail((String)"Logical connection close did not close logical statement.");
        }
        catch (SQLException sQLException) {
            StatementPoolingTest.assertSQLState("XJ012", sQLException);
        }
        statement = this.createStatement();
        statement.executeUpdate("drop table clcclso");
        this.commit();
        connection = this.getCachingConnection();
        preparedStatement = connection.prepareStatement("select * from clcclso");
        try {
            preparedStatement.execute();
            StatementPoolingTest.fail((String)"Execution should have failed");
        }
        catch (SQLException sQLException) {
            StatementPoolingTest.assertSQLState("42X05", sQLException);
        }
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("values 976");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "976");
        preparedStatement.close();
        connection.close();
    }

    public void resTestCloseDoesNotAffectOtherStatement() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select * from stmtpooltest where val > 0 and val <= 7 order by val");
        ResultSet resultSet = preparedStatement.executeQuery();
        StatementPoolingTest.assertTrue((boolean)resultSet.next());
        StatementPoolingTest.assertEquals((String)"1", (String)resultSet.getString(1));
        StatementPoolingTest.assertTrue((boolean)resultSet.next());
        StatementPoolingTest.assertEquals((String)"2", (String)resultSet.getString(1));
        PreparedStatement preparedStatement2 = this.prepareStatement("select * from stmtpooltest where val > 0 and val <= 7 order by val", 1004, 1007);
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        for (int i = 1; i <= 7; ++i) {
            StatementPoolingTest.assertTrue((boolean)resultSet2.next());
            StatementPoolingTest.assertEquals((int)i, (int)resultSet2.getInt(1));
        }
        PreparedStatement preparedStatement3 = this.prepareStatement("select val from stmtpooltest where val = 5");
        JDBC.assertSingleValueResultSet(preparedStatement3.executeQuery(), "5");
        preparedStatement3.close();
        StatementPoolingTest.assertTrue((boolean)resultSet.next());
        StatementPoolingTest.assertEquals((String)"3", (String)resultSet.getString(1));
        StatementPoolingTest.assertTrue((boolean)resultSet2.first());
        StatementPoolingTest.assertEquals((String)"1", (String)resultSet2.getString(1));
        preparedStatement3 = this.prepareStatement("select val from stmtpooltest where val = 5");
        JDBC.assertSingleValueResultSet(preparedStatement3.executeQuery(), "5");
        preparedStatement3.close();
        StatementPoolingTest.assertTrue((boolean)resultSet2.last());
        StatementPoolingTest.assertEquals((String)"7", (String)resultSet2.getString(1));
        StatementPoolingTest.assertFalse((boolean)resultSet2.next());
        resultSet2.close();
        StatementPoolingTest.assertTrue((boolean)resultSet.next());
        StatementPoolingTest.assertEquals((String)"4", (String)resultSet.getString(1));
        resultSet.close();
    }

    public void testDeleteReferringTableWhenOpen() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table testdeletewhenopen (id int)");
        statement.executeUpdate("insert into testdeletewhenopen values 1");
        PreparedStatement preparedStatement = this.prepareStatement("select * from testdeletewhenopen");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        statement.executeUpdate("drop table testdeletewhenopen");
        statement.close();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select * from testdeletewhenopen");
        try {
            preparedStatement.executeQuery();
            StatementPoolingTest.fail((String)"Prepared statement not valid, referring non-existing table");
        }
        catch (SQLException sQLException) {
            StatementPoolingTest.assertSQLState("42X05", sQLException);
        }
    }

    public void testDeleteReferringTableWhenInCache() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table testdeletewhenopen (id int)");
        statement.executeUpdate("insert into testdeletewhenopen values 1");
        PreparedStatement preparedStatement = this.prepareStatement("select * from testdeletewhenopen");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement.close();
        statement.executeUpdate("drop table testdeletewhenopen");
        statement.close();
        preparedStatement = this.prepareStatement("select * from testdeletewhenopen");
        try {
            preparedStatement.executeQuery();
            StatementPoolingTest.fail((String)"Prepared statement not valid, referring non-existing table");
        }
        catch (SQLException sQLException) {
            StatementPoolingTest.assertSQLState("42X05", sQLException);
        }
    }

    public void resTestCloseCursorsAtCommit() throws SQLException {
        this.doTestResultSetCloseForHoldability(2);
    }

    public void resTestHoldCursorsOverCommit() throws SQLException {
        this.doTestResultSetCloseForHoldability(1);
    }

    public void testTemporaryTablesAreDeletedInNewLogicalConnection() throws SQLException {
        Connection connection = this.getCachingConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE cpds_temp_table (id int) ON COMMIT PRESERVE ROWS NOT LOGGED");
        JDBC.assertEmpty(statement.executeQuery("select * from SESSION.cpds_temp_table"));
        statement.executeUpdate("insert into SESSION.cpds_temp_table values 1");
        connection.commit();
        connection.close();
        Connection connection2 = this.getCachingConnection();
        statement = connection2.createStatement();
        try {
            statement.executeQuery("select * from SESSION.cpds_temp_table");
            StatementPoolingTest.fail((String)"Temporary table still existing in new logical connection.");
        }
        catch (SQLException sQLException) {
            StatementPoolingTest.assertSQLState("42X05", sQLException);
        }
        connection2.rollback();
        connection2.close();
    }

    private void doTestResultSetCloseForHoldability(int n) throws SQLException {
        this.getConnection().setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("select * from stmtpooltest order by val", 1003, 1007, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        StatementPoolingTest.assertTrue((boolean)resultSet.next());
        StatementPoolingTest.assertEquals((int)1, (int)resultSet.getInt(1));
        this.commit();
        if (n == 1) {
            StatementPoolingTest.assertTrue((boolean)resultSet.next());
            StatementPoolingTest.assertEquals((int)2, (int)resultSet.getInt(1));
            this.rollback();
        }
        this.getConnection().close();
        try {
            resultSet.next();
            StatementPoolingTest.fail((String)"Should have thrown exception");
        }
        catch (SQLException sQLException) {
            StatementPoolingTest.assertSQLState("XCL16", sQLException);
        }
    }

    public void testGetStatementCallable() throws SQLException {
        this.doTestGetStatement(this.prepareCall("values 7653"));
    }

    public void testGetStatementPrepared() throws SQLException {
        this.doTestGetStatement(this.prepareStatement("values 7652"));
    }

    private void doTestGetStatement(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet = preparedStatement.executeQuery();
        StatementPoolingTest.assertSame((Object)preparedStatement, (Object)resultSet.getStatement());
        resultSet.close();
        preparedStatement.execute();
        resultSet = preparedStatement.getResultSet();
        StatementPoolingTest.assertSame((Object)preparedStatement, (Object)resultSet.getStatement());
        StatementPoolingTest.assertFalse((boolean)preparedStatement.getMoreResults());
        StatementPoolingTest.assertNull((Object)preparedStatement.getResultSet());
        try {
            resultSet = preparedStatement.executeQuery("values 99");
            StatementPoolingTest.fail((String)"executeQuery(String) should be disallowed");
        }
        catch (SQLException sQLException) {
            StatementPoolingTest.assertSQLState("XJ016", sQLException);
        }
    }

    public void resTestLogicalConnectionCloseInvalidatesLogicalStatement() throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("select * from stmtpooltest");
        StatementPoolingTest.assertNotNull((Object)preparedStatement.getMetaData());
        connection.close();
        try {
            preparedStatement.getMetaData();
            StatementPoolingTest.fail((String)"Logical statement should be closed and throw exception");
        }
        catch (SQLException sQLException) {
            StatementPoolingTest.assertSQLState("XJ012", sQLException);
        }
        connection = this.getConnection();
        preparedStatement = connection.prepareStatement("select * from stmtpooltest order by val");
        ResultSet resultSet = preparedStatement.executeQuery();
        StatementPoolingTest.assertTrue((boolean)resultSet.next());
        StatementPoolingTest.assertNotNull((Object)preparedStatement.getMetaData());
        resultSet.close();
        connection.close();
        try {
            preparedStatement.getMetaData();
            StatementPoolingTest.fail((String)"Logical statement should be closed and throw exception");
        }
        catch (SQLException sQLException) {
            StatementPoolingTest.assertSQLState("XJ012", sQLException);
        }
    }

    public void resTestNoCommitOnReuse() throws SQLException {
        this.cleanTableExceptedToBeEmpty();
        this.getConnection().setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into stmtpooldata (val) values ?");
        preparedStatement.setInt(1, 68);
        StatementPoolingTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        preparedStatement.close();
        preparedStatement = this.prepareStatement("insert into stmtpooldata (val) values ?");
        preparedStatement.setInt(1, 77);
        StatementPoolingTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"68"}, {"77"}});
        this.rollback();
        resultSet = statement.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertEmpty(resultSet);
    }

    public void resTestCommitOnReuse() throws SQLException {
        this.cleanTableExceptedToBeEmpty();
        this.getConnection().setAutoCommit(true);
        PreparedStatement preparedStatement = this.prepareStatement("insert into stmtpooldata (val) values ?");
        preparedStatement.setInt(1, 68);
        StatementPoolingTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        preparedStatement.close();
        preparedStatement = this.prepareStatement("insert into stmtpooldata (val) values ?");
        preparedStatement.setInt(1, 77);
        StatementPoolingTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"68"}, {"77"}});
        this.rollback();
        resultSet = statement.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"68"}, {"77"}});
        StatementPoolingTest.assertEquals((int)2, (int)statement.executeUpdate("delete from stmtpooldata"));
    }

    public void resTestNoDataCommittedOnInvalidTransactionState() throws SQLException {
        this.cleanTableExceptedToBeEmpty();
        this.getConnection().setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into stmtpooldata (val) values ?");
        preparedStatement.setInt(1, 68);
        StatementPoolingTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        preparedStatement.close();
        preparedStatement = this.prepareStatement("insert into stmtpooldata (val) values ?");
        preparedStatement.setInt(1, 77);
        StatementPoolingTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"68"}, {"77"}});
        try {
            this.getConnection().close();
            statement = this.createStatement();
            resultSet = statement.executeQuery("select val from stmtpooldata order by val");
            int n = 0;
            while (resultSet.next()) {
                ++n;
            }
            StatementPoolingTest.fail((String)("Connection should not be allowed to close. Rows in table: " + n));
        }
        catch (SQLException sQLException) {
            StatementPoolingTest.assertSQLState("25001", sQLException);
            this.rollback();
        }
        statement = this.createStatement();
        resultSet = statement.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertEmpty(resultSet);
    }

    private void cleanTableExceptedToBeEmpty() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from stmtpooldata");
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        resultSet.close();
        if (n > 0) {
            StatementPoolingTest.println("Expected empty table, got " + n + " rows.");
            StatementPoolingTest.assertEquals((int)n, (int)statement.executeUpdate("delete from stmtpooldata"));
        }
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("StatementPoolingTest suite");
        BaseTestSuite baseTestSuite2 = new BaseTestSuite(StatementPoolingTest.class);
        baseTestSuite.addTest(TestConfiguration.connectionCPDecorator((Test)baseTestSuite2));
        BaseTestSuite baseTestSuite3 = new BaseTestSuite("Requires data suite");
        baseTestSuite3.addTest((Test)new StatementPoolingTest("resTestCloseDoesNotAffectOtherStatement"));
        baseTestSuite3.addTest((Test)new StatementPoolingTest("resTestLogicalConnectionCloseInvalidatesLogicalStatement"));
        baseTestSuite3.addTest((Test)new StatementPoolingTest("resTestHoldCursorsOverCommit"));
        baseTestSuite3.addTest((Test)new StatementPoolingTest("resTestCloseCursorsAtCommit"));
        baseTestSuite3.addTest((Test)new StatementPoolingTest("resTestNoCommitOnReuse"));
        baseTestSuite3.addTest((Test)new StatementPoolingTest("resTestCommitOnReuse"));
        baseTestSuite3.addTest((Test)new StatementPoolingTest("resTestNoDataCommittedOnInvalidTransactionState"));
        baseTestSuite.addTest(TestConfiguration.connectionCPDecorator((Test)new BaseJDBCTestSetup((Test)baseTestSuite3){

            public void setUp() throws Exception {
                Statement statement = this.getConnection().createStatement();
                try {
                    statement.executeUpdate("drop table stmtpooltest");
                }
                catch (SQLException sQLException) {
                    BaseJDBCTestCase.assertSQLState("42Y55", sQLException);
                }
                statement.executeUpdate("create table stmtpooltest (id int generated always as identity,val int)");
                PreparedStatement preparedStatement = this.getConnection().prepareStatement("insert into stmtpooltest values (DEFAULT, ?)");
                for (int i = 1; i <= 7; ++i) {
                    preparedStatement.setInt(1, i);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
                try {
                    statement.executeUpdate("drop table stmtpooldata");
                }
                catch (SQLException sQLException) {
                    BaseJDBCTestCase.assertSQLState("42Y55", sQLException);
                }
                statement.executeUpdate("create table stmtpooldata (id int generated always as identity,val int)");
            }
        }));
        return TestConfiguration.clientServerDecorator((Test)baseTestSuite);
    }

    private static class LogicalPooledConnectionFactory {
        private int curCacheSize;
        private PooledConnection pooledConnection;

        private LogicalPooledConnectionFactory() {
        }

        public Connection getConnection(int n) throws SQLException {
            if (this.pooledConnection == null || this.curCacheSize != n) {
                this.close();
                ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
                J2EEDataSource.setBeanProperty(connectionPoolDataSource, "maxStatements", n);
                J2EEDataSource.setBeanProperty(connectionPoolDataSource, "createDatabase", "create");
                this.pooledConnection = connectionPoolDataSource.getPooledConnection();
                this.curCacheSize = n;
            }
            return this.pooledConnection.getConnection();
        }

        public void close() throws SQLException {
            if (this.pooledConnection != null) {
                try {
                    this.pooledConnection.close();
                }
                finally {
                    this.pooledConnection = null;
                    this.curCacheSize = -1;
                }
            }
        }
    }
}

