/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ForUpdateTest
extends BaseJDBCTestCase {
    public ForUpdateTest(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ForUpdateTest");
        baseTestSuite.addTest(ForUpdateTest.baseSuite("ForUpdateTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ForUpdateTest.baseSuite("ForUpdateTest:client")));
        return baseTestSuite;
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(ForUpdateTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table t1 ( i int, v varchar(10), d double precision, t time )");
                statement.execute("create table t2 ( s smallint, c char(10), r real, ts timestamp )");
                statement.execute("create table t3 (i int not null constraint t3pk primary key, b char(10))");
                statement.execute("create table t4 (c1 int)");
                statement.execute("create index t3bi on t3(b)");
                statement.execute("insert into t3 values (1, 'hhhh'), (2, 'uuuu'), (3, 'yyyy'), (4, 'aaaa'), (5, 'jjjj'), (6, 'rrrr')");
                statement.execute("insert into t3 values (7, 'iiii'), (8, 'wwww'), (9, 'rrrr'), (10, 'cccc'), (11, 'hhhh'), (12, 'rrrr')");
                statement.execute("insert into t4 (c1) values (1),(2),(3)");
            }
        };
    }

    public void testNegative() throws SQLException {
        this.assertCompileError("42X01", "select i, v from t1 for");
        this.assertCompileError("42X01", "select i, v from t1 for read");
        this.assertCompileError("42X01", "select i, v from t1 for only");
        this.assertCompileError("42X01", "select i, v from t1 for update of");
        this.assertCompileError("42X01", "select i, v from t1 update");
        this.assertCompileError("42X01", "select i, v from t1 only");
        this.assertCompileError("42X01", "select i, v from t1 read");
        Statement statement = this.createStatement();
        JDBC.assertEmpty(statement.executeQuery("select i, v from t1 for update"));
        statement.close();
    }

    public void testCursor() throws SQLException {
        Statement statement = this.createStatement();
        statement.setCursorName("C");
        statement.executeQuery("select i, v from t1, t2");
        Statement statement2 = this.createStatement();
        try {
            statement2.executeUpdate("delete from t1 where current of C");
            ForUpdateTest.fail((String)"ForUpdateTest: should have thrown exception");
        }
        catch (SQLException sQLException) {
            if (ForUpdateTest.usingEmbedded()) {
                ForUpdateTest.assertSQLState("42X23", sQLException);
            }
            ForUpdateTest.assertSQLState("42X30", sQLException);
        }
        try {
            statement2.executeQuery("select i, v from t1, t2");
        }
        catch (SQLException sQLException) {
            ForUpdateTest.assertSQLState("X0X60", sQLException);
        }
        statement2.close();
        statement.close();
    }

    public void testCursor1() throws SQLException {
        Statement statement = this.createStatement();
        statement.setCursorName("C1");
        ResultSet resultSet = statement.executeQuery("select i, v from t1 where i is not null");
        Statement statement2 = this.createStatement();
        try {
            statement2.executeUpdate("delete from t1 where current of C1");
            ForUpdateTest.fail((String)"ForUpdateTest: should have thrown exception");
        }
        catch (SQLException sQLException) {
            if (ForUpdateTest.usingEmbedded()) {
                ForUpdateTest.assertSQLState("42X23", sQLException);
            }
            ForUpdateTest.assertSQLState("42X30", sQLException);
        }
        statement2.close();
        resultSet.close();
    }

    public void testCursor2() throws SQLException {
        Statement statement = this.createStatement();
        statement.setCursorName("C2");
        ResultSet resultSet = statement.executeQuery("select i, v from t1, t2 for read only");
        Statement statement2 = this.createStatement();
        try {
            statement2.executeUpdate("delete from t1 where current of C2");
            ForUpdateTest.fail((String)"ForUpdateTest: should have thrown exception");
        }
        catch (SQLException sQLException) {
            if (ForUpdateTest.usingEmbedded()) {
                ForUpdateTest.assertSQLState("42X23", sQLException);
            }
            ForUpdateTest.assertSQLState("42X30", sQLException);
        }
        statement2.close();
        resultSet.close();
        statement.close();
    }

    public void testCursor3() throws SQLException {
        Statement statement = this.createStatement();
        statement.setCursorName("C3");
        ResultSet resultSet = statement.executeQuery("select i, v from t1 where i is not null for read only");
        Statement statement2 = this.createStatement();
        try {
            statement2.executeUpdate("delete from t1 where current of C3");
            ForUpdateTest.fail((String)"ForUpdateTest: should have thrown exception");
        }
        catch (SQLException sQLException) {
            if (ForUpdateTest.usingEmbedded()) {
                ForUpdateTest.assertSQLState("42X23", sQLException);
            }
            ForUpdateTest.assertSQLState("42X30", sQLException);
        }
        statement2.close();
        resultSet.close();
        statement.close();
    }

    public void testUpdates() throws SQLException {
        Statement statement = this.createStatement();
        JDBC.assertEmpty(statement.executeQuery("select i, v from t1 for update of t"));
        JDBC.assertEmpty(statement.executeQuery("select i, v from t1 for update of i"));
        ForUpdateTest.assertStatementError("42X04", statement, "select i, v from t1 for update of g");
        ForUpdateTest.assertStatementError("42X04", statement, "select i+10 as iPlus10, v from t1 for update of iPlus10");
        ForUpdateTest.assertStatementError("42Y90", statement, "select i from t1, t2 for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "select i from t1 where i=(select i from t1) for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "select i from t1 where i in (select i from t1) for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "select i from t1 where exists (select i from t1) for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "select i from t1 where exists (select s from t2) for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "select i from t1 where exists (select s from t2 where i=s) for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "select (select s from t2) from t1 where exists (select i from t1) for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "select (select s from t2 where i=s) from t1 where exists (select i from t1) for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "select * from (select i, d from t1) a for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "select * from (select i+10, d from t1) a for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "select * from (values (1, 2, 3)) a for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "values (1, 2, 3) for update");
        ForUpdateTest.assertStatementError("42Y90", statement, "select * from t1 union all select * from t1 for update");
        statement.close();
    }

    public void testUpdates2() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into t1 (i) values (1)");
        statement.setCursorName("C4");
        ResultSet resultSet = statement.executeQuery("select i from t1 s1 for update");
        resultSet.next();
        ForUpdateTest.assertEquals((String)resultSet.getString("I"), (String)"1");
        Statement statement2 = this.createStatement();
        try {
            statement2.executeUpdate("delete from s1 where current of C4");
            ForUpdateTest.fail((String)"ForUpdateTest: should have thrown exception");
        }
        catch (SQLException sQLException) {
            ForUpdateTest.assertSQLState("42X28", sQLException);
        }
        Statement statement3 = this.createStatement();
        statement3.executeUpdate("delete from t1 where current of C4");
        resultSet.close();
        JDBC.assertEmpty(statement.executeQuery("select i from t1 for update of i, v, d, t"));
        JDBC.assertEmpty(statement.executeQuery("select i from t1 for update of v, i, t, d"));
        JDBC.assertEmpty(statement.executeQuery("select i from t1 for update of i, d"));
        JDBC.assertEmpty(statement.executeQuery("select i from t1 for update of t, v"));
        JDBC.assertEmpty(statement.executeQuery("select i from t1 for update of d"));
        ForUpdateTest.assertStatementError("42X04", statement, "select i as z from t1 for update of z");
        statement.close();
    }

    public void testCursor5() throws SQLException {
        Statement statement = this.createStatement();
        statement.setCursorName("C5");
        statement.executeQuery("select i as v from t1 for update of v");
        try {
            statement.executeUpdate("update t1 set v='hello' where current of C5");
            ForUpdateTest.fail((String)"ForUpdateTest: should have thrown exception");
        }
        catch (SQLException sQLException) {
            ForUpdateTest.assertSQLState("42X30", sQLException);
        }
        JDBC.assertEmpty(statement.executeQuery("select i from t1 for update of i, v, v, t"));
        ForUpdateTest.assertStatementError("42X01", statement, "select i from t1 for update of t1.v, t1.i, t1.d");
        JDBC.assertEmpty(statement.executeQuery("select a.i+10, d, d from t1 a for update"));
        statement.close();
    }

    public void testStatistics() throws SQLException {
        Statement statement = this.createStatement();
        String[][] stringArray = new String[][]{{"1", "hhhh"}, {"2", "uuuu"}, {"3", "yyyy"}, {"4", "aaaa"}, {"5", "jjjj"}, {"6", "rrrr"}, {"7", "iiii"}, {"8", "wwww"}, {"9", "rrrr"}, {"10", "cccc"}, {"11", "hhhh"}, {"12", "rrrr"}};
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        JDBC.assertFullResultSet(statement.executeQuery("select i, b from t3 FOR UPDATE"), stringArray);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        ForUpdateTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
        ForUpdateTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("select i, b from t3  where i = ? FOR UPDATE");
        preparedStatement.setString(1, "7");
        preparedStatement.executeQuery();
        String[][] stringArray2 = new String[][]{{"7", "iiii"}};
        JDBC.assertFullResultSet(preparedStatement.getResultSet(), stringArray2);
        RuntimeStatisticsParser runtimeStatisticsParser2 = SQLUtilities.getRuntimeStatisticsParser(statement);
        ForUpdateTest.assertFalse((boolean)runtimeStatisticsParser2.usedTableScan());
        ForUpdateTest.assertFalse((boolean)runtimeStatisticsParser2.usedDistinctScan());
        preparedStatement.close();
        this.commit();
        preparedStatement = this.prepareStatement("select i, b from t3 where i < ? FOR UPDATE");
        preparedStatement.setString(1, "7");
        preparedStatement.executeQuery();
        String[][] stringArray3 = new String[][]{{"1", "hhhh"}, {"2", "uuuu"}, {"3", "yyyy"}, {"4", "aaaa"}, {"5", "jjjj"}, {"6", "rrrr"}};
        JDBC.assertFullResultSet(preparedStatement.getResultSet(), stringArray3);
        RuntimeStatisticsParser runtimeStatisticsParser3 = SQLUtilities.getRuntimeStatisticsParser(statement);
        ForUpdateTest.assertFalse((boolean)runtimeStatisticsParser3.usedTableScan());
        ForUpdateTest.assertFalse((boolean)runtimeStatisticsParser3.usedDistinctScan());
        preparedStatement.close();
        this.commit();
        preparedStatement = this.prepareStatement("select i, b from t3  where b = ? FOR UPDATE");
        preparedStatement.setString(1, "cccc");
        preparedStatement.executeQuery();
        String[][] stringArray4 = new String[][]{{"10", "cccc"}};
        JDBC.assertFullResultSet(preparedStatement.getResultSet(), stringArray4);
        RuntimeStatisticsParser runtimeStatisticsParser4 = SQLUtilities.getRuntimeStatisticsParser(statement);
        ForUpdateTest.assertFalse((boolean)runtimeStatisticsParser4.usedTableScan());
        ForUpdateTest.assertFalse((boolean)runtimeStatisticsParser4.usedDistinctScan());
        preparedStatement.close();
        this.commit();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        statement.close();
    }

    public void testCursors() throws SQLException {
        String string = null;
        Statement statement = this.createStatement();
        statement.setCursorName("T3C1");
        ResultSet resultSet = statement.executeQuery("select i,b from t3 where i = 4 for update");
        resultSet.next();
        ForUpdateTest.assertEquals((String)(resultSet.getInt("I") + " " + resultSet.getString("B")), (String)"4 aaaa      ");
        try {
            resultSet.next();
            string = resultSet.getInt("I") + " " + resultSet.getString("B");
        }
        catch (SQLException sQLException) {
            if (ForUpdateTest.usingEmbedded()) {
                ForUpdateTest.assertSQLState("24000", sQLException);
            }
            ForUpdateTest.assertSQLState("XJ121", sQLException);
        }
        resultSet.close();
        statement.close();
        statement = this.createStatement();
        statement.setCursorName("T3C2");
        resultSet = statement.executeQuery("select i,b from t3 where i = 4 for update");
        resultSet.next();
        ForUpdateTest.assertEquals((String)(resultSet.getInt("I") + " " + resultSet.getString("B")), (String)"4 aaaa      ");
        Statement statement2 = this.createStatement();
        statement2.executeUpdate("update t3 set i = 13 where current of T3C2");
        try {
            resultSet.next();
            string = resultSet.getInt("I") + " " + resultSet.getString("B");
        }
        catch (SQLException sQLException) {
            if (ForUpdateTest.usingEmbedded()) {
                ForUpdateTest.assertSQLState("24000", sQLException);
            }
            ForUpdateTest.assertSQLState("XJ121", sQLException);
        }
        resultSet.close();
        statement.close();
        statement2.close();
        statement = this.createStatement();
        statement.setCursorName("T3C3");
        resultSet = statement.executeQuery("select i,b from t3 where i = 6 for update");
        resultSet.next();
        ForUpdateTest.assertEquals((String)(resultSet.getInt("I") + " " + resultSet.getString("B")), (String)"6 rrrr      ");
        statement2 = this.createStatement();
        statement2.executeUpdate("update t3 set i = 14 where current of T3C3");
        statement2.execute("insert into t3 values (6, 'new!')");
        try {
            resultSet.next();
            string = resultSet.getInt("I") + " " + resultSet.getString("B");
        }
        catch (SQLException sQLException) {
            if (ForUpdateTest.usingEmbedded()) {
                ForUpdateTest.assertSQLState("24000", sQLException);
            }
            ForUpdateTest.assertSQLState("XJ121", sQLException);
        }
        resultSet.close();
        statement.close();
        statement2.close();
        statement = this.createStatement();
        statement.execute("insert into t4 (c1) values (1),(2),(3)");
        statement.setCursorName("T3C4");
        resultSet = statement.executeQuery("select * from t4 for update of c1");
        resultSet.next();
        ForUpdateTest.assertEquals((int)resultSet.getInt("C1"), (int)1);
        statement2 = this.createStatement();
        try {
            statement2.executeUpdate("update t4 set c1=c1 where current of T3C4");
        }
        catch (SQLException sQLException) {
            ForUpdateTest.assertSQLState("42X30", sQLException);
        }
        resultSet.close();
        statement.close();
        statement2.close();
    }
}

