/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MiscErrorsTest
extends BaseJDBCTestCase {
    public MiscErrorsTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(MiscErrorsTest.class);
    }

    public void testLexicalError() {
        String string = "select @#^%*&! from swearwords";
        this.assertCompileError("42X02", string);
    }

    public void testDuplicateTableCreation() throws SQLException {
        String string = "create table a (one int)";
        Statement statement = this.createStatement();
        statement.executeUpdate(string);
        string = "create table a (one int, two int)";
        MiscErrorsTest.assertStatementError("X0Y32", statement, string);
        string = "create table a (one int)";
        MiscErrorsTest.assertStatementError("X0Y32", statement, string);
        this.dropTable("a");
        string = "create table a (one int, two int, three int)";
        statement.executeUpdate(string);
        string = "insert into a values (1,2,3)";
        MiscErrorsTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "select * from a";
        JDBC.assertUnorderedResultSet(statement.executeQuery(string), new String[][]{{"1", "2", "3"}});
        this.dropTable("a");
    }

    public void testStatementCache() throws SQLException {
        String string = "values 1";
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "1");
        string = "select SQL_TEXT from syscs_diag.statement_cache where CAST(SQL_TEXT AS LONG VARCHAR) LIKE '%values 1%'";
        JDBC.assertUnorderedResultSet(statement.executeQuery(string), new String[][]{{string}, {"values 1"}});
        string = "select SQL_TEXT from syscs_diag.statement_cache where CAST(SQL_TEXT AS LONG VARCHAR) LIKE '%932432%'";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), string);
        string = "VALUES FRED932432";
        this.assertCompileError("42X04", string);
        string = "SELECT * FROM BILL932432";
        this.assertCompileError("42X05", string);
        string = "SELECT 932432";
        this.assertCompileError("42X01", string);
        string = "select SQL_TEXT from syscs_diag.statement_cache where CAST(SQL_TEXT AS LONG VARCHAR) LIKE '%932432%'";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), string);
    }
}

