/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class OuterJoinTest
extends BaseJDBCTestCase {
    public OuterJoinTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("OuterJoinTest Test");
        return TestConfiguration.defaultSuite(OuterJoinTest.class);
    }

    private void createTestObjects(Statement statement) throws Exception {
        this.setAutoCommit(false);
        CleanDatabaseTestSetup.cleanDatabase(this.getConnection(), false);
        statement.executeUpdate("create table t1(c1 int)");
        statement.executeUpdate("create table t2(c1 int)");
        statement.executeUpdate("create table t3(c1 int)");
        statement.executeUpdate("create table tt1(c1 int, c2 int, c3 int)");
        statement.executeUpdate("create table tt2(c1 int, c2 int, c3 int)");
        statement.executeUpdate("create table tt3(c1 int, c2 int, c3 int)");
        statement.executeUpdate("create table empty_table(c1 int)");
        statement.executeUpdate("create table insert_test(c1 int, c2 int, c3 int)");
        statement.executeUpdate("create table x (c1 int, c2 int, c3 int)");
        statement.executeUpdate("create table y (c3 int, c4 int, c5 int)");
        statement.executeUpdate("create table a (c1 int)");
        statement.executeUpdate("create table b (c2 float)");
        statement.executeUpdate("create table c (c3 char(30))");
        statement.executeUpdate("create table oj(oj int)");
        statement.executeUpdate("insert into t1 values 1, 2, 2, 3, 4");
        statement.executeUpdate("insert into t2 values 1, 3, 3, 5, 6");
        statement.executeUpdate("insert into t3 values 2, 3, 5, 5, 7");
        statement.executeUpdate("insert into tt1 select c1, c1, c1 from t1");
        statement.executeUpdate("insert into tt2 select c1, c1, c1 from t2");
        statement.executeUpdate("insert into tt3 select c1, c1, c1 from t3");
        statement.executeUpdate("insert into x values (1, 2, 3), (4, 5, 6)");
        statement.executeUpdate("insert into y values (3, 4, 5), (666, 7, 8)");
        statement.executeUpdate("insert into insert_test(select * from t1 a left outer join t2 b on a.c1 = b.c1 left outer join t3 c on a.c1 <> c.c1)");
        statement.executeUpdate("insert into a values 1");
        statement.executeUpdate("insert into b values 3.3");
        statement.executeUpdate("insert into c values 'asdf'");
        statement.executeUpdate("insert into oj(oj) values (1)");
    }

    public void testNegative() throws Exception {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        OuterJoinTest.assertStatementError("42X01", statement, "select * from t1 outer join t2");
        OuterJoinTest.assertStatementError("42X01", statement, "select * from t1 left outer join t2");
        OuterJoinTest.assertStatementError("42X01", statement, " select * from t1 right outer join t2");
    }

    public void testPositive() throws Exception {
        int n;
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        resultSet = statement.executeQuery("select t1.c1 from t1 left outer join t2 on t1.c1 = t2.c1");
        String[] stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1"}, {"2"}, {"2"}, {"3"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select t2.c1 from t1 right outer join t2 on t1.c1 = t2.c1");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"3"}, {"3"}, {"5"}, {"6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select a.x from t1 a (x) left outer join t2 b (x) on a.x = b.x");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"2"}, {"3"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select b.* from (values 9) a left outer join t2 b on 1=1");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"3"}, {"3"}, {"5"}, {"6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select b.* from (values 9) a left outer join t2 b on 1=0");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select b.* from (values 9) a right outer join t2 b on 1=0");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"3"}, {"3"}, {"5"}, {"6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select a.* from (values 9) a right outer join t2 b on 1=1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"9"}, {"9"}, {"9"}, {"9"}, {"9"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select a.* from (values 9) a right outer join t2 b on 1=0");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null}, {null}, {null}, {null}, {null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select a.* from ((values ('a', 'b')) a inner join (values ('c', 'd')) b on 1=1) left outer join (values ('e', 'f')) c on 1=1");
        stringArray = new String[]{"1", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"a", "b"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select b.* from ((values ('a', 'b')) a inner join (values ('c', 'd')) b on 1=1) left outer join (values ('e', 'f')) c on 1=1");
        stringArray = new String[]{"1", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"c", "d"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select c.* from ((values ('a', 'b')) a inner join (values ('c', 'd')) b on 1=1) left outer join (values ('e', 'f')) c on 1=1");
        stringArray = new String[]{"1", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"e", "f"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from oj where oj = 1");
        stringArray = new String[]{"OJ"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from t1 left outer join {oj t2 left outer join t3 on t2.c1=t3.c1} on t1.c1=t3.c1");
        stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", null, null}, {"2", null, null}, {"2", null, null}, {"3", "3", "3"}, {"3", "3", "3"}, {"4", null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select t1.c1 from t1 left outer join empty_table et on t1.c1 = et.c1");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select t1.c1 from t1 right outer join empty_table et on t1.c1 = et.c1");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery(" select t1.c1 from empty_table et right outer join t1 on et.c1 = t1.c1");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from t1, {oj t2 join t3 on t2.c1=t3.c1}");
        stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "3", "3"}, {"1", "3", "3"}, {"1", "5", "5"}, {"1", "5", "5"}, {"2", "3", "3"}, {"2", "3", "3"}, {"2", "5", "5"}, {"2", "5", "5"}, {"2", "3", "3"}, {"2", "3", "3"}, {"2", "5", "5"}, {"2", "5", "5"}, {"3", "3", "3"}, {"3", "3", "3"}, {"3", "5", "5"}, {"3", "5", "5"}, {"4", "3", "3"}, {"4", "3", "3"}, {"4", "5", "5"}, {"4", "5", "5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 left outer join t2 on 1=? and t1.c1 = t2.c1");
        resultSet = statement.executeQuery("values 1");
        resultSet.next();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
            preparedStatement.setObject(n, resultSet.getObject(n));
        }
        resultSet = preparedStatement.executeQuery();
        stringArray = new String[]{"C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", null}, {"2", null}, {"3", "3"}, {"3", "3"}, {"4", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        preparedStatement = this.prepareStatement("select * from t1 left outer join t2 on t1.c1 = t2.c1 and t1.c1 = ?");
        resultSet = statement.executeQuery("values 1");
        resultSet.next();
        resultSetMetaData = resultSet.getMetaData();
        for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
            preparedStatement.setObject(n, resultSet.getObject(n));
        }
        resultSet = preparedStatement.executeQuery();
        stringArray = new String[]{"C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", null}, {"2", null}, {"3", null}, {"4", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from t1 left outer join t2 on t1.c1 = t2.c1 where t1.c1 = 1");
        stringArray = new String[]{"C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from {oj t1 left outer join t2 on t1.c1 = t2.c1} where t1.c1 = 1");
        stringArray = new String[]{"C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from t1 right outer join t2 on t1.c1 = 1 where t2.c1 = t1.c1");
        stringArray = new String[]{"C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from {oj t1 right outer join t2 on t1.c1 = 1} where t2.c1 = t1.c1");
        stringArray = new String[]{"C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testOuterJoinWithSubquery() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        resultSet = statement.executeQuery("select * from t1 a left outer join t2 b on a.c1 = b.c1 and a.c1 = (select c1 from t1 where a.c1 = t1.c1 and a.c1 = 1)");
        String[] stringArray = new String[]{"C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", null}, {"2", null}, {"3", null}, {"4", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from {oj t1 a left outer join t2 b on a.c1 = b.c1 and a.c1 = (select c1 from t1 where a.c1 = t1.c1 and a.c1 = 1)}");
        stringArray = new String[]{"C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", null}, {"2", null}, {"3", null}, {"4", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from t1 a left outer join t2 b on a.c1 = b.c1 and a.c1 = (select c1 from t1 where a.c1 = t1.c1 and a.c1 <> 2)");
        stringArray = new String[]{"C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", null}, {"2", null}, {"3", "3"}, {"3", "3"}, {"4", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from {oj t1 a left outer join t2 b on a.c1 = b.c1 and a.c1 = (select c1 from t1 where a.c1 = t1.c1 and a.c1 <> 2)}");
        stringArray = new String[]{"C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", null}, {"2", null}, {"3", "3"}, {"3", "3"}, {"4", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from t1 a right outer join t2 b on a.c1 = b.c1 and a.c1 in (select c1 from t1 where a.c1 = t1.c1)");
        stringArray = new String[]{"C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"3", "3"}, {"3", "3"}, {null, "5"}, {null, "6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testOuterJoinWithinSubquery() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        resultSet = statement.executeQuery("select * from (t1 a)where exists (select * from t1 left outer join t2 on t1.c1 = t2.c1)");
        String[] stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1"}, {"2"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from (t1 a)where exists (select * from {oj t1 left outer join t2 on t1.c1 = t2.c1})");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from (t1 a)where exists (select * from t1 left outer join t2 on 1=0)");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testNestedJoins() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        resultSet = statement.executeQuery("select * from t1 left outer join t2 on t1.c1 = t2.c1 left outer join t3 on t1.c1 = t3.c1");
        String[] stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1", null}, {"2", null, "2"}, {"2", null, "2"}, {"3", "3", "3"}, {"3", "3", "3"}, {"4", null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from {oj t1 left outer join t2 on t1.c1 = t2.c1 left outer join t3 on t1.c1 = t3.c1}");
        stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", null}, {"2", null, "2"}, {"2", null, "2"}, {"3", "3", "3"}, {"3", "3", "3"}, {"4", null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from t1 left outer join t2 on t1.c1 = t2.c1 left outer join t3 on t2.c1 = t3.c1");
        stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", null}, {"2", null, null}, {"2", null, null}, {"3", "3", "3"}, {"3", "3", "3"}, {"4", null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from t3 right outer join t2 on t3.c1 = t2.c1 right outer join t1 on t1.c1 = t2.c1");
        stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, "1", "1"}, {null, null, "2"}, {null, null, "2"}, {"3", "3", "3"}, {"3", "3", "3"}, {null, null, "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from (t1 left outer join t2 on t1.c1 = t2.c1) left outer join t3 on t1.c1 = t3.c1");
        stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", null}, {"2", null, "2"}, {"2", null, "2"}, {"3", "3", "3"}, {"3", "3", "3"}, {"4", null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from t1 left outer join (t2 left outer join t3 on t2.c1 = t3.c1) on t1.c1 = t2.c1");
        stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", null}, {"2", null, null}, {"2", null, null}, {"3", "3", "3"}, {"3", "3", "3"}, {"4", null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testLeftRightOuterJoinCombination() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        resultSet = statement.executeQuery("select * from t1 a right outer join t2 b on a.c1 = b.c1 left outer join t3 c on a.c1 = b.c1 and b.c1 = c.c1");
        String[] stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1", null}, {"3", "3", "3"}, {"3", "3", "3"}, {null, "5", null}, {null, "6", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from (t1 a right outer join t2 b on a.c1 = b.c1) left outer join t3 c on a.c1 = b.c1 and b.c1 = c.c1");
        stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", null}, {"3", "3", "3"}, {"3", "3", "3"}, {null, "5", null}, {null, "6", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from t1 a left outer join t2 b on a.c1 = b.c1 right outer join t3 c on c.c1 = a.c1 where a.c1 is not null");
        stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2", null, "2"}, {"2", null, "2"}, {"3", "3", "3"}, {"3", "3", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from (t1 a left outer join t2 b on a.c1 = b.c1) right outer join t3 c on c.c1 = a.c1 where a.c1 is not null");
        stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2", null, "2"}, {"2", null, "2"}, {"3", "3", "3"}, {"3", "3", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from t1 a left outer join (t2 b right outer join t3 c on c.c1 = b.c1) on a.c1 = c.c1 where c.c1=b.c1");
        stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3", "3", "3"}, {"3", "3", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testOuterJoinWithInsertUpdateDelete() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        resultSet = statement.executeQuery("select * from insert_test");
        String[] stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1", "2"}, {"1", "1", "3"}, {"1", "1", "5"}, {"1", "1", "5"}, {"1", "1", "7"}, {"2", null, "3"}, {"2", null, "5"}, {"2", null, "5"}, {"2", null, "7"}, {"2", null, "3"}, {"2", null, "5"}, {"2", null, "5"}, {"2", null, "7"}, {"3", "3", "2"}, {"3", "3", "5"}, {"3", "3", "5"}, {"3", "3", "7"}, {"3", "3", "2"}, {"3", "3", "5"}, {"3", "3", "5"}, {"3", "3", "7"}, {"4", null, "2"}, {"4", null, "3"}, {"4", null, "5"}, {"4", null, "5"}, {"4", null, "7"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        OuterJoinTest.assertUpdateCount(statement, 5, " update insert_test set c1 = (select 9 from t1 a left outer join t1 b on a.c1 = b.c1 where a.c1 = 1) where c1 = 1");
        resultSet = statement.executeQuery("select * from insert_test");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"9", "1", "2"}, {"9", "1", "3"}, {"9", "1", "5"}, {"9", "1", "5"}, {"9", "1", "7"}, {"2", null, "3"}, {"2", null, "5"}, {"2", null, "5"}, {"2", null, "7"}, {"2", null, "3"}, {"2", null, "5"}, {"2", null, "5"}, {"2", null, "7"}, {"3", "3", "2"}, {"3", "3", "5"}, {"3", "3", "5"}, {"3", "3", "7"}, {"3", "3", "2"}, {"3", "3", "5"}, {"3", "3", "5"}, {"3", "3", "7"}, {"4", null, "2"}, {"4", null, "3"}, {"4", null, "5"}, {"4", null, "5"}, {"4", null, "7"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        OuterJoinTest.assertUpdateCount(statement, 5, " delete from insert_test where c1 = (select 9 from t1 a left outer join t1 b on a.c1 = b.c1 where a.c1 = 1)");
        resultSet = statement.executeQuery("select * from insert_test");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2", null, "3"}, {"2", null, "5"}, {"2", null, "5"}, {"2", null, "7"}, {"2", null, "3"}, {"2", null, "5"}, {"2", null, "5"}, {"2", null, "7"}, {"3", "3", "2"}, {"3", "3", "5"}, {"3", "3", "5"}, {"3", "3", "7"}, {"3", "3", "2"}, {"3", "3", "5"}, {"3", "3", "5"}, {"3", "3", "7"}, {"4", null, "2"}, {"4", null, "3"}, {"4", null, "5"}, {"4", null, "5"}, {"4", null, "7"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        OuterJoinTest.assertUpdateCount(statement, 21, "delete from insert_test");
        statement.executeUpdate(" insert into insert_test (select * from (select * from t1 a left outer join t2 b on a.c1 = b.c1 left outer join t3 c on a.c1 <> c.c1) d (c1, c2, c3))");
        resultSet = statement.executeQuery("select * from insert_test");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "2"}, {"1", "1", "3"}, {"1", "1", "5"}, {"1", "1", "5"}, {"1", "1", "7"}, {"2", null, "3"}, {"2", null, "5"}, {"2", null, "5"}, {"2", null, "7"}, {"2", null, "3"}, {"2", null, "5"}, {"2", null, "5"}, {"2", null, "7"}, {"3", "3", "2"}, {"3", "3", "5"}, {"3", "3", "5"}, {"3", "3", "7"}, {"3", "3", "2"}, {"3", "3", "5"}, {"3", "3", "5"}, {"3", "3", "7"}, {"4", null, "2"}, {"4", null, "3"}, {"4", null, "5"}, {"4", null, "5"}, {"4", null, "7"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        OuterJoinTest.assertUpdateCount(statement, 26, "delete from insert_test");
    }

    public void testMulticolumn() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        resultSet = statement.executeQuery("select tt1.c1, tt1.c2, tt1.c3, tt2.c2, tt2.c3 from tt1 left outer join tt2 on tt1.c1 = tt2.c1");
        String[] stringArray = new String[]{"C1", "C2", "C3", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1", "1", "1", "1"}, {"2", "2", "2", null, null}, {"2", "2", "2", null, null}, {"3", "3", "3", "3", "3"}, {"3", "3", "3", "3", "3"}, {"4", "4", "4", null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select tt1.c1, tt1.c2, tt1.c3, tt2.c3 from tt1 left outer join tt2 on tt1.c1 = tt2.c1");
        stringArray = new String[]{"C1", "C2", "C3", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1", "1"}, {"2", "2", "2", null}, {"2", "2", "2", null}, {"3", "3", "3", "3"}, {"3", "3", "3", "3"}, {"4", "4", "4", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select tt1.c1, tt1.c2, tt1.c3 from tt1 left outer join tt2 on tt1.c1 = tt2.c1");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1"}, {"2", "2", "2"}, {"2", "2", "2"}, {"3", "3", "3"}, {"3", "3", "3"}, {"4", "4", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select tt1.c2, tt1.c1, tt1.c3, tt2.c1, tt2.c3 from t1 left outer join tt1 on t1.c1 = tt1.c1 left outer join tt2 on tt1.c2 = tt2.c2");
        stringArray = new String[]{"C2", "C1", "C3", "C1", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1", "1", "1"}, {"2", "2", "2", null, null}, {"2", "2", "2", null, null}, {"2", "2", "2", null, null}, {"2", "2", "2", null, null}, {"3", "3", "3", "3", "3"}, {"3", "3", "3", "3", "3"}, {"4", "4", "4", null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testColumnReordering() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        resultSet = statement.executeQuery("select x.* from x join y on x.c3 = y.c3");
        String[] stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "2", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select x.* from x left outer join y on x.c3 = y.c3");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2", "3"}, {"4", "5", "6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select x.* from x right outer join y on x.c3 = y.c3");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2", "3"}, {null, null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select y.* from x join y on x.c3 = y.c3");
        stringArray = new String[]{"C3", "C4", "C5"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3", "4", "5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select y.* from x left outer join y on x.c3 = y.c3");
        stringArray = new String[]{"C3", "C4", "C5"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3", "4", "5"}, {null, null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select y.* from x right outer join y on x.c3 = y.c3");
        stringArray = new String[]{"C3", "C4", "C5"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3", "4", "5"}, {"666", "7", "8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from x join y on x.c3 = y.c3");
        stringArray = new String[]{"C1", "C2", "C3", "C3", "C4", "C5"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2", "3", "3", "4", "5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from x left outer join y on x.c3 = y.c3");
        stringArray = new String[]{"C1", "C2", "C3", "C3", "C4", "C5"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2", "3", "3", "4", "5"}, {"4", "5", "6", null, null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from x right outer join y on x.c3 = y.c3");
        stringArray = new String[]{"C1", "C2", "C3", "C3", "C4", "C5"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2", "3", "3", "4", "5"}, {null, null, null, "666", "7", "8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testRightOuterJoinXform() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        resultSet = statement.executeQuery(" select * from a left outer join b on 1=1 left outer join c on 1=1");
        String[] stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "3.3", "asdf"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from a left outer join b on 1=1 left outer join c on 1=0");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "3.3", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from a left outer join b on 1=0 left outer join c on 1=1");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", null, "asdf"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from a left outer join b on 1=0 left outer join c on 1=0");
        stringArray = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from c right outer join b on 1=1 right outer join a on 1=1");
        stringArray = new String[]{"C3", "C2", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"asdf", "3.3", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from c right outer join b on 1=1 right outer join a on 1=0");
        stringArray = new String[]{"C3", "C2", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, null, "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from c right outer join b on 1=0 right outer join a on 1=1");
        stringArray = new String[]{"C3", "C2", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, "3.3", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from c right outer join b on 1=0 right outer join a on 1=0");
        stringArray = new String[]{"C3", "C2", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, null, "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testInnerJoinXform() throws Exception {
        RuntimeStatisticsParser runtimeStatisticsParser;
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        OuterJoinTest.assertUpdateCount(statement, 5, "delete from tt1");
        OuterJoinTest.assertUpdateCount(statement, 5, " delete from tt2");
        OuterJoinTest.assertUpdateCount(statement, 5, " delete from tt3");
        statement.executeUpdate(" insert into tt1 values (1, 2, 3), (2, 3, 4), (3, 4, 5)");
        statement.executeUpdate(" insert into tt2 values (1, 2, 3), (2, 3, 4), (3, 4, 5)");
        statement.executeUpdate(" insert into tt3 values (1, 2, 3), (2, 3, 4), (3, 4, 5)");
        CallableStatement callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        OuterJoinTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery("select * from tt1 left outer join tt2 on tt1.c1 = tt2.c2 where tt1.c1 = 3");
        String[] stringArray = new String[]{"C1", "C2", "C3", "C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"3", "4", "5", "2", "3", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from tt1 left outer join tt2 on tt1.c1 = tt2.c2 where tt2.c2 = 3");
        stringArray = new String[]{"C1", "C2", "C3", "C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3", "4", "5", "2", "3", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        if (OuterJoinTest.usingEmbedded()) {
            runtimeStatisticsParser = new RuntimeStatisticsParser(resultSet.getString(1));
            OuterJoinTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
            OuterJoinTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        }
        resultSet.close();
        resultSet = statement.executeQuery(" select * from tt1 left outer join tt2 on tt1.c1 = tt2.c2 where tt2.c1 + 1= tt2.c2");
        stringArray = new String[]{"C1", "C2", "C3", "C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2", "3", "4", "1", "2", "3"}, {"3", "4", "5", "2", "3", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        if (OuterJoinTest.usingEmbedded()) {
            runtimeStatisticsParser = new RuntimeStatisticsParser(resultSet.getString(1));
            OuterJoinTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
            OuterJoinTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        }
        resultSet.close();
        resultSet = statement.executeQuery(" select * from tt1 left outer join tt2 on tt1.c1 = tt2.c2 where tt2.c1 + 1= 3");
        stringArray = new String[]{"C1", "C2", "C3", "C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3", "4", "5", "2", "3", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        if (OuterJoinTest.usingEmbedded()) {
            runtimeStatisticsParser = new RuntimeStatisticsParser(resultSet.getString(1));
            OuterJoinTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
            OuterJoinTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        }
        resultSet.close();
        resultSet = statement.executeQuery(" select * from tt2 right outer join tt1 on tt1.c1 = tt2.c2 where tt2.c1 + 1= 3");
        stringArray = new String[]{"C1", "C2", "C3", "C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2", "3", "4", "3", "4", "5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        if (OuterJoinTest.usingEmbedded()) {
            runtimeStatisticsParser = new RuntimeStatisticsParser(resultSet.getString(1));
            OuterJoinTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
            OuterJoinTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        }
        resultSet.close();
        resultSet = statement.executeQuery(" select * from tt1 left outer join tt2 on tt1.c1 = tt2.c2 left outer join tt3 on tt2.c2 = tt3.c3 where tt3.c3 = 3");
        stringArray = new String[]{"C1", "C2", "C3", "C1", "C2", "C3", "C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3", "4", "5", "2", "3", "4", "1", "2", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        if (OuterJoinTest.usingEmbedded()) {
            runtimeStatisticsParser = new RuntimeStatisticsParser(resultSet.getString(1));
            OuterJoinTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
            OuterJoinTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        }
        resultSet.close();
        resultSet = statement.executeQuery(" select * from tt1 left outer join tt2 on tt1.c1 = tt2.c2 left outer join tt3 on tt2.c2 = tt3.c3 where tt2.c2 = 3");
        stringArray = new String[]{"C1", "C2", "C3", "C1", "C2", "C3", "C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3", "4", "5", "2", "3", "4", "1", "2", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        if (OuterJoinTest.usingEmbedded()) {
            runtimeStatisticsParser = new RuntimeStatisticsParser(resultSet.getString(1));
            OuterJoinTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
            OuterJoinTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        }
        resultSet.close();
        resultSet = statement.executeQuery("select * from tt1 left outer join tt2 on tt1.c1 = tt2.c2 where char(tt2.c2) is null");
        stringArray = new String[]{"C1", "C2", "C3", "C1", "C2", "C3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2", "3", null, null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        if (OuterJoinTest.usingEmbedded()) {
            runtimeStatisticsParser = new RuntimeStatisticsParser(resultSet.getString(1));
            OuterJoinTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
            OuterJoinTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        }
        resultSet.close();
    }

    public void testdDerby2924() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        statement.executeUpdate("CREATE TABLE inventory(itemno INT NOT NULL PRIMARY KEY, capacity INT)");
        statement.executeUpdate("INSERT INTO inventory VALUES (1, 4)");
        statement.executeUpdate("INSERT INTO inventory VALUES (2, 2)");
        statement.executeUpdate("INSERT INTO inventory VALUES (3, 2)");
        statement.executeUpdate(" CREATE TABLE timeslots (slotno INT NOT NULL PRIMARY KEY)");
        statement.executeUpdate("INSERT INTO timeslots VALUES(1)");
        statement.executeUpdate("INSERT INTO timeslots VALUES(2)");
        statement.executeUpdate(" create table reservations(slotno INT CONSTRAINT timeslots_fk REFERENCES timeslots, itemno INT CONSTRAINT inventory_fk REFERENCES inventory, name VARCHAR(100), resdate DATE)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(1, 1, 'Joe', '2000-04-14')");
        statement.executeUpdate(" INSERT INTO reservations VALUES(1, 1, 'Fred', '2000-04-13')");
        resultSet = statement.executeQuery("select name, resdate from (reservations left outer join (inventory join timeslots on inventory.itemno = timeslots.slotno)on inventory.itemno = reservations.itemno and timeslots.slotno = reservations.slotno)where resdate = '2000-04-14'");
        String[] stringArray = new String[]{"NAME", "RESDATE"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"Joe", "2000-04-14"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testdDerby2923() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        statement.executeUpdate("create table inventory(itemno INT NOT NULL PRIMARY KEY, capacity INT)");
        statement.executeUpdate("INSERT into inventory values (1, 4)");
        statement.executeUpdate("INSERT into inventory values (2, 2)");
        statement.executeUpdate("INSERT into inventory values (3, 2)");
        statement.executeUpdate(" CREATE TABLE timeslots (slotno INT NOT NULL PRIMARY KEY)");
        statement.executeUpdate("INSERT INTO timeslots VALUES(1)");
        statement.executeUpdate("INSERT INTO timeslots VALUES(2)");
        statement.executeUpdate(" create table reservations(slotno INT CONSTRAINT timeslots_fk REFERENCES timeslots,itemno INT CONSTRAINT inventory_fk REFERENCES inventory,name VARCHAR(100))");
        statement.executeUpdate("INSERT INTO reservations VALUES(1, 1, 'Joe')");
        statement.executeUpdate("INSERT INTO reservations VALUES(2, 2, 'Fred')");
        resultSet = statement.executeQuery("select timeslots.slotno, inventory.itemno, capacity, name from inventory left outer join timeslots on inventory.capacity = timeslots.slotno left outer join reservations on timeslots.slotno = reservations.slotno where capacity > 3 and name is null");
        String[] stringArray = new String[]{"SLOTNO", "ITEMNO", "CAPACITY", "NAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{null, "1", "4", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select timeslots.slotno, inventory.itemno, capacity, name from inventory left outer join timeslots on inventory.capacity = timeslots.slotno left outer join reservations on timeslots.slotno = reservations.slotno where name is null and capacity > 3");
        stringArray = new String[]{"SLOTNO", "ITEMNO", "CAPACITY", "NAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, "1", "4", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testdDerby2930() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        SQLWarning sQLWarning = null;
        this.createTestObjects(statement);
        statement.executeUpdate("CREATE TABLE properties (\tname VARCHAR(50),\tvalue VARCHAR(200))");
        statement.executeUpdate(" INSERT INTO properties VALUES ('businessName', 'Cloud 9 Cafe')");
        statement.executeUpdate(" INSERT INTO properties VALUES ('lastReservationDate', '2001-12-31')");
        statement.executeUpdate(" CREATE TABLE inventory (\titemno INT NOT NULL PRIMARY KEY,\tcapacity INT)");
        statement.executeUpdate("INSERT INTO inventory VALUES (1, 2)");
        statement.executeUpdate("INSERT INTO inventory VALUES (2, 2)");
        statement.executeUpdate("INSERT INTO inventory VALUES (3, 2)");
        statement.executeUpdate("INSERT INTO inventory VALUES (4, 2)");
        statement.executeUpdate("INSERT INTO inventory VALUES (5, 2)");
        statement.executeUpdate("INSERT INTO inventory VALUES (6, 4)");
        statement.executeUpdate("INSERT INTO inventory VALUES (7, 4)");
        statement.executeUpdate("INSERT INTO inventory VALUES (8, 4)");
        statement.executeUpdate("INSERT INTO inventory VALUES (9, 4)");
        statement.executeUpdate("INSERT INTO inventory VALUES (10, 4)");
        statement.executeUpdate(" CREATE TABLE timeslots (slot TIME NOT NULL PRIMARY KEY)");
        statement.executeUpdate("INSERT INTO timeslots VALUES('17:00:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('17:30:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('18:00:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('18:30:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('19:00:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('19:30:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('20:00:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('20:30:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('21:00:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('21:30:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('22:00:00')");
        statement.executeUpdate(" CREATE TABLE reservations (\titemno INT CONSTRAINT inventory_fk REFERENCES inventory,\tslot TIME CONSTRAINT timeslots_fk REFERENCES timeslots,\tresdate DATE NOT NULL,\tname VARCHAR(100) NOT NULL,\tquantity INT,\tCONSTRAINT reservations_u UNIQUE(name, resdate))");
        statement.executeUpdate(" INSERT INTO reservations VALUES(6, '17:00:00', '2000-07-13', 'Williams', 4)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(7, '17:00:00', '2000-07-13', 'Johnson',  4)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(8, '17:00:00', '2000-07-13', 'Allen',    3)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(9, '17:00:00', '2000-07-13', 'Dexmier',  4)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(1, '17:30:00', '2000-07-13', 'Gates', \t 2)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(2, '17:30:00', '2000-07-13', 'McNealy',  2)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(3, '17:30:00', '2000-07-13', 'Hoffman',  1)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(4, '17:30:00', '2000-07-13', 'Sippl',    2)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(6, '17:30:00', '2000-07-13', 'Yang',     4)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(7, '17:30:00', '2000-07-13', 'Meyers',   4)");
        resultSet = statement.executeQuery(" select max(name), max(resdate) from inventory join timeslots on inventory.capacity is not null left outer join reservations on inventory.itemno = reservations.itemno and reservations.slot = timeslots.slot");
        String[] stringArray = new String[]{"1", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"Yang", "2000-07-13"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select max(name), max(resdate) from inventory join timeslots on inventory.capacity is not null left outer join reservations on inventory.itemno = reservations.itemno and reservations.slot = timeslots.slot");
        resultSet.next();
        if (OuterJoinTest.usingEmbedded()) {
            sQLWarning = resultSet.getWarnings();
            OuterJoinTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
            OuterJoinTest.assertSQLState("01003", sQLWarning);
        }
        OuterJoinTest.assertEquals((String)"Yang", (String)resultSet.getString(1));
        OuterJoinTest.assertEquals((String)"2000-07-13", (String)resultSet.getString(2));
    }

    public void testdDerby2931() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        statement.executeUpdate("CREATE TABLE properties (\tname VARCHAR(50),\tvalue VARCHAR(200))");
        statement.executeUpdate(" INSERT INTO properties VALUES ('businessName', 'Cloud 9 Cafe')");
        statement.executeUpdate(" INSERT INTO properties VALUES ('lastReservationDate', '2001-12-31')");
        statement.executeUpdate(" CREATE TABLE inventory (\titemno INT NOT NULL PRIMARY KEY,\tcapacity INT)");
        statement.executeUpdate("INSERT INTO inventory VALUES (1, 2)");
        statement.executeUpdate("INSERT INTO inventory VALUES (2, 2)");
        statement.executeUpdate("INSERT INTO inventory VALUES (3, 2)");
        statement.executeUpdate("INSERT INTO inventory VALUES (4, 2)");
        statement.executeUpdate("INSERT INTO inventory VALUES (5, 2)");
        statement.executeUpdate("INSERT INTO inventory VALUES (6, 4)");
        statement.executeUpdate("INSERT INTO inventory VALUES (7, 4)");
        statement.executeUpdate("INSERT INTO inventory VALUES (8, 4)");
        statement.executeUpdate("INSERT INTO inventory VALUES (9, 4)");
        statement.executeUpdate("INSERT INTO inventory VALUES (10, 4)");
        statement.executeUpdate(" CREATE TABLE timeslots (slot TIME NOT NULL PRIMARY KEY)");
        statement.executeUpdate("INSERT INTO timeslots VALUES('17:00:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('17:30:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('18:00:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('18:30:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('19:00:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('19:30:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('20:00:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('20:30:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('21:00:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('21:30:00')");
        statement.executeUpdate("INSERT INTO timeslots VALUES('22:00:00')");
        statement.executeUpdate(" CREATE TABLE reservations (\titemno INT CONSTRAINT inventory_fk REFERENCES inventory,\tslot TIME CONSTRAINT timeslots_fk REFERENCES timeslots,\tresdate DATE NOT NULL,\tname VARCHAR(100) NOT NULL,\tquantity INT,\tCONSTRAINT reservations_u UNIQUE(name, resdate))");
        statement.executeUpdate(" INSERT INTO reservations VALUES(6, '17:00:00', '2000-07-13', 'Williams', 4)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(7, '17:00:00', '2000-07-13', 'Johnson',  4)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(8, '17:00:00', '2000-07-13', 'Allen',    3)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(9, '17:00:00', '2000-07-13', 'Dexmier',  4)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(1, '17:30:00', '2000-07-13', 'Gates', \t 2)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(2, '17:30:00', '2000-07-13', 'McNealy',  2)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(3, '17:30:00', '2000-07-13', 'Hoffman',  1)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(4, '17:30:00', '2000-07-13', 'Sippl',    2)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(6, '17:30:00', '2000-07-13', 'Yang',     4)");
        statement.executeUpdate(" INSERT INTO reservations VALUES(7, '17:30:00', '2000-07-13', 'Meyers',   4)");
        resultSet = statement.executeQuery("select max(timeslots.slot) from inventory inner join timeslots on inventory.capacity is not null left outer join reservations on inventory.capacity = reservations.itemno and reservations.slot = timeslots.slot");
        String[] stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"22:00:00"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testdDerby2897() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        resultSet = statement.executeQuery("select * from t1 inner join t2 on 1=1 left outer join t3 on t1.c1 = t3.c1 where t1.c1 = t2.c1");
        String[] stringArray = new String[]{"C1", "C1", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1", null}, {"3", "3", "3"}, {"3", "3", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        if (OuterJoinTest.usingEmbedded()) {
            RuntimeStatisticsParser runtimeStatisticsParser = new RuntimeStatisticsParser(resultSet.getString(1));
            OuterJoinTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
            OuterJoinTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        }
        resultSet.close();
    }

    public void testdDerby5659() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        statement.executeUpdate("create table xxx (a int not null)");
        statement.executeUpdate(" create table yyy (a int not null)");
        statement.executeUpdate(" insert into xxx values (1)");
        resultSet = statement.executeQuery(" select * from xxx left join yyy on (xxx.a=yyy.a)");
        String[] stringArray = new String[]{"A", "A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        OuterJoinTest.assertStatementError("23502", statement, " insert into xxx values (null)");
        resultSet = statement.executeQuery(" select * from xxx");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testdDerby5658() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        statement.executeUpdate("create table ttab1 (a int, b int)");
        statement.executeUpdate(" insert into ttab1 values (1,1),(2,2)");
        statement.executeUpdate(" create table ttab2 (c int, d int)");
        statement.executeUpdate(" insert into ttab2 values (1,1),(2,2)");
        resultSet = statement.executeQuery("select cor1.*, cor2.* from ttab1 cor1 left outer join ttab2 on (b = d),\t\tttab1 left outer join ttab2 cor2 on (b = d)");
        String[] stringArray = new String[]{"A", "B", "C", "D"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1", "1", "1"}, {"1", "1", "2", "2"}, {"2", "2", "1", "1"}, {"2", "2", "2", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select cor1.*, cor2.* from ttab1 cor1 left outer join ttab2 on (b = d),\t\tttab1 left outer join ttab2 cor2 on (b = cor2.d)");
        stringArray = new String[]{"A", "B", "C", "D"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1", "1"}, {"1", "1", "2", "2"}, {"2", "2", "1", "1"}, {"2", "2", "2", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select cor1.*, cor2.* from ttab1 left outer join ttab2 on (b = d), \t\tttab1 cor1 left outer join ttab2 cor2 on (cor1.b = cor2.d)");
        stringArray = new String[]{"A", "B", "C", "D"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1", "1"}, {"2", "2", "2", "2"}, {"1", "1", "1", "1"}, {"2", "2", "2", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        OuterJoinTest.assertStatementError("42X03", statement, "select * from ttab1, ttab1 left outer join ttab2 on (a=c)");
        OuterJoinTest.assertStatementError("42X04", statement, " select * from ttab1 cor1, ttab1 left outer join ttab2 on (cor1.a=c)");
        resultSet = statement.executeQuery("select * from ttab1, ttab1 cor1 left outer join ttab2 on (cor1.a=c)");
        stringArray = new String[]{"A", "B", "A", "B", "C", "D"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1", "1", "1", "1"}, {"2", "2", "1", "1", "1", "1"}, {"1", "1", "2", "2", "2", "2"}, {"2", "2", "2", "2", "2", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testdDerby5164() throws Exception {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        ResultSet resultSet = null;
        this.createTestObjects(statement);
        statement.executeUpdate("CREATE TABLE \"APP\".\"GOVT_AGCY\" (\"GVA_ID\" NUMERIC(20,0) NOT NULL, \"GVA_ORL_ID\" NUMERIC(20,0) NOT NULL, \"GVA_GAC_ID\" NUMERIC(20,0))");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"GEO_STRC_ELMT\" (\"GSE_ID\" NUMERIC(20,0) NOT NULL, \"GSE_GSET_ID\" NUMERIC(20,0) NOT NULL, \"GSE_GA_ID_PRNT\" NUMERIC(20,0) NOT NULL, \"GSE_GA_ID_CHLD\" NUMERIC(20,0) NOT NULL)");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"GEO_AREA\" (\"GA_ID\" NUMERIC(20,0) NOT NULL, \"GA_GAT_ID\" NUMERIC(20,0) NOT NULL, \"GA_NM\" VARCHAR(30) NOT NULL, \"GA_ABRV_NM\" VARCHAR(5))");
        statement.executeUpdate("CREATE TABLE \"APP\".\"REG\" (\"REG_ID\" NUMERIC(20,0) NOT NULL, \"REG_NM\" VARCHAR(60) NOT NULL, \"REG_DESC\" VARCHAR(240), \"REG_ABRV_NM\" VARCHAR(15), \"REG_CD\" NUMERIC(8,0) NOT NULL, \"REG_STRT_DT\" TIMESTAMP NOT NULL, \"REG_END_DT\" TIMESTAMP NOT NULL DEFAULT '" + String.valueOf(Timestamp.valueOf("2009-12-05 01:29:59")) + "',\"REG_EMPR_LIAB_IND\" CHAR(1) NOT NULL DEFAULT 'N', \"REG_PAYR_TAX_SURG_CRTF_IND\" CHAR(1) NOT NULL DEFAULT 'N', \"REG_PYT_ID\" NUMERIC(20,0), \"REG_GA_ID\" NUMERIC(20,0) NOT NULL, \"REG_GVA_ID\" NUMERIC(20,0) NOT NULL, \"REG_REGT_ID\" NUMERIC(20,0) NOT NULL, \"REG_PRNT_ID\" NUMERIC(20,0))");
        resultSet = statement.executeQuery("SELECT 1 FROM reg JOIN geo_area jrsd ON (jrsd.ga_id = reg.reg_ga_id) LEFT OUTER JOIN geo_strc_elmt gse ON (gse.gse_ga_id_chld =reg.reg_ga_id) LEFT OUTER JOIN geo_area prnt ON (prnt.ga_id =reg.reg_ga_id) JOIN govt_agcy gva ON (reg.reg_gva_id = gva.gva_id)");
        String[] stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    public void testDerby_4471a() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table r(c1 char(1))");
        statement.executeUpdate("create table s(c1 char(1), c2 char(1))");
        statement.executeUpdate("create table t(c1 char(1))");
        statement.executeUpdate("insert into r values 'a'");
        statement.executeUpdate("insert into s values ('b', default)");
        statement.executeUpdate("insert into t values ('c')");
        ResultSet resultSet = statement.executeQuery("select * from r left outer join (s left outer join t                                  on s.c2=t.c1 or s.c2 is null)                on r.c1=s.c1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"a", null, null, null}});
    }

    public void testDerby_4471b() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t0(x int)");
        statement.executeUpdate("create table t1(x int)");
        statement.executeUpdate("create table t2(x int)");
        statement.executeUpdate("create table t3(x int)");
        statement.executeUpdate("create table t4(x int)");
        statement.executeUpdate("insert into t4 values(0)");
        statement.executeUpdate("insert into t4 values(1)");
        statement.executeUpdate("insert into t4 values(2)");
        statement.executeUpdate("insert into t4 values(3)");
        statement.executeUpdate("create table t5(x int)");
        statement.executeUpdate("insert into t5 values(0)");
        statement.executeUpdate("insert into t5 values(1)");
        statement.executeUpdate("insert into t5 values(2)");
        statement.executeUpdate("insert into t5 values(3)");
        statement.executeUpdate("insert into t5 values(4)");
        statement.executeUpdate("create table t6(x int)");
        statement.executeUpdate("insert into t6 values(0)");
        statement.executeUpdate("insert into t6 values(1)");
        statement.executeUpdate("insert into t6 values(2)");
        statement.executeUpdate("insert into t6 values(3)");
        statement.executeUpdate("insert into t6 values(4)");
        statement.executeUpdate("insert into t6 values(5)");
        statement.executeUpdate("create table t7(x int)");
        statement.executeUpdate("insert into t7 values(0)");
        statement.executeUpdate("insert into t7 values(1)");
        statement.executeUpdate("insert into t7 values(2)");
        statement.executeUpdate("insert into t7 values(3)");
        statement.executeUpdate("insert into t7 values(4)");
        statement.executeUpdate("insert into t7 values(5)");
        statement.executeUpdate("insert into t7 values(6)");
        statement.executeUpdate("create table t8(x int)");
        statement.executeUpdate("insert into t8 values(0)");
        statement.executeUpdate("insert into t8 values(1)");
        statement.executeUpdate("insert into t8 values(2)");
        statement.executeUpdate("insert into t8 values(3)");
        statement.executeUpdate("insert into t8 values(4)");
        statement.executeUpdate("insert into t8 values(5)");
        statement.executeUpdate("insert into t8 values(6)");
        statement.executeUpdate("insert into t8 values(7)");
        statement.executeUpdate("create table t9(x int)");
        statement.executeUpdate("insert into t9 values(0)");
        statement.executeUpdate("insert into t9 values(1)");
        statement.executeUpdate("insert into t9 values(2)");
        statement.executeUpdate("insert into t9 values(3)");
        statement.executeUpdate("insert into t9 values(4)");
        statement.executeUpdate("insert into t9 values(5)");
        statement.executeUpdate("insert into t9 values(6)");
        statement.executeUpdate("insert into t9 values(7)");
        statement.executeUpdate("insert into t9 values(8)");
        statement.executeUpdate("insert into t0 values(1)");
        statement.executeUpdate("insert into t1 values(2)");
        statement.executeUpdate("insert into t0 values(3)");
        statement.executeUpdate("insert into t1 values(3)");
        statement.executeUpdate("insert into t2 values(4)");
        statement.executeUpdate("insert into t0 values(5)");
        statement.executeUpdate("insert into t2 values(5)");
        statement.executeUpdate("insert into t1 values(6)");
        statement.executeUpdate("insert into t2 values(6)");
        statement.executeUpdate("insert into t0 values(7)");
        statement.executeUpdate("insert into t1 values(7)");
        statement.executeUpdate("insert into t2 values(7)");
        statement.executeUpdate("insert into t3 values(8)");
        statement.executeUpdate("insert into t0 values(9)");
        statement.executeUpdate("insert into t3 values(9)");
        statement.executeUpdate("insert into t1 values(10)");
        statement.executeUpdate("insert into t3 values(10)");
        statement.executeUpdate("insert into t0 values(11)");
        statement.executeUpdate("insert into t1 values(11)");
        statement.executeUpdate("insert into t3 values(11)");
        statement.executeUpdate("insert into t2 values(12)");
        statement.executeUpdate("insert into t3 values(12)");
        statement.executeUpdate("insert into t0 values(13)");
        statement.executeUpdate("insert into t2 values(13)");
        statement.executeUpdate("insert into t3 values(13)");
        statement.executeUpdate("insert into t1 values(14)");
        statement.executeUpdate("insert into t2 values(14)");
        statement.executeUpdate("insert into t3 values(14)");
        statement.executeUpdate("insert into t0 values(15)");
        statement.executeUpdate("insert into t1 values(15)");
        statement.executeUpdate("insert into t2 values(15)");
        statement.executeUpdate("insert into t3 values(15)");
        statement.executeUpdate("insert into t2 select * from t2");
        statement.executeUpdate("insert into t3 select * from t3");
        statement.executeUpdate("insert into t4 select * from t4");
        statement.executeUpdate("insert into t2 values cast(null as int)");
        statement.executeUpdate("insert into t3 values cast(null as int)");
        statement.executeUpdate("insert into t4 values cast(null as int)");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM (T2 LEFT JOIN (T3 left outer JOIN T4                                     ON 1=1)                       ON T2.X = T3.X)");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"4", null, null}, {"5", null, null}, {"6", null, null}, {"7", null, null}, {"12", "12", "0"}, {"12", "12", "1"}, {"12", "12", "2"}, {"12", "12", "3"}, {"12", "12", "0"}, {"12", "12", "1"}, {"12", "12", "2"}, {"12", "12", "3"}, {"12", "12", null}, {"12", "12", "0"}, {"12", "12", "1"}, {"12", "12", "2"}, {"12", "12", "3"}, {"12", "12", "0"}, {"12", "12", "1"}, {"12", "12", "2"}, {"12", "12", "3"}, {"12", "12", null}, {"13", "13", "0"}, {"13", "13", "1"}, {"13", "13", "2"}, {"13", "13", "3"}, {"13", "13", "0"}, {"13", "13", "1"}, {"13", "13", "2"}, {"13", "13", "3"}, {"13", "13", null}, {"13", "13", "0"}, {"13", "13", "1"}, {"13", "13", "2"}, {"13", "13", "3"}, {"13", "13", "0"}, {"13", "13", "1"}, {"13", "13", "2"}, {"13", "13", "3"}, {"13", "13", null}, {"14", "14", "0"}, {"14", "14", "1"}, {"14", "14", "2"}, {"14", "14", "3"}, {"14", "14", "0"}, {"14", "14", "1"}, {"14", "14", "2"}, {"14", "14", "3"}, {"14", "14", null}, {"14", "14", "0"}, {"14", "14", "1"}, {"14", "14", "2"}, {"14", "14", "3"}, {"14", "14", "0"}, {"14", "14", "1"}, {"14", "14", "2"}, {"14", "14", "3"}, {"14", "14", null}, {"15", "15", "0"}, {"15", "15", "1"}, {"15", "15", "2"}, {"15", "15", "3"}, {"15", "15", "0"}, {"15", "15", "1"}, {"15", "15", "2"}, {"15", "15", "3"}, {"15", "15", null}, {"15", "15", "0"}, {"15", "15", "1"}, {"15", "15", "2"}, {"15", "15", "3"}, {"15", "15", "0"}, {"15", "15", "1"}, {"15", "15", "2"}, {"15", "15", "3"}, {"15", "15", null}, {"4", null, null}, {"5", null, null}, {"6", null, null}, {"7", null, null}, {"12", "12", "0"}, {"12", "12", "1"}, {"12", "12", "2"}, {"12", "12", "3"}, {"12", "12", "0"}, {"12", "12", "1"}, {"12", "12", "2"}, {"12", "12", "3"}, {"12", "12", null}, {"12", "12", "0"}, {"12", "12", "1"}, {"12", "12", "2"}, {"12", "12", "3"}, {"12", "12", "0"}, {"12", "12", "1"}, {"12", "12", "2"}, {"12", "12", "3"}, {"12", "12", null}, {"13", "13", "0"}, {"13", "13", "1"}, {"13", "13", "2"}, {"13", "13", "3"}, {"13", "13", "0"}, {"13", "13", "1"}, {"13", "13", "2"}, {"13", "13", "3"}, {"13", "13", null}, {"13", "13", "0"}, {"13", "13", "1"}, {"13", "13", "2"}, {"13", "13", "3"}, {"13", "13", "0"}, {"13", "13", "1"}, {"13", "13", "2"}, {"13", "13", "3"}, {"13", "13", null}, {"14", "14", "0"}, {"14", "14", "1"}, {"14", "14", "2"}, {"14", "14", "3"}, {"14", "14", "0"}, {"14", "14", "1"}, {"14", "14", "2"}, {"14", "14", "3"}, {"14", "14", null}, {"14", "14", "0"}, {"14", "14", "1"}, {"14", "14", "2"}, {"14", "14", "3"}, {"14", "14", "0"}, {"14", "14", "1"}, {"14", "14", "2"}, {"14", "14", "3"}, {"14", "14", null}, {"15", "15", "0"}, {"15", "15", "1"}, {"15", "15", "2"}, {"15", "15", "3"}, {"15", "15", "0"}, {"15", "15", "1"}, {"15", "15", "2"}, {"15", "15", "3"}, {"15", "15", null}, {"15", "15", "0"}, {"15", "15", "1"}, {"15", "15", "2"}, {"15", "15", "3"}, {"15", "15", "0"}, {"15", "15", "1"}, {"15", "15", "2"}, {"15", "15", "3"}, {"15", "15", null}, {null, null, null}});
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        resultSet = statement.executeQuery("SELECT * FROM (T2 LEFT JOIN (T3 left outer JOIN T4                                     ON t3.x=t4.x)                       ON T2.X = T3.X)");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"4", null, null}, {"4", null, null}, {"5", null, null}, {"5", null, null}, {"6", null, null}, {"6", null, null}, {"7", null, null}, {"7", null, null}, {"12", "12", null}, {"12", "12", null}, {"12", "12", null}, {"12", "12", null}, {"13", "13", null}, {"13", "13", null}, {"13", "13", null}, {"13", "13", null}, {"14", "14", null}, {"14", "14", null}, {"14", "14", null}, {"14", "14", null}, {"15", "15", null}, {"15", "15", null}, {"15", "15", null}, {"15", "15", null}, {null, null, null}});
        JDBC.checkPlan(statement, new String[]{"Hash Left Outer Join ResultSet:", "Left result set:", "_Hash Left Outer Join ResultSet:"});
    }

    public void testDerby_4471c() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t1(c1 int)");
        statement.execute("create table t2(c1 int)");
        statement.execute("create table t3(c1 int)");
        statement.execute("insert into t1 values 1, 2, 2, 3, 4");
        statement.execute("insert into t2 values 1, 3, 3, 5, 6");
        statement.execute("insert into t3 values 2, 3, 5, 5, 7");
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 left outer join      (t2 left outer join t3 on t2.c1 = t3.c1)   on t1.c1 = t2.c1");
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"1", "1", null}, {"2", null, null}, {"2", null, null}, {"3", "3", "3"}, {"3", "3", "3"}, {"4", null, null}});
        JDBC.checkPlan(statement, new String[]{"Hash Left Outer Join ResultSet:", "Left result set:", "_Hash Left Outer Join ResultSet:"});
    }

    public void testDerby_4471d() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t1(c1 int)");
        statement.execute("create table t2(c2 int)");
        statement.execute("create table t3(c3 int)");
        statement.execute("insert into t1 values 1, 2, 2, 3, 4");
        statement.execute("insert into t2 values 1, 3, 3, 5, 6");
        statement.execute("insert into t3 values 2, 3, 5, 5, 7");
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 t1_o left outer join      ((t1 left outer join t2 on t1.c1 = t2.c2) left outer join       t3 on t2.c2 = t3.c3)   on t1_o.c1 = t2.c2");
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"1", "1", "1", null}, {"2", null, null, null}, {"2", null, null, null}, {"3", "3", "3", "3"}, {"3", "3", "3", "3"}, {"4", null, null, null}});
        JDBC.checkPlan(statement, new String[]{"Hash Left Outer Join ResultSet:", "Left result set:", "_Nested Loop Left Outer Join ResultSet:", "_Left result set:", "_Right result set:", "__Source result set:", "___Hash Left Outer Join ResultSet:"});
        preparedStatement = this.prepareStatement("select * from     t1 t1_o left outer join         ((t1 t1_i left outer join t2           on t1_i.c1 = t2.c2) left outer join t3          on t1_i.c1 = t3.c3)    on t1_o.c1 = t1_i.c1");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"1", "1", "1", null}, {"2", "2", null, "2"}, {"2", "2", null, "2"}, {"2", "2", null, "2"}, {"2", "2", null, "2"}, {"3", "3", "3", "3"}, {"3", "3", "3", "3"}, {"4", "4", null, null}});
        JDBC.checkPlan(statement, new String[]{"Hash Left Outer Join ResultSet:", "Left result set:", "_Hash Left Outer Join ResultSet:", "_Left result set:", "__Hash Left Outer Join ResultSet:"});
    }

    public void testDerby_4736() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t0(x int)");
        statement.executeUpdate("create table t1(x int)");
        statement.executeUpdate("create table t2(x int)");
        statement.executeUpdate("create table t3(x int)");
        statement.executeUpdate("create table t4(x int)");
        statement.executeUpdate("insert into t4 values(0)");
        statement.executeUpdate("insert into t4 values(1)");
        statement.executeUpdate("insert into t4 values(2)");
        statement.executeUpdate("insert into t4 values(3)");
        statement.executeUpdate("create table t5(x int)");
        statement.executeUpdate("insert into t5 values(0)");
        statement.executeUpdate("insert into t5 values(1)");
        statement.executeUpdate("insert into t5 values(2)");
        statement.executeUpdate("insert into t5 values(3)");
        statement.executeUpdate("insert into t5 values(4)");
        statement.executeUpdate("create table t6(x int)");
        statement.executeUpdate("insert into t6 values(0)");
        statement.executeUpdate("insert into t6 values(1)");
        statement.executeUpdate("insert into t6 values(2)");
        statement.executeUpdate("insert into t6 values(3)");
        statement.executeUpdate("insert into t6 values(4)");
        statement.executeUpdate("insert into t6 values(5)");
        statement.executeUpdate("create table t7(x int)");
        statement.executeUpdate("insert into t7 values(0)");
        statement.executeUpdate("insert into t7 values(1)");
        statement.executeUpdate("insert into t7 values(2)");
        statement.executeUpdate("insert into t7 values(3)");
        statement.executeUpdate("insert into t7 values(4)");
        statement.executeUpdate("insert into t7 values(5)");
        statement.executeUpdate("insert into t7 values(6)");
        statement.executeUpdate("create table t8(x int)");
        statement.executeUpdate("insert into t8 values(0)");
        statement.executeUpdate("insert into t8 values(1)");
        statement.executeUpdate("insert into t8 values(2)");
        statement.executeUpdate("insert into t8 values(3)");
        statement.executeUpdate("insert into t8 values(4)");
        statement.executeUpdate("insert into t8 values(5)");
        statement.executeUpdate("insert into t8 values(6)");
        statement.executeUpdate("insert into t8 values(7)");
        statement.executeUpdate("create table t9(x int)");
        statement.executeUpdate("insert into t9 values(0)");
        statement.executeUpdate("insert into t9 values(1)");
        statement.executeUpdate("insert into t9 values(2)");
        statement.executeUpdate("insert into t9 values(3)");
        statement.executeUpdate("insert into t9 values(4)");
        statement.executeUpdate("insert into t9 values(5)");
        statement.executeUpdate("insert into t9 values(6)");
        statement.executeUpdate("insert into t9 values(7)");
        statement.executeUpdate("insert into t9 values(8)");
        statement.executeUpdate("insert into t0 values(1)");
        statement.executeUpdate("insert into t1 values(2)");
        statement.executeUpdate("insert into t0 values(3)");
        statement.executeUpdate("insert into t1 values(3)");
        statement.executeUpdate("insert into t2 values(4)");
        statement.executeUpdate("insert into t0 values(5)");
        statement.executeUpdate("insert into t2 values(5)");
        statement.executeUpdate("insert into t1 values(6)");
        statement.executeUpdate("insert into t2 values(6)");
        statement.executeUpdate("insert into t0 values(7)");
        statement.executeUpdate("insert into t1 values(7)");
        statement.executeUpdate("insert into t2 values(7)");
        statement.executeUpdate("insert into t3 values(8)");
        statement.executeUpdate("insert into t0 values(9)");
        statement.executeUpdate("insert into t3 values(9)");
        statement.executeUpdate("insert into t1 values(10)");
        statement.executeUpdate("insert into t3 values(10)");
        statement.executeUpdate("insert into t0 values(11)");
        statement.executeUpdate("insert into t1 values(11)");
        statement.executeUpdate("insert into t3 values(11)");
        statement.executeUpdate("insert into t2 values(12)");
        statement.executeUpdate("insert into t3 values(12)");
        statement.executeUpdate("insert into t0 values(13)");
        statement.executeUpdate("insert into t2 values(13)");
        statement.executeUpdate("insert into t3 values(13)");
        statement.executeUpdate("insert into t1 values(14)");
        statement.executeUpdate("insert into t2 values(14)");
        statement.executeUpdate("insert into t3 values(14)");
        statement.executeUpdate("insert into t0 values(15)");
        statement.executeUpdate("insert into t1 values(15)");
        statement.executeUpdate("insert into t2 values(15)");
        statement.executeUpdate("insert into t3 values(15)");
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet resultSet = statement.executeQuery("select t0.x , t1.x , t2.x , t3.x , t4.x , t5.x , t6.x from     ((t0 right outer join          (t1 right outer join              (t2 left outer join                  (t3 left outer join t4 on t3.x = t4.x )               on t2.x = t3.x )           on t1.x = t3.x )       on t0.x = t1.x )      left outer join       (t5 inner join t6 on t5.x = t6.x )      on t2.x = t5.x)");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{null, null, "4", null, null, "4", "4"}, {null, null, "5", null, null, null, null}, {null, null, "6", null, null, null, null}, {null, null, "7", null, null, null, null}, {null, null, "12", "12", null, null, null}, {null, null, "13", "13", null, null, null}, {null, "14", "14", "14", null, null, null}, {"15", "15", "15", "15", null, null, null}});
        resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        String string = resultSet.getString(1);
        RuntimeStatisticsParser runtimeStatisticsParser = new RuntimeStatisticsParser(string);
        runtimeStatisticsParser.assertSequence(new String[]{"_Nested Loop Left Outer Join ResultSet:", "_Left result set:", "__Hash Left Outer Join ResultSet:", "__Left result set:", "___Hash Left Outer Join ResultSet:", "___Left result set:", "____Hash Left Outer Join ResultSet:", "____Left result set:", "_____Hash Left Outer Join ResultSet:", "_____Left result set:", "______Table Scan ResultSet for T2 ", "_____Right result set:", "______Hash Scan ResultSet for T3 ", "____Right result set:", "_____Hash Scan ResultSet for T4"});
        resultSet.close();
    }

    public void testDerby_4736_nullability() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        statement.executeUpdate("CREATE TABLE T (A INT NOT NULL, B DECIMAL(10,3) NOT NULL, C VARCHAR(5) NOT NULL)");
        statement.executeUpdate(" INSERT INTO T VALUES (1, 1.0, '1'), (2, 2.0, '2'), (3, 3.0, '3')");
        statement.executeUpdate(" CREATE TABLE S (D INT NOT NULL, E DECIMAL(10,3) NOT NULL, F VARCHAR(5) NOT NULL)");
        statement.executeUpdate(" INSERT INTO S VALUES (2, 2.0, '2'), (3, 3.0, '3'), (4, 4.0, '4')");
        statement.executeUpdate("create view v1 (fv, ev, dv, cv, bv, av) as (select f, e, d, c, b, a from t left outer join s on b = e)");
        resultSet = statement.executeQuery(" select * from t left outer join (s left outer join v1 on (f = cv)) on (d=a)");
        String[] stringArray = new String[]{"A", "B", "C", "D", "E", "F", "FV", "EV", "DV", "CV", "BV", "AV"};
        JDBC.assertColumnNames(resultSet, stringArray);
        String[][] stringArray2 = new String[][]{{"1", "1.000", "1", null, null, null, "1", "1.000", "1", null, null, null}, {"2", "2.000", "2", "2", "2.000", "2", "2", "2.000", "2", "2", "2.000", "2"}, {"3", "3.000", "3", "3", "3.000", "3", "3", "3.000", "3", "3", "3.000", "3"}};
        JDBC.assertFullResultSet(resultSet, stringArray2);
    }

    public void testDerby_4712_NPEs() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        statement.executeUpdate("create table t0(x0 int)");
        statement.executeUpdate("create table t1(x1 int)");
        statement.executeUpdate("create table t2(x2 int)");
        statement.executeUpdate("create table t3(x3 int)");
        statement.executeUpdate("create table t4(x4 int)");
        statement.executeUpdate("insert into t4 values(0)");
        statement.executeUpdate("insert into t4 values(1)");
        statement.executeUpdate("insert into t4 values(2)");
        statement.executeUpdate("insert into t4 values(3)");
        statement.executeUpdate("create table t5(x5 int)");
        statement.executeUpdate("insert into t5 values(0)");
        statement.executeUpdate("insert into t5 values(1)");
        statement.executeUpdate("insert into t5 values(2)");
        statement.executeUpdate("insert into t5 values(3)");
        statement.executeUpdate("insert into t5 values(4)");
        statement.executeUpdate("create table t6(x6 int)");
        statement.executeUpdate("insert into t6 values(0)");
        statement.executeUpdate("insert into t6 values(1)");
        statement.executeUpdate("insert into t6 values(2)");
        statement.executeUpdate("insert into t6 values(3)");
        statement.executeUpdate("insert into t6 values(4)");
        statement.executeUpdate("insert into t6 values(5)");
        statement.executeUpdate("create table t7(x7 int)");
        statement.executeUpdate("insert into t7 values(0)");
        statement.executeUpdate("insert into t7 values(1)");
        statement.executeUpdate("insert into t7 values(2)");
        statement.executeUpdate("insert into t7 values(3)");
        statement.executeUpdate("insert into t7 values(4)");
        statement.executeUpdate("insert into t7 values(5)");
        statement.executeUpdate("insert into t7 values(6)");
        statement.executeUpdate("create table t8(x8 int)");
        statement.executeUpdate("insert into t8 values(0)");
        statement.executeUpdate("insert into t8 values(1)");
        statement.executeUpdate("insert into t8 values(2)");
        statement.executeUpdate("insert into t8 values(3)");
        statement.executeUpdate("insert into t8 values(4)");
        statement.executeUpdate("insert into t8 values(5)");
        statement.executeUpdate("insert into t8 values(6)");
        statement.executeUpdate("insert into t8 values(7)");
        statement.executeUpdate("create table t9(x9 int)");
        statement.executeUpdate("insert into t9 values(0)");
        statement.executeUpdate("insert into t9 values(1)");
        statement.executeUpdate("insert into t9 values(2)");
        statement.executeUpdate("insert into t9 values(3)");
        statement.executeUpdate("insert into t9 values(4)");
        statement.executeUpdate("insert into t9 values(5)");
        statement.executeUpdate("insert into t9 values(6)");
        statement.executeUpdate("insert into t9 values(7)");
        statement.executeUpdate("insert into t9 values(8)");
        statement.executeUpdate("insert into t0 values(1)");
        statement.executeUpdate("insert into t1 values(2)");
        statement.executeUpdate("insert into t0 values(3)");
        statement.executeUpdate("insert into t1 values(3)");
        statement.executeUpdate("insert into t2 values(4)");
        statement.executeUpdate("insert into t0 values(5)");
        statement.executeUpdate("insert into t2 values(5)");
        statement.executeUpdate("insert into t1 values(6)");
        statement.executeUpdate("insert into t2 values(6)");
        statement.executeUpdate("insert into t0 values(7)");
        statement.executeUpdate("insert into t1 values(7)");
        statement.executeUpdate("insert into t2 values(7)");
        statement.executeUpdate("insert into t3 values(8)");
        statement.executeUpdate("insert into t0 values(9)");
        statement.executeUpdate("insert into t3 values(9)");
        statement.executeUpdate("insert into t1 values(10)");
        statement.executeUpdate("insert into t3 values(10)");
        statement.executeUpdate("insert into t0 values(11)");
        statement.executeUpdate("insert into t1 values(11)");
        statement.executeUpdate("insert into t3 values(11)");
        statement.executeUpdate("insert into t2 values(12)");
        statement.executeUpdate("insert into t3 values(12)");
        statement.executeUpdate("insert into t0 values(13)");
        statement.executeUpdate("insert into t2 values(13)");
        statement.executeUpdate("insert into t3 values(13)");
        statement.executeUpdate("insert into t1 values(14)");
        statement.executeUpdate("insert into t2 values(14)");
        statement.executeUpdate("insert into t3 values(14)");
        statement.executeUpdate("insert into t0 values(15)");
        statement.executeUpdate("insert into t1 values(15)");
        statement.executeUpdate("insert into t2 values(15)");
        statement.executeUpdate("insert into t3 values(15)");
        resultSet = statement.executeQuery("SELECT t0.x0,                                                         t1.x1,                                                         t2.x2,                                                         t3.x3,                                                         t4.x4,                                                         t5.x5,                                                         t6.x6,                                                         t7.x7,                                                         t8.x8                                                   FROM   (((t0                                                             INNER JOIN ((t1                                                             RIGHT OUTER JOIN (t2                                                             INNER JOIN t3                                                    ON t2.x2 = t3.x3 )                           ON t1.x1 = t2.x2 )                                          LEFT OUTER JOIN (t4                                                             INNER JOIN t5                                                    ON t4.x4 = t5.x5 )                            ON t1.x1 = t4.x4 )                                 ON t0.x0 = t2.x2 )                                          LEFT OUTER JOIN (t6                                                             INNER JOIN t7                                                    ON t6.x6 = t7.x7 )                            ON t1.x1 = t6.x6 )                                          INNER JOIN t8                                                    ON t5.x5 = t8.x8 )                                   ");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("SELECT t0.x0,                                                      t1.x1,                                                      t2.x2,                                                      t3.x3,                                                      t4.x4,                                                      t5.x5,                                                      t6.x6,                                                      t7.x7                                                FROM   ((t0                                                          RIGHT OUTER JOIN t1                                           ON t0.x0 = t1.x1 )                                       INNER JOIN (((t2                                                          INNER JOIN (t3                                                          LEFT OUTER JOIN t4                                            ON t3.x3 = t4.x4 )                              ON t2.x2 = t3.x3 )                                       RIGHT OUTER JOIN t5                                           ON t2.x2 = t5.x5 )                                       LEFT OUTER JOIN (t6                                                          INNER JOIN t7                                                 ON t6.x6 = t7.x7 )                         ON t4.x4 = t6.x6 )                              ON t0.x0 = t5.x5 )                                ");
        String[][] stringArray = new String[][]{{"3", "3", null, null, null, "3", null, null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("SELECT t0.x0,                                                       t1.x1,                                                       t2.x2,                                                       t3.x3,                                                       t4.x4,                                                       t5.x5,                                                       t6.x6,                                                       t7.x7                                                 FROM   ((((t0                                                           LEFT OUTER JOIN t1                                             ON t0.x0 = t1.x1 )                                        RIGHT OUTER JOIN t2                                            ON t0.x0 = t2.x2 )                                        RIGHT OUTER JOIN t3                                            ON t0.x0 = t3.x3 )                                        INNER JOIN ((t4                                                           INNER JOIN t5                                                  ON t4.x4 = t5.x5 )                                        RIGHT OUTER JOIN (t6                                                           RIGHT OUTER JOIN t7                                            ON t6.x6 = t7.x7 )                         ON t4.x4 = t6.x6 )                               ON t1.x1 = t4.x4 )                                 ");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("SELECT t0.x0,                                           t1.x1,                                           t2.x2,                                           t3.x3,                                           t4.x4,                                           t5.x5                                     FROM   (((t0                                               INNER JOIN t1                                      ON t0.x0 = t1.x1 )                            RIGHT OUTER JOIN (t2                                               RIGHT OUTER JOIN t3                                ON t2.x2 = t3.x3 )             ON t0.x0 = t2.x2 )                            INNER JOIN (t4                                               LEFT OUTER JOIN t5                                 ON t4.x4 = t5.x5 )                   ON t1.x1 = t4.x4 )                     ");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("SELECT t0.x0,                                                           t1.x1,                                                           t2.x2,                                                           t3.x3,                                                           t4.x4,                                                           t5.x5,                                                           t6.x6                                                     FROM   ((t0                                                               RIGHT OUTER JOIN                                                          (t1                                                               RIGHT OUTER JOIN (t2                                                               LEFT OUTER JOIN                                                        (t3                                                               LEFT OUTER JOIN t4                                                  ON t3.x3 = t4.x4                                              )                                                                   ON t2.x2 = t3.x3 )                      ON t1.x1 = t3.x3 )                                    ON t0.x0 = t1.x1 )                                            LEFT OUTER JOIN (t5                                                               INNER JOIN t6                                                      ON t5.x5 = t6.x6 )                              ON t2.x2 = t5.x5 )                                     ");
        stringArray = new String[][]{{null, null, "4", null, null, "4", "4"}, {null, null, "5", null, null, null, null}, {null, null, "6", null, null, null, null}, {null, null, "7", null, null, null, null}, {null, null, "12", "12", null, null, null}, {null, null, "13", "13", null, null, null}, {null, "14", "14", "14", null, null, null}, {"15", "15", "15", "15", null, null, null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testDerby_4798_NPE() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        ResultSet resultSet = null;
        statement.executeUpdate("create table t0(x0 int)");
        statement.executeUpdate("create table t1(x1 int)");
        statement.executeUpdate("create table t2(x2 int)");
        statement.executeUpdate("create table t3(x3 int)");
        statement.executeUpdate("create table t4(x4 int)");
        statement.executeUpdate("insert into t4 values(0)");
        statement.executeUpdate("insert into t4 values(1)");
        statement.executeUpdate("insert into t4 values(2)");
        statement.executeUpdate("insert into t4 values(3)");
        statement.executeUpdate("create table t5(x5 int)");
        statement.executeUpdate("insert into t5 values(0)");
        statement.executeUpdate("insert into t5 values(1)");
        statement.executeUpdate("insert into t5 values(2)");
        statement.executeUpdate("insert into t5 values(3)");
        statement.executeUpdate("insert into t5 values(4)");
        statement.executeUpdate("create table t6(x6 int)");
        statement.executeUpdate("insert into t6 values(0)");
        statement.executeUpdate("insert into t6 values(1)");
        statement.executeUpdate("insert into t6 values(2)");
        statement.executeUpdate("insert into t6 values(3)");
        statement.executeUpdate("insert into t6 values(4)");
        statement.executeUpdate("insert into t6 values(5)");
        statement.executeUpdate("create table t7(x7 int)");
        statement.executeUpdate("insert into t7 values(0)");
        statement.executeUpdate("insert into t7 values(1)");
        statement.executeUpdate("insert into t7 values(2)");
        statement.executeUpdate("insert into t7 values(3)");
        statement.executeUpdate("insert into t7 values(4)");
        statement.executeUpdate("insert into t7 values(5)");
        statement.executeUpdate("insert into t7 values(6)");
        statement.executeUpdate("insert into t0 values(1)");
        statement.executeUpdate("insert into t1 values(2)");
        statement.executeUpdate("insert into t0 values(3)");
        statement.executeUpdate("insert into t1 values(3)");
        statement.executeUpdate("insert into t2 values(4)");
        statement.executeUpdate("insert into t0 values(5)");
        statement.executeUpdate("insert into t2 values(5)");
        statement.executeUpdate("insert into t1 values(6)");
        statement.executeUpdate("insert into t2 values(6)");
        statement.executeUpdate("insert into t0 values(7)");
        statement.executeUpdate("insert into t1 values(7)");
        statement.executeUpdate("insert into t2 values(7)");
        statement.executeUpdate("insert into t3 values(8)");
        statement.executeUpdate("insert into t0 values(9)");
        statement.executeUpdate("insert into t3 values(9)");
        statement.executeUpdate("insert into t1 values(10)");
        statement.executeUpdate("insert into t3 values(10)");
        statement.executeUpdate("insert into t0 values(11)");
        statement.executeUpdate("insert into t1 values(11)");
        statement.executeUpdate("insert into t3 values(11)");
        statement.executeUpdate("insert into t2 values(12)");
        statement.executeUpdate("insert into t3 values(12)");
        statement.executeUpdate("insert into t0 values(13)");
        statement.executeUpdate("insert into t2 values(13)");
        statement.executeUpdate("insert into t3 values(13)");
        statement.executeUpdate("insert into t1 values(14)");
        statement.executeUpdate("insert into t2 values(14)");
        statement.executeUpdate("insert into t3 values(14)");
        statement.executeUpdate("insert into t0 values(15)");
        statement.executeUpdate("insert into t1 values(15)");
        statement.executeUpdate("insert into t2 values(15)");
        statement.executeUpdate("insert into t3 values(15)");
        resultSet = statement.executeQuery("SELECT t0.x0,        t1.x1,       t2.x2,       t3.x3,       t4.x4,       t5.x5,       t6.x6,       t7.x7 FROM          ((t0                                                                  LEFT OUTER JOIN ((t1                                                                  LEFT OUTER JOIN (t2                                                                  LEFT OUTER JOIN t3                                                    ON t2.x2 = t3.x3 )                                 ON t1.x1 = t2.x2 )                                               LEFT OUTER JOIN (t4                                                                  INNER JOIN (t5                                                                  LEFT OUTER JOIN t6                                                    ON t5.x5 = t6.x6)                                       ON t4.x4 = t5.x5 )                                 ON t1.x1 = t5.x5 )                                 ON t0.x0 = t5.x5 )                                               LEFT OUTER JOIN t7                                                    ON t3.x3 = t7.x7 )                                              ");
        String[][] stringArray = new String[][]{{"1", "1", null, null, null, null, null, null}, {"3", "3", "3", null, "3", "3", "3", null}, {"5", "5", null, null, null, null, null, null}, {"7", "7", null, null, null, null, null, null}, {"9", "9", null, null, null, null, null, null}, {"11", "11", null, null, null, null, null, null}, {"13", "13", null, null, null, null, null, null}, {"15", "15", null, null, null, null, null, null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }
}

