/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import junit.framework.Test;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.IntArray;
import org.apache.derbyTesting.functionTests.tests.lang.Price;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UDTTest
extends GeneratedColumnsHelper {
    public static final String OBJECT_EXISTS = "X0Y68";
    public static final String VIEW_DEPENDS_ON_TYPE = "X0Y23";
    public static final String TRIGGER_DEPENDS_ON_TYPE = "X0Y24";

    public UDTTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(UDTTest.class);
    }

    public void test_01_basicSyntax() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create schema adt_schema\n");
        this.makeGoodTypes(connection);
        this.expectExecutionError(connection, OBJECT_EXISTS, "create type fooType external name 'mypackage.foo' language java\n");
        this.expectExecutionError(connection, OBJECT_EXISTS, "create type adt_schema.fooType external name 'mypackage.foo' language java\n");
        this.expectExecutionError(connection, OBJECT_EXISTS, "create type \"smallint\" external name 'mypackage.foo' language java\n");
        this.expectExecutionError(connection, OBJECT_EXISTS, "create type \"SMALLINT\" external name 'mypackage.foo' language java\n");
        this.expectCompilationError("42X01", "drop type fooType\n");
        this.goodStatement(connection, "drop type fooType restrict\n");
        this.goodStatement(connection, "drop type adt_schema.fooType restrict\n");
        this.goodStatement(connection, "drop type \"smallint\" restrict\n");
        this.goodStatement(connection, "drop type \"SMALLINT\" restrict\n");
        this.expectCompilationError("42Y55", "drop type fooType restrict\n");
        this.expectCompilationError("42Y55", "drop type adt_schema.fooType restrict\n");
        this.expectCompilationError("42Y55", "drop type \"smallint\" restrict\n");
        this.expectCompilationError("42Y55", "drop type \"SMALLINT\" restrict\n");
        this.makeGoodTypes(connection);
    }

    private void makeGoodTypes(Connection connection) throws Exception {
        this.goodStatement(connection, "create type fooType external name 'mypackage.foo' language java\n");
        this.goodStatement(connection, "create type adt_schema.fooType external name 'mypackage.foo' language java\n");
        this.goodStatement(connection, "create type \"smallint\" external name 'mypackage.foo' language java\n");
        this.goodStatement(connection, "create type \"SMALLINT\" external name 'mypackage.foo' language java\n");
    }

    public void test_02_basicColumnRetvalParam() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create table orders( orderID int generated always as identity, customerID int, totalPrice price )\n");
        this.goodStatement(connection, "create function makePrice( currencyCode char( 3 ), amount decimal( 31, 5 ), timeInstant Timestamp )\nreturns Price language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        this.goodStatement(connection, "create function getCurrencyCode( price Price ) returns char( 3 ) language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getCurrencyCode'\n");
        this.goodStatement(connection, "create function getAmount( price Price ) returns decimal( 31, 5 ) language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getAmount'\n");
        this.goodStatement(connection, "create function getTimeInstant( price Price ) returns timestamp language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getTimeInstant'\n");
        this.goodStatement(connection, "create procedure savePrice( in a Price ) language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.savePrice'\n");
        this.goodStatement(connection, "create function getSavedPrice() returns Price language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getSavedPrice'\n");
        this.goodStatement(connection, "insert into orders( customerID, totalPrice ) values\n( 12345, makePrice( 'USD', cast( 9.99 as decimal( 31, 5 ) ), timestamp('2009-10-16 14:24:43') ) )\n");
        this.assertResults(connection, "select getCurrencyCode( totalPrice ), getTimeInstant( totalPrice ) from orders", new String[][]{{"USD", "2009-10-16 14:24:43.0"}}, false);
        this.assertResults(connection, "select totalPrice from orders", new String[][]{{"Price( USD, 9.99000, 2009-10-16 14:24:43.0 )"}}, false);
        this.goodStatement(connection, "call savePrice\n( makePrice( 'EUR', cast( 1.23 as decimal( 31, 5 ) ), timestamp('2008-10-16 14:24:43') ) )\n");
        this.assertResults(connection, "values( getSavedPrice() )", new String[][]{{"Price( EUR, 1.23000, 2008-10-16 14:24:43.0 )"}}, false);
    }

    public void test_03_addDropColumn() throws Exception {
        Connection connection = this.getConnection();
        String string = "UDTCOLUMNS";
        String string2 = "UDTCOLUMNS2";
        this.goodStatement(connection, "create type price_03 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create table " + string + "\n(\n    a int, b int,\n    price1 price_03,\n    price2 price_03\n)\n");
        UDTTest.assertEquals((int)1, (int)this.countTableDependencies(connection, string));
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03 restrict\n");
        this.goodStatement(connection, "alter table udtColumns add column price3 price_03\n");
        UDTTest.assertEquals((int)1, (int)this.countTableDependencies(connection, string));
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03 restrict\n");
        this.goodStatement(connection, "alter table udtColumns drop column price3\n");
        UDTTest.assertEquals((int)1, (int)this.countTableDependencies(connection, string));
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03 restrict\n");
        this.goodStatement(connection, "alter table udtColumns drop column price2\n");
        UDTTest.assertEquals((int)1, (int)this.countTableDependencies(connection, string));
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03 restrict\n");
        this.goodStatement(connection, "alter table udtColumns drop column price1\n");
        UDTTest.assertEquals((int)0, (int)this.countTableDependencies(connection, string));
        this.goodStatement(connection, "drop type Price_03 restrict\n");
        this.goodStatement(connection, "create type price_03_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create type price_03_b external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create type price_03_c external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create table udtColumns2\n(\n    a int, b int,\n    price1 price_03_a,\n    price2 price_03_b\n)\n");
        UDTTest.assertEquals((int)2, (int)this.countTableDependencies(connection, string2));
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03_a restrict\n");
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03_b restrict\n");
        this.goodStatement(connection, "alter table udtColumns2 add column price3 price_03_c\n");
        UDTTest.assertEquals((int)3, (int)this.countTableDependencies(connection, string2));
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03_a restrict\n");
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03_b restrict\n");
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03_c restrict\n");
        this.goodStatement(connection, "alter table udtColumns2 drop column b\n");
        UDTTest.assertEquals((int)3, (int)this.countTableDependencies(connection, string2));
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03_a restrict\n");
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03_b restrict\n");
        this.expectExecutionError(connection, "X0Y29", "drop type Price_03_c restrict\n");
        this.goodStatement(connection, "alter table udtColumns2 drop column price3\n");
        UDTTest.assertEquals((int)2, (int)this.countTableDependencies(connection, string2));
        this.goodStatement(connection, "drop type Price_03_c restrict\n");
        this.goodStatement(connection, "alter table udtColumns2 drop column price2\n");
        UDTTest.assertEquals((int)1, (int)this.countTableDependencies(connection, string2));
        this.goodStatement(connection, "drop type Price_03_b restrict\n");
        this.goodStatement(connection, "alter table udtColumns2 drop column price1\n");
        UDTTest.assertEquals((int)0, (int)this.countTableDependencies(connection, string2));
        this.goodStatement(connection, "drop type Price_03_a restrict\n");
    }

    public void test_04_dropTable() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type price_orphan external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create type price_orphan2 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create type price_orphan3 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create type price_orphan4 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create table t_orphan( a price_orphan )\n");
        this.goodStatement(connection, "create table t_orphan2( a price_orphan2, b int, c price_orphan2 )\n");
        this.goodStatement(connection, "create table t_orphan3( a price_orphan3, b int, c price_orphan4 )\n");
        this.expectExecutionError(connection, "X0Y29", "drop type price_orphan restrict\n");
        this.goodStatement(connection, "drop table t_orphan\n");
        this.goodStatement(connection, "drop type price_orphan restrict\n");
        this.expectExecutionError(connection, "X0Y29", "drop type price_orphan2 restrict\n");
        this.goodStatement(connection, "drop table t_orphan2\n");
        this.goodStatement(connection, "drop type price_orphan2 restrict\n");
        this.expectExecutionError(connection, "X0Y29", "drop type price_orphan3 restrict\n");
        this.expectExecutionError(connection, "X0Y29", "drop type price_orphan4 restrict\n");
        this.goodStatement(connection, "drop table t_orphan3\n");
        this.goodStatement(connection, "drop type price_orphan3 restrict\n");
        this.goodStatement(connection, "drop type price_orphan4 restrict\n");
    }

    public void test_05_viewDependencies() throws Exception {
        Connection connection = this.getConnection();
        String string = "create type price_05_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        String string2 = "drop type price_05_a restrict\n";
        String string3 = "create view udtView( a, b, c ) as\nselect tabletype, cast (null as price_05_a), cast( null as price_05_a)\nfrom sys.systables\n";
        String string4 = "drop view udtView\n";
        String string5 = VIEW_DEPENDS_ON_TYPE;
        this.verifyDropRestrictions(connection, string, string2, string3, string4, string5);
        string = "create type price_05_b external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        string2 = "drop type price_05_b restrict\n";
        string3 = "create view udtView_b( a ) as\nselect tabletype from sys.systables where ( cast (null as price_05_b) ) is not null\n";
        string4 = "drop view udtView_b\n";
        string5 = VIEW_DEPENDS_ON_TYPE;
        this.verifyDropRestrictions(connection, string, string2, string3, string4, string5);
    }

    public void test_06_casts() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type price_06_b external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.assertResults(connection, "values ( cast ( null as price_06_b ) )\n", new String[][]{{null}}, false);
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "values ( cast ( ? as price_06_b ) )");
        preparedStatement.setObject(1, Price.makePrice());
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Price price = (Price)resultSet.getObject(1);
        resultSet.close();
        preparedStatement.close();
        UDTTest.assertTrue((boolean)Price.makePrice().equals(price));
    }

    public void test_07_routineDependencies() throws Exception {
        Connection connection = this.getConnection();
        String string = "create type price_07_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        String string2 = "drop type price_07_a restrict\n";
        String string3 = "create function makePrice_07_a( )\nreturns price_07_a\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n";
        String string4 = "drop function makePrice_07_a\n";
        String string5 = "X0Y30";
        this.verifyDropRestrictions(connection, string, string2, string3, string4, string5);
        string = "create type price_07_b external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        string2 = "drop type price_07_b restrict\n";
        string3 = "create function getCurrencyCode_07_b(  priceArg1 price_07_b  )\nreturns char( 3 )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.getCurrencyCode'\n";
        string4 = "drop function getCurrencyCode_07_b\n";
        string5 = "X0Y30";
        this.verifyDropRestrictions(connection, string, string2, string3, string4, string5);
        string = "create type price_07_c external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        string2 = "drop type price_07_c restrict\n";
        string3 = "create procedure oneArgPriceProc_07( price1 price_07_c )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.oneArgPriceProc_07'\n";
        string4 = "drop procedure oneArgPriceProc_07\n";
        string5 = "X0Y30";
        this.verifyDropRestrictions(connection, string, string2, string3, string4, string5);
        string = "create type price_07_d external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        string2 = "drop type price_07_d restrict\n";
        string3 = "create procedure twoArgPriceProc_07( price1 price_07_d, price2 price_07_d )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.twoArgPriceProc_07'\n";
        string4 = "drop procedure twoArgPriceProc_07\n";
        string5 = "X0Y30";
        this.verifyDropRestrictions(connection, string, string2, string3, string4, string5);
        string = "create type hashmap_07 external name 'java.util.HashMap' language java\n";
        string2 = "drop type hashmap_07 restrict\n";
        string3 = "create function hashmapReader_07() returns table\n(\n    a int,\n    b hashmap_07\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.hashmapReader'\n";
        string4 = "drop function hashmapReader_07\n";
        string5 = "X0Y30";
        this.verifyDropRestrictions(connection, string, string2, string3, string4, string5);
        string = "create type hashmap_07_a external name 'java.util.HashMap' language java\n";
        string2 = "drop type hashmap_07_a restrict\n";
        string3 = "create function hashmapReader_07_a( a hashmap_07_a ) returns table\n(\n    a int,\n    b hashmap_07_a\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.hashmapReader'\n";
        string4 = "drop function hashmapReader_07_a\n";
        string5 = "X0Y30";
        this.verifyDropRestrictions(connection, string, string2, string3, string4, string5);
    }

    public void test_08_triggerDependencies() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create table t_08_a( a int )");
        this.goodStatement(connection, "create table t_08_b( a int )");
        String string = "create type price_08_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n";
        String string2 = "drop type price_08_a restrict\n";
        String string3 = "create trigger trig_08_a after insert on t_08_a\n  insert into t_08_b( a ) select ( a ) from t_08_a where ( cast( null as price_08_a ) ) is not null\n";
        String string4 = "drop trigger trig_08_a";
        String string5 = TRIGGER_DEPENDS_ON_TYPE;
        this.verifyDropRestrictions(connection, string, string2, string3, string4, string5);
    }

    public void test_09_resultSetMetaData() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type price_09_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create table t_09_a( a price_09_a )\n");
        this.checkRSMD(connection, "select a from t_09_a\n", "org.apache.derbyTesting.functionTests.tests.lang.Price", 15, 2000, "\"APP\".\"PRICE_09_A\"", 0, 0);
        this.checkRSMD(connection, "select aliasinfo from sys.sysaliases\n", "org.apache.derby.catalog.AliasInfo", 15, 2000, "org.apache.derby.catalog.AliasInfo", 0, 0);
    }

    public void test_10_parameterMetaData() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type price_10_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection, "create table t_10_a( a price_10_a )\n");
        this.checkPMD(connection, "insert into t_10_a( a ) values ( ? )\n", "org.apache.derbyTesting.functionTests.tests.lang.Price", 2000, "\"APP\".\"PRICE_10_A\"", 0, 0);
    }

    public void test_11_tableFunctionColumns() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type hashmap_11 external name 'java.util.HashMap' language java\n");
        this.goodStatement(connection, "create function makeHashMap_11() returns hashmap_11\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeHashMap'\n");
        this.goodStatement(connection, "create function putValue_11( map hashmap_11, k varchar( 100 ), v varchar( 100 ) ) returns hashmap_11\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.putValue'\n");
        this.goodStatement(connection, "create table t_11( intCol int, varcharCol varchar( 10 ), hashmapCol hashmap_11 )\n");
        this.goodStatement(connection, "create function hashmapReader() returns table\n(\n    a int,\n    b hashmap_11\n)\nlanguage java parameter style derby_jdbc_result_set\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.hashmapReader'\n");
        this.goodStatement(connection, "insert into t_11( intCol, varcharCol, hashmapCol ) values ( 2, 'def', putValue_11( makeHashMap_11(), 'kangaroo', 'foo' ) )\n");
        this.assertResults(connection, "select * from table( hashmapReader() ) s", new String[][]{{"2", "{kangaroo=foo}"}}, true);
    }

    public void test_12_largeUDTs() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type IntArray external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray' language java\n");
        this.goodStatement(connection, "create function makeIntArray( arrayLength int ) returns IntArray\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray.makeIntArray'\n");
        this.goodStatement(connection, "create function setCell( array IntArray, cellNumber int, cellValue int ) returns IntArray\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray.setCell'\n");
        this.goodStatement(connection, "create function getCell( array IntArray, cellNumber int ) returns int\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray.getCell'\n");
        this.goodStatement(connection, "create table t_12( id int generated always as identity, data IntArray )\n");
        this.goodStatement(connection, "insert into t_12( data ) values ( setCell( makeIntArray( 3 ), 1, 5 ) )\n");
        this.goodStatement(connection, "insert into t_12( data ) values ( setCell( makeIntArray( 100000 ), 90000, 3 ) )\n");
        this.assertResults(connection, "select getCell( data, 1 ), getCell( data, 2 ) from t_12 where id = 1", new String[][]{{"5", "0"}}, true);
        this.assertResults(connection, "select getCell( data, 1 ), getCell( data, 90000 ) from t_12 where id = 2", new String[][]{{"0", "3"}}, true);
        this.goodStatement(connection, "create type FakeByteArray external name 'org.apache.derbyTesting.functionTests.tests.lang.FakeByteArray' language java\n");
        this.goodStatement(connection, "create function makeFakeByteArray( l int, f int ) returns FakeByteArray\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.FakeByteArray.makeFakeByteArray'\n");
        this.goodStatement(connection, "create function toString( arg FakeByteArray ) returns varchar( 30 )\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.FakeByteArray.toString'\n");
        this.goodStatement(connection, "create table t_12_a( id int generated always as identity, data FakeByteArray )\n");
        this.goodStatement(connection, "insert into t_12_a( data ) values ( makeFakeByteArray( 3, 33 ) )\n");
        this.goodStatement(connection, "insert into t_12_a( data ) values ( makeFakeByteArray( 1000000, 44 ) )\n");
        this.assertResults(connection, "select id, toString( data ) from t_12_a order by id", new String[][]{{"1", "[ 3, 33 ]"}, {"2", "[ 1000000, 44 ]"}}, true);
    }

    public void test_13_sqlData() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type SampleSQLData external name 'org.apache.derbyTesting.functionTests.tests.lang.SampleSQLData' language java\n");
        this.goodStatement(connection, "create function makeSampleSQLData( l int ) returns SampleSQLData\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.SampleSQLData.makeSampleSQLData'\n");
        this.goodStatement(connection, "create table t_13_a( id int generated always as identity, data SampleSQLData )\n");
        this.expectExecutionError(connection, "XJ001", "insert into t_13_a( data ) values ( makeSampleSQLData( 3 ) )\n");
    }

    public void test_14_systemClasses() throws Exception {
        Connection connection = this.getConnection();
        UDTTest.assertEquals((int)21, (int)this.vetDatatypeCount(connection));
        this.expectCompilationError("42Z10", "create type java_string external name 'byte[]' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.Boolean' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.Integer' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.Long' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.Float' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.Double' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.lang.String' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.math.BigDecimal' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Blob' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Clob' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Date' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Ref' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Time' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'java.sql.Timestamp' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'org.apache.derby.iapi.types.XML' language java\n");
        this.expectCompilationError("42Z10", "create type java_string external name 'org.apache.derby.Foo' language java\n");
    }

    private int vetDatatypeCount(Connection connection) throws Exception {
        ResultSet resultSet = connection.getMetaData().getTypeInfo();
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        resultSet.close();
        int n2 = TypeId.getAllBuiltinTypeIds().length;
        --n2;
        --n2;
        UDTTest.assertEquals((int)(--n), (int)(++n2));
        return n2;
    }

    public void test_15_ordering() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type IntArray_15 external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray' language java\n");
        this.goodStatement(connection, "create function makeIntArray_15( arrayLength int ) returns IntArray_15\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray.makeIntArray'\n");
        this.goodStatement(connection, "create table t_15( a IntArray_15 )\n");
        this.goodStatement(connection, "insert into t_15( a ) values ( makeIntArray_15( 3 ) )\n");
        this.goodStatement(connection, "insert into t_15( a ) values ( makeIntArray_15( 4 ) )\n");
        this.expectCompilationError("X0X67", "create index t_15_idx on t_15( a )\n");
        this.expectCompilationError("X0X67", "select * from t_15 order by a\n");
        this.expectCompilationError("X0X67", "select * from t_15 group by a\n");
        this.expectCompilationError("X0X67", "select distinct a from t_15\n");
        this.expectCompilationError("42Y22", "select max( a ) from t_15\n");
        this.expectCompilationError("42Y22", "select min( a ) from t_15\n");
        this.expectCompilationError("42Y22", "select avg( a ) from t_15\n");
        this.expectCompilationError("X0X67", "select * from t_15 union select * from t_15\n");
        this.expectCompilationError("42818", "select * from t_15 where a = makeIntArray_15( 3 )\n");
        this.expectCompilationError("42818", "select * from t_15 where a between makeIntArray_15( 2 ) and makeIntArray_15( 4 )\n");
        this.expectCompilationError("42818", "select * from t_15 l, t_15 r where l.a = r.a\n");
        this.expectCompilationError("42818", "select * from t_15 l, t_15 r where l.a < r.a\n");
        this.expectCompilationError("42818", "select * from t_15 l, t_15 r where l.a > r.a\n");
        this.expectCompilationError("42818", "select * from t_15 l, t_15 r where l.a <= r.a\n");
        this.expectCompilationError("42818", "select * from t_15 l, t_15 r where l.a >= r.a\n");
        this.expectCompilationError("X0X67", "select count( distinct a ) from t_15\n");
        this.goodStatement(connection, "select count(*) from t_15\n");
        this.goodStatement(connection, "select all * from t_15\n");
    }

    public void test_16_casts() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type javaSerializable external name 'java.io.Serializable' language java\n");
        this.goodStatement(connection, "create type javaNumber external name 'java.lang.Number' language java\n");
        this.goodStatement(connection, "create type javaDate external name 'java.util.Date' language java\n");
        this.goodStatement(connection, "create function makeNumber( arg int ) returns javaNumber\nlanguage java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeNumber'\n");
        this.goodStatement(connection, "create table t_16( a int generated always as identity, b javaNumber )\n");
        this.goodStatement(connection, "create table t_16_1( a int generated always as identity, b javaDate )\n");
        this.goodStatement(connection, "create table t_16_2( a int generated always as identity, b javaSerializable )\n");
        this.goodStatement(connection, "insert into t_16( b ) values ( makeNumber( 1 ) )\n");
        this.goodStatement(connection, "insert into t_16( b ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16( b ) values ( 1 )\n");
        this.expectCompilationError("42821", "insert into t_16( b ) values ( 1.0 )\n");
        this.expectCompilationError("42821", "insert into t_16( b ) values ( '1' )\n");
        this.expectCompilationError("42821", "insert into t_16_1( b ) values ( date('1994-02-23') )\n");
        this.expectCompilationError("42821", "insert into t_16_1( b ) values ( time('15:09:02') )\n");
        this.expectCompilationError("42821", "insert into t_16_1( b ) values ( timestamp('1960-01-01 23:03:20') )\n");
        this.expectCompilationError("42821", "insert into t_16_2( b ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_2( b ) values( cast (null as javaNumber) )\n");
        this.expectCompilationError("42846", "select cast (b as javaDate) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as javaSerializable) from t_16\n");
        UDTTest.assertEquals((int)21, (int)this.vetDatatypeCount(connection));
        this.expectCompilationError("42846", "select cast (b as boolean) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as bigint) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as blob) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as char( 1 ) ) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as char( 1 ) for bit data) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as clob) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as date) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as decimal) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as double) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as float) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as int) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as long varchar) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as long varchar for bit data) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as numeric) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as real) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as smallint) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as time) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as timestamp) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as varchar(10)) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as varchar(10) for bit data) from t_16\n");
        this.expectCompilationError("42846", "select cast (b as xml) from t_16\n");
        UDTTest.assertEquals((int)21, (int)this.vetDatatypeCount(connection));
        this.goodStatement(connection, "create table t_16_all_types\n(\n    a01 bigint,\n    a02 blob,\n    a03 char( 1 ),\n    a04 char( 1 ) for bit data ,\n    a05 clob,\n    a06 date,\n    a07 decimal,\n    a08 double,\n    a09 float,\n    a10 int,\n    a11 long varchar,\n    a12 long varchar for bit data,\n    a13 numeric,\n    a14 real,\n    a15 smallint,\n    a16 time,\n    a17 timestamp,\n    a18 varchar(10),\n    a19 varchar(10) for bit data,\n    a20 xml,\n    a21 boolean\n)");
        this.expectCompilationError("42846", "select cast( a01 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a02 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a03 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a04 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a05 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a06 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a07 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a08 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a09 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a10 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a11 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a12 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a13 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a14 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a15 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a16 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a17 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a18 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a19 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a20 as javaSerializable ) from t_16_all_types\n");
        this.expectCompilationError("42846", "select cast( a21 as javaSerializable ) from t_16_all_types\n");
        UDTTest.assertEquals((int)21, (int)this.vetDatatypeCount(connection));
        this.expectCompilationError("42821", "insert into t_16_all_types( a01 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a02 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a03 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a04 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a05 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a06 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a07 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a08 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a09 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a10 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a11 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a12 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a13 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a14 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a15 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a16 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a17 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a18 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a19 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a20 ) select b from t_16\n");
        this.expectCompilationError("42821", "insert into t_16_all_types( a21 ) select b from t_16\n");
        this.expectCompilationError("42846", "select cast (isindex as javaNumber) from sys.sysconglomerates\n");
        this.assertResults(connection, "select cast (b as javaNumber) from t_16", new String[][]{{"1"}, {"1"}}, false);
    }

    public void test_17_outputParameters() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create type intArray_17 external name 'org.apache.derbyTesting.functionTests.tests.lang.IntArray' language java\n");
        this.goodStatement(connection, "create procedure changeIntArray_17\n( in newSize int, inout oldIntArray intArray_17 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.changeIntArray'\n");
        CallableStatement callableStatement = this.chattyPrepareCall(connection, "call changeIntArray_17( ?, ? )");
        callableStatement.registerOutParameter(2, 2000);
        callableStatement.setInt(1, 2);
        callableStatement.setObject(2, (Object)new IntArray(new int[5]));
        callableStatement.execute();
        Object object = callableStatement.getObject(2);
        callableStatement.close();
        UDTTest.assertEquals((String)"[ 0, 0 ]", (String)object.toString());
    }

    public void test_18_derby6421() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create type d6421_type external name 'java.util.ArrayList' language java");
        statement.execute("create table d6421_table (x generated always as (cast(null as d6421_type)), check (cast(null as d6421_type) is null))");
        statement.execute("insert into d6421_table values default");
    }

    public static void oneArgPriceProc(Price price) {
    }

    public static void twoArgPriceProc(Price price, Price price2) {
    }

    public static void changeIntArray(int n, IntArray[] intArrayArray) {
        IntArray intArray;
        intArrayArray[0] = intArray = new IntArray(new int[n]);
    }

    public static HashMap makeHashMap() {
        return new HashMap();
    }

    public static HashMap makeHashMap(String string, Integer n) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put(string, n);
        return hashMap;
    }

    public static HashMap putValue(HashMap<String, String> hashMap, String string, String string2) {
        hashMap.put(string, string2);
        return hashMap;
    }

    public static ResultSet hashmapReader() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("select intCol, hashmapCol from t_11");
        return preparedStatement.executeQuery();
    }

    public static Number makeNumber(int n) {
        return n;
    }

    public static Integer getIntValue(HashMap<String, Integer> hashMap, String string) {
        return hashMap.get(string);
    }

    private void verifyDropRestrictions(Connection connection, String string, String string2, String string3, String string4, String string5) throws Exception {
        this.goodStatement(connection, string);
        this.goodStatement(connection, string3);
        this.expectExecutionError(connection, string5, string2);
        this.goodStatement(connection, string4);
        this.goodStatement(connection, string2);
    }

    private int countTableDependencies(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select count(*) from sys.sysdepends d, sys.systables t where d.dependentid = t.tableid and t.tablename = ?");
        preparedStatement.setString(1, string);
        return this.getScalarInteger(preparedStatement);
    }

    private int getScalarInteger(PreparedStatement preparedStatement) throws Exception {
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        preparedStatement.close();
        return n;
    }

    private void checkRSMD(Connection connection, String string, String string2, int n, int n2, String string3, int n3, int n4) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        UDTTest.assertEquals((String)resultSetMetaData.getColumnClassName(1), (String)string2);
        UDTTest.assertEquals((int)resultSetMetaData.getColumnDisplaySize(1), (int)n);
        UDTTest.assertEquals((int)resultSetMetaData.getColumnType(1), (int)n2);
        UDTTest.assertEquals((String)resultSetMetaData.getColumnTypeName(1), (String)string3);
        UDTTest.assertEquals((int)resultSetMetaData.getPrecision(1), (int)n3);
        UDTTest.assertEquals((int)resultSetMetaData.getScale(1), (int)n4);
        resultSet.close();
        preparedStatement.close();
    }

    private void checkPMD(Connection connection, String string, String string2, int n, String string3, int n2, int n3) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        UDTTest.assertEquals((String)parameterMetaData.getParameterClassName(1), (String)string2);
        UDTTest.assertEquals((int)parameterMetaData.getParameterType(1), (int)n);
        UDTTest.assertEquals((String)parameterMetaData.getParameterTypeName(1), (String)string3);
        UDTTest.assertEquals((int)parameterMetaData.getPrecision(1), (int)n2);
        UDTTest.assertEquals((int)parameterMetaData.getScale(1), (int)n3);
        preparedStatement.close();
    }
}

