/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class AccessTest
extends BaseJDBCTestCase {
    private static final String[] MODIFIED_DB_PROPS = new String[]{"derby.storage.pageSize", "derby.storage.minimumRecordSize", "derby.storage.pageReservedSpace"};

    public AccessTest(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.put("derby.optimizer.optimizeJoinOrder", "false");
        properties.put("derby.optimizer.ruleBasedOptimization", "true");
        properties.put("derby.optimizer.noTimeout", "true");
        Test test = TestConfiguration.embeddedSuite(AccessTest.class);
        return new CleanDatabaseTestSetup((Test)new SystemPropertyTestSetup(test, properties, true)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = statement.getConnection();
                connection.setAutoCommit(false);
                statement.execute("CREATE FUNCTION  PADSTRING (DATA VARCHAR(32000), LENGTH INTEGER) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Formatters.padString' LANGUAGE JAVA PARAMETER STYLE JAVA");
            }
        };
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("DROP TABLE FOO");
        }
        catch (SQLException sQLException) {
            AccessTest.assertSQLState("42Y55", sQLException);
        }
        PreparedStatement preparedStatement = this.prepareStatement("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, NULL)");
        for (int i = 0; i < MODIFIED_DB_PROPS.length; ++i) {
            preparedStatement.setString(1, MODIFIED_DB_PROPS[i]);
            preparedStatement.executeUpdate();
        }
        this.commit();
        super.tearDown();
    }

    public void testQualifierSkipLOLB() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '32768')");
        callableStatement.execute();
        statement.executeUpdate("create table a ( i1 int, col00 varchar(384), col01 varchar(390), i2 int )");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        statement.executeUpdate("insert into a values (1, PADSTRING('10',384), PADSTRING('100',390), 1000)");
        statement.executeUpdate("insert into a values (2, PADSTRING('20',384), PADSTRING('200',390), 2000)");
        statement.executeUpdate("insert into a values (3, PADSTRING('30',384), PADSTRING('300',390), 3000)");
        resultSet = statement.executeQuery("select i1, i2 from a where i2 = 3000");
        String[] stringArray = new String[]{"I1", "I2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"3", "3000"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table a");
        this.commit();
    }

    public void testCSBug2590() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table foo (a int, b varchar(900), c int)");
        statement.executeUpdate("insert into foo values (1, PADSTRING('1',900), 1)");
        statement.executeUpdate("insert into foo values (2, PADSTRING('2',900), 1)");
        statement.executeUpdate("insert into foo values (3, PADSTRING('3',900), 1)");
        statement.executeUpdate("insert into foo values (4, PADSTRING('4',900), 1)");
        statement.executeUpdate("insert into foo values (5, PADSTRING('5',900), 1)");
        statement.executeUpdate("insert into foo values (6, PADSTRING('6',900), 1)");
        statement.executeUpdate("insert into foo values (7, PADSTRING('7',900), 1)");
        statement.executeUpdate("insert into foo values (8, PADSTRING('8',900), 1)");
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        callableStatement.execute();
        statement.executeUpdate("create index foox on foo (a, b)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        this.commit();
        AccessTest.assertUpdateCount(statement, 7, "delete from foo where foo.a <> 2");
        ResultSet resultSet = null;
        resultSet = statement.executeQuery("select a, b, c from foo for update of c");
        Object[][] objectArray = new String[][]{{"2", "2", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        PreparedStatement preparedStatement = this.prepareStatement("select a, b, c from foo for update of c");
        ResultSet resultSet2 = preparedStatement.executeQuery();
        objectArray = new String[][]{{"2", "2", "1"}};
        JDBC.assertFullResultSet(resultSet2, objectArray, true);
        statement.executeUpdate("insert into foo values (1, PADSTRING('11',900), 1)");
        statement.executeUpdate("insert into foo values (1, PADSTRING('12',900), 1)");
        statement.executeUpdate("insert into foo values (1, PADSTRING('13',900), 1)");
        statement.executeUpdate("insert into foo values (1, PADSTRING('14',900), 1)");
        statement.executeUpdate("insert into foo values (1, PADSTRING('15',900), 1)");
        this.commit();
        statement.executeUpdate("drop table foo");
        this.commit();
    }

    public void testCSBug735() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        statement.executeUpdate("create table foo (a int)");
        statement.executeUpdate("insert into foo values (1024)");
        statement.executeUpdate("insert into foo (select foo.a - 1   from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 2   from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 4   from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 8   from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 16  from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 32  from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 64  from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 128 from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 256 from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 512 from foo)");
        AccessTest.assertEquals((int)0, (int)statement.executeUpdate("create index a on foo (a)"));
        resultSet = statement.executeQuery("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'FOO')");
        String[] stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        AccessTest.assertUpdateCount(statement, 1024, "delete from foo");
        statement.executeUpdate("drop table foo");
    }

    public void test_conglomDirectory() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table a (a int)");
        this.commit();
        statement.executeUpdate("alter table a add column c1 int");
        this.rollback();
        resultSet = statement.executeQuery("select * from a");
        String[] stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("drop table a");
        this.commit();
    }

    public void testPartialRowRTStats() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set ISOLATION to RR");
        this.setAutoCommit(false);
        statement.executeUpdate("create table foo (a int, b int, c int, d int, e int)");
        statement.executeUpdate("insert into foo values (1, 2, 3, 4, 5)");
        statement.executeUpdate("insert into foo values (10, 20, 30, 40, 50)");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.runQueriesNormal(statement);
        statement.executeUpdate("create index foo_cover on foo (e, d, c, b, a)");
        this.runQueriesWithIndex(statement);
        statement.executeUpdate("drop index foo_cover");
        statement.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','FOO',null)");
        statement.executeUpdate("insert into foo values (100, 2, 3, 4, 5)");
        statement.executeUpdate("insert into foo values (1000, 2, 3, 4, 5)");
        AccessTest.assertUpdateCount(statement, 1, "delete from foo where foo.a = 100");
        AccessTest.assertUpdateCount(statement, 1, "delete from foo where foo.a = 1000");
        this.runQueriesWithDeletedRows(statement);
        statement.execute("create index foo_cover on foo (e, d, c, b, a)");
        statement.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','FOO',null)");
        statement.executeUpdate("insert into foo values (100, 2, 3, 4, 5)");
        statement.executeUpdate("insert into foo values (1000, 2, 3, 4, 5)");
        AccessTest.assertUpdateCount(statement, 1, "delete from foo where foo.a = 100");
        AccessTest.assertUpdateCount(statement, 1, "delete from foo where foo.a = 1000");
        this.runQueriesWithIndexDeletedRows(statement);
        statement.executeUpdate("drop table foo");
    }

    private void assertStatsOK(Statement statement, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14) throws SQLException {
        ResultSet resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        RuntimeStatisticsParser runtimeStatisticsParser = new RuntimeStatisticsParser(resultSet.getString(1));
        resultSet.close();
        try {
            if (string.equals("Table")) {
                AccessTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
            } else if (string.equals("Index")) {
                AccessTest.assertTrue((boolean)runtimeStatisticsParser.usedIndexScan());
                AccessTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan(string2, string3));
            } else if (string.equals("Constraint")) {
                AccessTest.assertTrue((boolean)runtimeStatisticsParser.usedIndexScan());
                AccessTest.assertTrue((boolean)runtimeStatisticsParser.usedConstraintForIndexScan(string2));
            }
            AccessTest.assertTrue((boolean)runtimeStatisticsParser.findString("Bit set of columns fetched=" + string4, 1));
            AccessTest.assertTrue((boolean)runtimeStatisticsParser.findString("Number of columns fetched=" + string5, 1));
            if (string6 != null) {
                AccessTest.assertTrue((boolean)runtimeStatisticsParser.findString("Number of deleted rows visited=" + string6, 1));
            }
            if (string7 != null) {
                AccessTest.assertTrue((String)("RuntimeStatisticsParser.findstring(Number of pages visited= " + string7 + ") returned falsefull runtime statistics = " + runtimeStatisticsParser.toString()), (boolean)runtimeStatisticsParser.findString("Number of pages visited=" + string7, 1));
            }
            AccessTest.assertTrue((boolean)runtimeStatisticsParser.findString("Number of rows qualified=" + string8, 1));
            AccessTest.assertTrue((boolean)runtimeStatisticsParser.findString("Number of rows visited=" + string9, 1));
            AccessTest.assertTrue((boolean)runtimeStatisticsParser.findString("Scan type=" + string10, 1));
            AccessTest.assertTrue((runtimeStatisticsParser.getStartPosition()[1].indexOf(string11) > 1 ? 1 : 0) != 0);
            AccessTest.assertTrue((runtimeStatisticsParser.getStopPosition()[1].indexOf(string12) > 1 ? 1 : 0) != 0);
            if (string13.equals("None")) {
                AccessTest.assertTrue((boolean)runtimeStatisticsParser.hasNoQualifiers());
            } else if (string13.equals("Equals")) {
                AccessTest.assertTrue((boolean)runtimeStatisticsParser.hasEqualsQualifier());
            }
            if (string14 != null) {
                AccessTest.assertTrue((boolean)runtimeStatisticsParser.findString(string14, 1));
            }
        }
        catch (AssertionFailedError assertionFailedError) {
            AccessTest.fail("Statistics didn't match:\n" + runtimeStatisticsParser.toString(), assertionFailedError);
        }
    }

    private void runQueriesNormal(Statement statement) throws SQLException {
        this.doQuery1(statement);
        this.assertStatsOK(statement, "Table", null, null, "All", "5", null, "1", "2", "2", "heap", "null", "null", "None", null);
        this.doQuery2(statement);
        this.assertStatsOK(statement, "Table", null, null, "{4}", "1", null, "1", "2", "2", "heap", "null", "null", "None", null);
        this.doQuery3(statement);
        this.assertStatsOK(statement, "Table", null, null, "{0, 2, 4}", "3", null, "1", "2", "2", "heap", "null", "null", "None", null);
        this.doQuery4(statement);
        this.assertStatsOK(statement, "Table", null, null, "{0, 2, 4}", "3", null, "1", "1", "2", "heap", "null", "null", "Equals", "Column[0][0] Id: 4");
        this.doQuery5(statement);
        this.assertStatsOK(statement, "Table", null, null, "{0, 1, 2, 4}", "4", null, "1", "1", "2", "heap", "null", "null", "Equals", "Column[0][0] Id: 1");
        this.doQuery6(statement);
        this.assertStatsOK(statement, "Table", null, null, "{0, 1}", "2", null, "1", "2", "2", "heap", "null", "null", "None", null);
    }

    private void runQueriesWithIndex(Statement statement) throws SQLException {
        this.doQuery1(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{0, 1, 2, 3, 4}", "5", "0", "1", "2", "2", "btree", "None", "None", "None", null);
        this.doQuery2(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{0}", "1", "0", "1", "2", "2", "btree", "None", "None", "None", null);
        this.doQuery3(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{0, 2, 4}", "3", "0", "1", "2", "2", "btree", "None", "None", "None", null);
        this.doQuery4(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{0, 2, 4}", "3", "0", "1", "1", "2", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        this.doQuery5(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{0, 2, 3, 4}", "4", "0", "1", "1", "2", "btree", "None", "None", "Equals", "Column[0][0] Id: 3");
        this.doQuery6(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{3, 4}", "2", "0", "1", "2", "2", "btree", "None", "None", "None", null);
    }

    private void runQueriesWithDeletedRows(Statement statement) throws SQLException {
        this.doQuery1(statement);
        this.assertStatsOK(statement, "Table", null, null, "All", "5", null, "1", "2", "4", "heap", "null", "null", "None", null);
        this.doQuery2(statement);
        this.assertStatsOK(statement, "Table", null, null, "{4}", "1", null, "1", "2", "4", "heap", "null", "null", "None", null);
        this.doQuery3(statement);
        this.assertStatsOK(statement, "Table", null, null, "{0, 2, 4}", "3", null, "1", "2", "4", "heap", "null", "null", "None", null);
        this.doQuery4(statement);
        this.assertStatsOK(statement, "Table", null, null, "{0, 2, 4}", "3", null, "1", "1", "4", "heap", "null", "null", "Equals", "Column[0][0] Id: 4");
        this.doQuery5(statement);
        this.assertStatsOK(statement, "Table", null, null, "{0, 1, 2, 4}", "4", null, "1", "1", "4", "heap", "null", "null", "Equals", "Column[0][0] Id: 1");
        this.doQuery6(statement);
        this.assertStatsOK(statement, "Table", null, null, "{0, 1}", "2", null, "1", "2", "4", "heap", "null", "null", "None", null);
    }

    private void runQueriesWithIndexDeletedRows(Statement statement) throws SQLException {
        this.doQuery1(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{0, 1, 2, 3, 4}", "5", "2", "1", "2", "4", "btree", "None", "None", "None", null);
        this.doQuery2(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{0}", "1", "2", "1", "2", "4", "btree", "None", "None", "None", null);
        this.doQuery3(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{0, 2, 4}", "3", "2", "1", "2", "4", "btree", "None", "None", "None", null);
        this.doQuery4(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{0, 2, 4}", "3", "2", "1", "1", "4", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        this.doQuery5(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{0, 2, 3, 4}", "4", "2", "1", "1", "4", "btree", "None", "None", "Equals", "Column[0][0] Id: 3");
        this.doQuery6(statement);
        this.assertStatsOK(statement, "Index", "FOO", "FOO_COVER", "{3, 4}", "2", "2", "1", "2", "4", "btree", "None", "None", "None", null);
    }

    private void doQuery1(Statement statement) throws SQLException {
        this.doQuery(statement, "select * from foo", new String[]{"A", "B", "C", "D", "E"}, new String[][]{{"1", "2", "3", "4", "5"}, {"10", "20", "30", "40", "50"}});
    }

    private void doQuery2(Statement statement) throws SQLException {
        this.doQuery(statement, "select e from foo", new String[]{"E"}, new String[][]{{"5"}, {"50"}});
    }

    private void doQuery3(Statement statement) throws SQLException {
        this.doQuery(statement, "select e, c, a from foo", new String[]{"E", "C", "A"}, new String[][]{{"5", "3", "1"}, {"50", "30", "10"}});
    }

    private void doQuery4(Statement statement) throws SQLException {
        this.doQuery(statement, "select e, c, a from foo where foo.e = 5", new String[]{"E", "C", "A"}, new String[][]{{"5", "3", "1"}});
    }

    private void doQuery5(Statement statement) throws SQLException {
        this.doQuery(statement, "select e, c, a from foo where foo.b = 20", new String[]{"E", "C", "A"}, new String[][]{{"50", "30", "10"}});
    }

    private void doQuery6(Statement statement) throws SQLException {
        this.doQuery(statement, "select a, b from foo", new String[]{"A", "B"}, new String[][]{{"1", "2"}, {"10", "20"}});
    }

    private void doQuery(Statement statement, String string, String[] stringArray, String[][] stringArray2) throws SQLException {
        ResultSet resultSet = null;
        resultSet = statement.executeQuery(string);
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertFullResultSet(resultSet, (Object[][])stringArray2, true);
    }

    public void testCostingCoveredQuery() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set ISOLATION to RR");
        this.setAutoCommit(false);
        statement.executeUpdate("create table base_table (a int, b varchar(1000))");
        statement.executeUpdate("insert into base_table values (1, PADSTRING('1',1000))");
        statement.executeUpdate("insert into base_table values (2, PADSTRING('2',1000))");
        statement.executeUpdate("insert into base_table values (3,  PADSTRING('3',1000))");
        statement.executeUpdate("insert into base_table values (4,  PADSTRING('4',1000))");
        statement.executeUpdate("insert into base_table values (5,  PADSTRING('5',1000))");
        statement.executeUpdate("insert into base_table values (6,  PADSTRING('6',1000))");
        statement.executeUpdate("insert into base_table values (7,  PADSTRING('7',1000))");
        statement.executeUpdate("insert into base_table values (8,  PADSTRING('8',1000))");
        statement.executeUpdate("insert into base_table values (9,  PADSTRING('9',1000))");
        statement.executeUpdate("insert into base_table values (10, PADSTRING('10',1000))");
        statement.executeUpdate("create index cover_idx on base_table(a)");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.doQuery(statement, "select a from base_table", new String[]{"A"}, new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}, {"9"}, {"10"}});
        this.assertStatsOK(statement, "Index", "BASE_TABLE", "COVER_IDX", "{0}", "1", "0", "1", "10", "10", "btree", "None", "None", "None", null);
    }

    public void testKeyTooBigError() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table d (id int not null, t_bigvarchar varchar(400), unique (id))");
        statement.executeUpdate("create index t_bigvarchar_ind on d ( t_bigvarchar)");
        statement.executeUpdate("alter table d alter t_bigvarchar set data type varchar(4096)");
        Object object = "1111111";
        for (int i = 0; i < 314; ++i) {
            object = (String)object + "1234567890";
        }
        object = (String)object + "123456";
        AccessTest.assertStatementError("XSCB6", statement, "insert into d (id, t_bigvarchar) values (1, '" + (String)object + "')");
    }

    public void testSpaceForUpdate() throws Exception {
        int n;
        Statement statement = this.createStatement();
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', '1')");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', '0')");
        callableStatement.execute();
        statement.executeUpdate("create table testing (a varchar(100))");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', NULL)");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', NULL)");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', NULL)");
        callableStatement.execute();
        statement.executeUpdate("insert into testing values ('a')");
        for (n = 0; n < 7; ++n) {
            statement.executeUpdate("insert into testing (select testing.a from testing)");
        }
        AccessTest.assertUpdateCount(statement, 128, "update testing set a = 'abcd' where a = 'a'");
        statement.executeUpdate("create index zz on testing (a)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', '1')");
        callableStatement.execute();
        statement.executeUpdate("create table t1 (a varchar(100))");
        statement.executeUpdate("insert into t1 values ('a')");
        for (n = 0; n < 7; ++n) {
            statement.executeUpdate("insert into t1 (select t1.a from t1)");
        }
        AccessTest.assertUpdateCount(statement, 128, " update t1 set a = 'abcd' where a = 'a'");
        statement.executeUpdate("create index zz1 on t1 (a)");
    }

    public void testLoadLongColumnsCreateIndex() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        statement.executeUpdate("set ISOLATION to RR");
        this.setAutoCommit(false);
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        callableStatement.execute();
        statement.executeUpdate("create table long1 (a varchar(32000), b int, c int)");
        statement.executeUpdate("insert into long1 values ('this is a long row which will get even longer and longer to force a stream', 1, 2)");
        statement.executeUpdate("insert into long1 values ('this is another long row which will get even longer and longer to force a stream', 2, 3)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        AccessTest.assertUpdateCount(statement, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(statement, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(statement, 2, "update long1 set a = a||a");
        resultSet = statement.executeQuery("select LENGTH(a) from long1");
        String[] stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"5328"}, {"5760"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        callableStatement.execute();
        statement.executeUpdate("create table long2 (a varchar(16384), b int, c int)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '16384')");
        callableStatement.execute();
        statement.executeUpdate("create index long2i1 on long2 (a)");
        statement.executeUpdate("create index long2i2 on long2 (a,b)");
        statement.executeUpdate("create index long2i3 on long2 (a,b,c)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        statement.executeUpdate("insert into long2 select * from long1");
        resultSet = statement.executeQuery("select LENGTH(a) from long2");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"5328"}, {"5760"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select LENGTH(a) from long2 /*derby_properties index=long2i2*/");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"5328"}, {"5760"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("insert into long2 select * from long1");
        resultSet = statement.executeQuery("select LENGTH(a) from long2");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"5328"}, {"5328"}, {"5760"}, {"5760"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select LENGTH(a) from long2 /*derby_properties index=long2i2*/");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"5328"}, {"5328"}, {"5760"}, {"5760"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        AccessTest.assertUpdateCount(statement, 4, "delete from long2");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        callableStatement.execute();
        statement.executeUpdate("create index long2small on long2 (a, c)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        AccessTest.assertStatementError("XSCB6", statement, "insert into long2 select * from long1");
        AccessTest.assertStatementError("XSCB6", statement, "insert into long2 select * from long1");
        resultSet = statement.executeQuery("select LENGTH(a) from long2");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("drop table long1");
        statement.executeUpdate("drop table long2");
    }

    public void testCS1346() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        statement.executeUpdate("set ISOLATION to RR");
        this.setAutoCommit(false);
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        callableStatement.execute();
        statement.executeUpdate("create table long1 (a varchar(32000), b int, c int)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        statement.executeUpdate("insert into long1 values ('this is a long row which will get even longer', 1, 2)");
        statement.executeUpdate("insert into long1 values ('a second row that will also grow very long', 2, 3)");
        AccessTest.assertUpdateCount(statement, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(statement, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(statement, 2, "update long1 set a = a||a");
        resultSet = statement.executeQuery("select LENGTH(a) as x from long1 order by x");
        String[] stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"3024"}, {"3240"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        callableStatement.execute();
        statement.executeUpdate("create table long2 (a varchar(30000), b int, c int)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '16384')");
        callableStatement.execute();
        statement.executeUpdate("create index long2i1 on long2 (a)");
        statement.executeUpdate("create index long2i2 on long2 (b, a)");
        statement.executeUpdate("create index long2i3 on long2 (b, a, c)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        statement.executeUpdate("insert into long2 select * from long1");
        statement.executeUpdate("insert into long2 select * from long1");
        resultSet = statement.executeQuery("select LENGTH(a) as x from long2 order by x");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3024"}, {"3024"}, {"3240"}, {"3240"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table long1");
        statement.executeUpdate("drop table long2");
    }

    public void testCS1346b() throws Exception {
        int n;
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        callableStatement.execute();
        statement.executeUpdate("create table long1 (a varchar(32000), b int, c int)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        statement.executeUpdate("insert into long1 values ('this is a long row which will get even longer', 1, 2)");
        statement.executeUpdate("insert into long1 values ('a second row that will also grow very long', 2, 3)");
        AccessTest.assertUpdateCount(statement, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(statement, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(statement, 2, "update long1 set a = a||a");
        resultSet = statement.executeQuery("select LENGTH(a) as x from long1 order by x");
        String[] stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"3024"}, {"3240"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        callableStatement.execute();
        statement.executeUpdate("create table long2 (a varchar(32000), b int, c int)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '16384')");
        callableStatement.execute();
        statement.executeUpdate("create index long2i1 on long2 (a)");
        statement.executeUpdate("create index long2i2 on long2 (b, a)");
        statement.executeUpdate("create index long2i3 on long2 (b, a, c)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        for (n = 0; n < 10; ++n) {
            statement.executeUpdate("insert into long2 select * from long1");
        }
        resultSet = statement.executeQuery("select LENGTH(a) as x from long2 order by x");
        stringArray = new String[]{"X"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[20][1];
        for (n = 0; n < 10; ++n) {
            objectArray[n][0] = "3024";
        }
        for (n = 10; n < 20; ++n) {
            objectArray[n][0] = "3240";
        }
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select count(*) from long2");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"20"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table long1");
        statement.executeUpdate("drop table long2");
    }

    public void testCS1552() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize','4096')");
        callableStatement.execute();
        statement.executeUpdate("create table a (a int, b varchar(4000), c varchar(4000), d varchar(4000))");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        statement.executeUpdate("create index a_idx on a (a)");
        statement.executeUpdate("insert into a values (5, PADSTRING('a',4000), PADSTRING('a',4000), PADSTRING('a',4000))");
        statement.executeUpdate("insert into a values (4, PADSTRING('a',4000), PADSTRING('a',4000), PADSTRING('a',4000))");
        statement.executeUpdate("insert into a values (3, PADSTRING('a',4000), PADSTRING('a',4000), PADSTRING('a',4000))");
        statement.executeUpdate("insert into a values (2, PADSTRING('a',4000), PADSTRING('a',4000), PADSTRING('a',4000))");
        statement.executeUpdate("insert into a values (1, PADSTRING('a',4000), PADSTRING('a',4000), PADSTRING('a',4000))");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        callableStatement.execute();
        resultSet = statement.executeQuery("select a, d from a");
        String[] stringArray = new String[]{"A", "D"};
        JDBC.assertColumnNames(resultSet, stringArray);
        String string = Formatters.padString("a", 4000);
        Object[][] objectArray = new String[][]{{"5", string}, {"4", string}, {"3", string}, {"2", string}, {"1", string}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.assertStatsOK(statement, "Table", null, null, "{0, 3}", "2", null, "6", "5", "5", "heap", "null", "null", "None", null);
        statement.execute("drop table a");
        this.commit();
    }

    public void testCS2241() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', NULL)");
        callableStatement.execute();
        statement.executeUpdate("create table b2241 (a int, b varchar(32000))");
        statement.executeUpdate("insert into b2241 values (1024, '01234567890123456789012345678901234567890123456789')");
        String string = "insert into b2241 (select b2241.a + ";
        String string2 = ", b from b2241)";
        statement.executeUpdate(string + "1" + string2);
        statement.executeUpdate(string + "2" + string2);
        statement.executeUpdate(string + "4" + string2);
        statement.executeUpdate(string + "8" + string2);
        statement.executeUpdate(string + "16" + string2);
        statement.executeUpdate(string + "32" + string2);
        statement.executeUpdate(string + "64" + string2);
        for (int i = 0; i < 5; ++i) {
            AccessTest.assertUpdateCount(statement, 128, "update b2241 set b = b||b");
        }
        resultSet = statement.executeQuery("select LENGTH(b) from b2241 where a = 1025");
        String[] stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1600"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" insert into b2241 (select 1, b||b||b||b||b||b||b||b from b2241 where a = 1024)");
        statement.executeUpdate(" insert into b2241 (select 8000, b||b||b||b||b||b||b||b from b2241 where a = 1024)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        callableStatement.execute();
        AccessTest.assertStatementError("XSCB6", statement, "create index a on b2241 (b, a)");
        AccessTest.assertStatementError("XSCB6", statement, "create index a on b2241 (b, a)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        AccessTest.assertUpdateCount(statement, 1, "delete from b2241 where a = 1");
        AccessTest.assertUpdateCount(statement, 1, "delete from b2241 where a = 8000");
        statement.executeUpdate("create index a on b2241 (b, a)");
        resultSet = statement.executeQuery("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'B2241')");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table b2241");
    }

    private void reclaimTest(String string, String string2) throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', '1')");
        callableStatement.execute();
        callableStatement.close();
        this.commit();
        statement.executeUpdate("create table foo (a int, b char(200), c int)");
        statement.executeUpdate("insert into foo values (1024, 'even', 0)");
        statement.executeUpdate("insert into foo (select foo.a - 1, 'odd' , 1 from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 2, foo.b, foo.c from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 4, foo.b, foo.c from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 8, foo.b, foo.c from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 16, foo.b, foo.c from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 32, foo.b, foo.c from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 64, foo.b, foo.c from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 128, foo.b, foo.c from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 256, foo.b, foo.c from foo)");
        statement.executeUpdate("insert into foo (select foo.a - 512, foo.b, foo.c from foo)");
        statement.executeUpdate("create table foo2 (a int, b char(200), c int)");
        statement.executeUpdate("insert into foo2 (select * from foo)");
        AccessTest.assertUpdateCount(statement, 512, "delete from foo2 where foo2.c = 1");
        statement.executeUpdate(string);
        AccessTest.assertUpdateCount(statement, 512, "delete from foo where foo.c = 0");
        this.commit();
        statement.executeUpdate("insert into foo (select foo2.a, 'even2', foo2.c from foo2)");
        this.commit();
        if (string2 != null) {
            AccessTest.assertStatementError("23505", statement, "insert into foo (select foo2.a, 'even2', foo2.c from foo2)");
        } else {
            AccessTest.assertUpdateCount(statement, 512, "insert into foo (select foo2.a, 'even2', foo2.c from foo2)");
        }
        this.commit();
        if (string2 != null) {
            AccessTest.assertUpdateCount(statement, 1024, "delete from foo");
            AccessTest.assertUpdateCount(statement, 512, "delete from foo2");
        } else {
            AccessTest.assertUpdateCount(statement, 1536, "delete from foo");
            AccessTest.assertUpdateCount(statement, 512, "delete from foo2");
        }
        this.commit();
        statement.executeUpdate("drop table foo");
        statement.executeUpdate("drop table foo2");
        this.commit();
    }

    public void testReclaimDeletedRowsDuringSplit() throws Exception {
        this.reclaimTest("create index a on foo (a, b)", null);
    }

    public void testReclaimDeletedRowsUniqueIndex() throws Exception {
        this.reclaimTest("create unique index a on foo (a, b)", "23505");
    }

    private void setupForReclaim2(Statement statement) throws SQLException {
        statement.executeUpdate("create table foo (a int, b varchar(1100), c int)");
        statement.executeUpdate("create index a on foo (a, b)");
        statement.executeUpdate("insert into foo values (1, PADSTRING('a',1100), 1)");
        statement.executeUpdate("insert into foo values (2, PADSTRING('a',1100), 1)");
        statement.executeUpdate("insert into foo values (3, PADSTRING('a',1100), 1)");
    }

    private void reclaimDeletedRows2(boolean bl) throws SQLException {
        Statement statement = this.createStatement();
        this.setupForReclaim2(statement);
        this.commit();
        AccessTest.assertUpdateCount(statement, 1, "delete from foo where foo.a = 1");
        AccessTest.assertUpdateCount(statement, 1, "delete from foo where foo.a = 2");
        if (bl) {
            this.commit();
        }
        statement.executeUpdate("insert into foo values (-1, PADSTRING('ab',1100), 1)");
        statement.executeUpdate("insert into foo values (-2, PADSTRING('ab',1100), 1)");
        this.rollback();
        statement.executeUpdate("drop table foo");
        this.commit();
    }

    public void testUncommittedDeletesNotReclaimed() throws Exception {
        this.reclaimDeletedRows2(false);
    }

    public void testCommittedDeletesReclaim() throws Exception {
        this.reclaimDeletedRows2(true);
    }

    public void testAllUncommittedReclaim() throws Exception {
        Statement statement = this.createStatement();
        this.setupForReclaim2(statement);
        AccessTest.assertUpdateCount(statement, 1, "delete from foo where foo.a = 1");
        statement.executeUpdate("insert into foo values (0, PADSTRING('a',1100), 1)");
        statement.executeUpdate("insert into foo values (1, PADSTRING('a',1100), 1)");
        this.rollback();
        statement.executeUpdate("drop table foo");
    }

    public void testCS2778() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '2048')");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', '10')");
        callableStatement.execute();
        statement.executeUpdate("create table t2778 (col00 char(2), col01 char(1), col02 char(99), col03 char(11), col04 char(7), col05 char(11), col06 char(6), col07 char(6), col08 char(2), col09 char(6), col10 varchar(1000), col11 char(2), col12 char(1), col13 char(7), col14 char(24), col15 char(1), col16 char(166), col17 char(207), col18 char(2))");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        callableStatement.execute();
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', NULL)");
        callableStatement.execute();
        statement.executeUpdate("create unique index a_idx on t2778 (col00)");
        this.commit();
        statement.executeUpdate("insert into t2778 values ( '0_', '0', '0_col02', '0_col03', '0_col04', '0_col05', '0_06', '0_07', '0_', '0_09', '0_col10llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllll', '0_', '0', '0_col13', '0_col14', '0', '0_col16', '0_col17', '0_' )");
        statement.executeUpdate("insert into t2778 values ( '1_', '1', '1_col02', '1_col03', '1_col04', '1_col05', '1_06', '1_07', '1_', '1_09', '1_col10llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllxxxxxxxxxxxxxxxxxxx', '1_', '1', '1_col13', '1_col14', '1', '1_col16', '1_col17', '1_' )");
        this.commit();
        resultSet = statement.executeQuery(" select col16, col17, col18 from t2778");
        String[] stringArray = new String[]{"COL16", "COL17", "COL18"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"0_col16", "0_col17", "0_"}, {"1_col16", "1_col17", "1_"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.commit();
        AccessTest.assertUpdateCount(statement, 1, "update t2778 /*derby-properties index=a_idx*/ set col10 = '0_col10llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllxxxxxx' where col00 = '0_'");
        this.rollback();
        resultSet = statement.executeQuery("select col01, col02, col03, col04, col05,  col06, col07, col08, col09, col10, col11, col12, col13, col14, col15, col16, col17, col18 from t2778");
        stringArray = new String[]{"COL01", "COL02", "COL03", "COL04", "COL05", "COL06", "COL07", "COL08", "COL09", "COL10", "COL11", "COL12", "COL13", "COL14", "COL15", "COL16", "COL17", "COL18"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0", "0_col02", "0_col03", "0_col04", "0_col05", "0_06", "0_07", "0_", "0_09", "0_col10llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllxxxxxx", "0_", "0", "0_col13", "0_col14", "0", "0_col16", "0_col17", "0_"}, {"1", "1_col02", "1_col03", "1_col04", "1_col05", "1_06", "1_07", "1_", "1_09", "1_col10llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllxxxxxxxxxxxxxxxxxxx", "1_", "1", "1_col13", "1_col14", "1", "1_col16", "1_col17", "1_"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.commit();
        statement.executeUpdate("drop table t2778");
        this.commit();
    }

    public void testCS3149() throws Exception {
        String string;
        int n;
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table foo (a int, b varchar(500), c int)");
        String string2 = "insert into foo values (";
        String string3 = ", PADSTRING('";
        String string4 = "',500), 1)";
        for (n = 1; n < 10; ++n) {
            string = String.valueOf(n);
            statement.executeUpdate(string2 + string + string3 + string + string4);
        }
        for (n = 11; n < 19; ++n) {
            string = String.valueOf(n);
            statement.executeUpdate(string2 + string + string3 + string + string4);
        }
        statement.executeUpdate("create index foox on foo (b)");
        this.commit();
        resultSet = statement.executeQuery("select max(b) from foo");
        String[] stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"9"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        AccessTest.assertUpdateCount(statement, 1, "delete from foo where a = 9");
        resultSet = statement.executeQuery("select max(b) from foo");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        AccessTest.assertUpdateCount(statement, 1, "delete from foo where a = 8");
        resultSet = statement.executeQuery("select max(b) from foo");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"7"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        AccessTest.assertUpdateCount(statement, 13, "delete from foo where a > 2");
        resultSet = statement.executeQuery("select max(b) from foo");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.commit();
        statement.executeUpdate("drop table foo");
        this.commit();
    }

    public void testCS3368_3370() throws Exception {
        Statement statement = this.createStatement();
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', '100')");
        callableStatement.execute();
        statement.executeUpdate("create table a (a int)");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', NULL)");
        callableStatement.execute();
        statement.executeUpdate("insert into a values (1)");
        this.checkSpaceTable(statement, "2");
        statement.executeUpdate("insert into a values (2)");
        this.checkSpaceTable(statement, "3");
        statement.executeUpdate("insert into a values (1)");
        this.checkSpaceTable(statement, "4");
        statement.executeUpdate("insert into a values (2)");
        this.checkSpaceTable(statement, "5");
        statement.executeUpdate("drop table a");
    }

    private void checkSpaceTable(Statement statement, String string) throws SQLException {
        ResultSet resultSet = null;
        resultSet = statement.executeQuery("select numallocatedpages from TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'A')) a");
        Object[][] objectArray = new String[][]{{string}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
    }

    private void doTestCaseCS4595A(Statement statement, String string) throws SQLException {
        ResultSet resultSet = null;
        String string2 = string.equals("Index") ? "FOOX" : null;
        statement.executeUpdate("set ISOLATION to RR");
        AccessTest.assertUpdateCount(statement, 0, "delete from foo where a = 1");
        this.assertStatsOK(statement, string, "FOO", string2, "{0, 1}", "2", "0", "1", "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        AccessTest.assertUpdateCount(statement, 0, "update foo set b = 1 where a = 2");
        this.assertStatsOK(statement, string, "FOO", string2, "All", "2", "0", "1", "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        resultSet = statement.executeQuery("select * from foo where a = 2");
        JDBC.assertEmpty(resultSet);
        this.assertStatsOK(statement, string, "FOO", string2, "All", "2", "0", "1", "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        resultSet = statement.executeQuery("select a from foo where a = 2");
        String[] stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        this.assertStatsOK(statement, string, "FOO", string2, "{0}", "1", "0", "1", "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        resultSet = statement.executeQuery("select a from foo where a = 2");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        this.assertStatsOK(statement, string, "FOO", string2, "{0}", "1", "0", "1", "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        statement.execute("insert into foo values (1, 1)");
        AccessTest.assertUpdateCount(statement, 1, "update foo set b = 2 where a = 1");
        this.assertStatsOK(statement, string, "FOO", string2, "All", "2", "0", "1", "1", "1", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        statement.execute("delete from foo where a = 1");
        this.assertStatsOK(statement, string, "FOO", string2, "{0, 1}", "2", "0", "1", "1", "1", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        statement.execute("drop table foo");
        this.commit();
    }

    private void doTestCaseCS4595B(Statement statement, String string) throws SQLException {
        ResultSet resultSet = null;
        String string2 = string.equals("Index") ? "FOOX" : null;
        this.commit();
        AccessTest.assertUpdateCount(statement, 1, "update foo set b = 2 where a = 1");
        this.assertStatsOK(statement, string, "FOO", string2, "All", "2", "0", "1", "1", "1", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        statement.execute("delete from foo where a = 1");
        this.assertStatsOK(statement, string, "FOO", string2, "{0, 1}", "2", "0", "1", "1", "1", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        resultSet = statement.executeQuery("select * from foo where a = 2");
        JDBC.assertEmpty(resultSet);
        this.assertStatsOK(statement, string, "FOO", string2, "All", "2", "0", null, "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        resultSet = statement.executeQuery("select a from foo where a = 2");
        String[] stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        this.assertStatsOK(statement, string, "FOO", string2, "{0}", "1", "0", null, "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        resultSet = statement.executeQuery("select a from foo where a = 2");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        this.assertStatsOK(statement, string, "FOO", string2, "{0}", "1", "0", null, "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        statement.execute("drop table foo");
    }

    public void testCS4595A_UniqueIndex() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set ISOLATION to RR");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeUpdate("create table foo (a int, b int)");
        statement.executeUpdate("create unique index foox on foo (a)");
        this.doTestCaseCS4595A(statement, "Index");
    }

    public void testCS4595B_UniqueIndex() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set ISOLATION to RR");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeUpdate("create table foo (a int, b int)");
        statement.executeUpdate("insert into foo values (1, 1)");
        statement.executeUpdate("create unique index foox on foo (a)");
        this.doTestCaseCS4595B(statement, "Index");
    }

    public void testCS4595A_PrimaryKey() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set ISOLATION to RR");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeUpdate("create table foo (a int not null primary key, b int)");
        this.doTestCaseCS4595A(statement, "Constraint");
    }

    public void testCS4595B_PrimaryKey() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set ISOLATION to RR");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeUpdate("create table foo (a int not null primary key, b int)");
        statement.executeUpdate("insert into foo values (1, 1)");
        this.doTestCaseCS4595B(statement, "Constraint");
    }

    public void testCaseCS4595A_NonUniqueIndex() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set ISOLATION to RR");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeUpdate("create table foo (a int, b int)");
        statement.executeUpdate("create index foox on foo (a)");
        this.doTestCaseCS4595A(statement, "Index");
    }

    public void testCaseCS4595B_NonUniqueIndex() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set ISOLATION to RR");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.executeUpdate("create table foo (a int, b int)");
        statement.executeUpdate("create index foox on foo (a)");
        statement.executeUpdate("insert into foo values (1, 1)");
        this.doTestCaseCS4595B(statement, "Index");
    }

    public void testQualifiers() throws Exception {
        this.setAutoCommit(false);
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        statement.executeUpdate("create table foo (a int, b int, c int)");
        statement.executeUpdate("insert into foo values (1, 10, 100)");
        statement.executeUpdate("insert into foo values (2, 20, 200)");
        statement.executeUpdate("insert into foo values (3, 30, 300)");
        resultSet = statement.executeQuery("select a, b, c from foo where a = 1 and b = 20");
        String[] stringArray = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select a, b, c from foo where a = 3 and b = 30");
        stringArray = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"3", "30", "300"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select a, b, c from foo where a = 3 or c = 40");
        stringArray = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3", "30", "300"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select a, b, c from foo where a = 1 or b = 20");
        stringArray = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "10", "100"}, {"2", "20", "200"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select a, b, c from foo where a = 1 or a = 3");
        stringArray = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "10", "100"}, {"3", "30", "300"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.rollback();
        statement.close();
    }
}

