/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public class BackupRestoreTest
extends BaseJDBCTestCase {
    public BackupRestoreTest(String string) {
        super(string);
    }

    public void testDerby3875() throws SQLException, IOException {
        BackupRestoreTest.println("Creating database");
        this.getConnection();
        BackupRestoreTest.println("Backing up database");
        String string = SupportFilesSetup.getReadWrite("dbbackup").getPath();
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        callableStatement.setString(1, string);
        callableStatement.execute();
        callableStatement.close();
        this.getTestConfiguration().shutdownEngine();
        File file = new File("system/" + this.getTestConfiguration().getDefaultDatabaseName(), "seg0");
        File file2 = new File(file, "c10.dat");
        BackupRestoreTest.assertTrue((String)("File to corrupt doesn't exist: " + file2.getPath()), (boolean)PrivilegedFileOpsForTests.exists(file2));
        BackupRestoreTest.println("Corrupting data file");
        byte[] byArray = new byte[(int)PrivilegedFileOpsForTests.length(file2)];
        FileOutputStream fileOutputStream = PrivilegedFileOpsForTests.getFileOutputStream(file2);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        fileOutputStream.close();
        try {
            BackupRestoreTest.println("Rebooting corrupted database");
            this.getConnection();
            BackupRestoreTest.fail((String)"Reboot of currupted database should have failed");
        }
        catch (SQLException sQLException) {
            BackupRestoreTest.assertSQLState("XJ040", sQLException);
        }
        BackupRestoreTest.println("Restoring database");
        String[] stringArray = Utilities.split(this.getTestConfiguration().getDefaultDatabaseName(), '/');
        String string2 = stringArray[stringArray.length - 1];
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "restoreFrom=" + string + "/" + string2);
        BackupRestoreTest.assertNotNull((Object)dataSource.getConnection());
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(BackupRestoreTest.class);
        return new SupportFilesSetup((Test)TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite));
    }
}

