/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PipedReader;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derby.tools.sysinfo;
import org.apache.derbyTesting.functionTests.tests.tools.sysinfo_api_helper;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class SysinfoAPITest
extends BaseJDBCTestCase {
    DatabaseMetaData dm;

    public SysinfoAPITest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(SysinfoAPITest.class, "Sysinfo API");
        return baseTestSuite;
    }

    public void testMajorVersion() throws Exception {
        int n = this.dm.getDriverMajorVersion();
        SysinfoAPITest.assertEquals((int)n, (int)sysinfo.getMajorVersion());
        SysinfoAPITest.assertEquals((int)n, (int)sysinfo.getMajorVersion((String)"engine"));
        SysinfoAPITest.assertEquals((int)n, (int)sysinfo.getMajorVersion((String)"tools"));
        SysinfoAPITest.assertEquals((int)n, (int)sysinfo.getMajorVersion((String)"net"));
        SysinfoAPITest.assertEquals((int)n, (int)sysinfo.getMajorVersion((String)"client"));
        SysinfoAPITest.assertEquals((int)-1, (int)sysinfo.getMajorVersion((String)"foo"));
        SysinfoAPITest.assertEquals((int)-1, (int)sysinfo.getMajorVersion(null));
    }

    public void testMinorVersion() throws Exception {
        int n = this.dm.getDriverMinorVersion();
        SysinfoAPITest.assertEquals((int)n, (int)sysinfo.getMinorVersion());
        SysinfoAPITest.assertEquals((int)n, (int)sysinfo.getMinorVersion((String)"engine"));
        SysinfoAPITest.assertEquals((int)n, (int)sysinfo.getMinorVersion((String)"tools"));
        SysinfoAPITest.assertEquals((int)n, (int)sysinfo.getMinorVersion((String)"net"));
        SysinfoAPITest.assertEquals((int)n, (int)sysinfo.getMinorVersion((String)"client"));
        SysinfoAPITest.assertEquals((int)-1, (int)sysinfo.getMinorVersion((String)"foo"));
        SysinfoAPITest.assertEquals((int)-1, (int)sysinfo.getMinorVersion(null));
    }

    public void testProductName() {
        SysinfoAPITest.assertEquals((String)"Apache Derby", (String)sysinfo.getProductName());
        SysinfoAPITest.assertEquals((String)"Apache Derby", (String)sysinfo.getProductName((String)"engine"));
        SysinfoAPITest.assertEquals((String)"Apache Derby", (String)sysinfo.getProductName((String)"tools"));
        SysinfoAPITest.assertEquals((String)"Apache Derby", (String)sysinfo.getProductName((String)"net"));
        SysinfoAPITest.assertEquals((String)"Apache Derby", (String)sysinfo.getProductName((String)"client"));
        SysinfoAPITest.assertEquals((String)"<no name found>", (String)sysinfo.getProductName((String)"foo"));
        SysinfoAPITest.assertEquals((String)"<no name found>", (String)sysinfo.getProductName(null));
    }

    public void testVersionString() throws SQLException {
        String string = this.dm.getDatabaseProductVersion().substring(0, sysinfo.getVersionString().indexOf(32));
        SysinfoAPITest.assertEquals((String)string, (String)sysinfo.getVersionString().substring(0, sysinfo.getVersionString().indexOf(32)));
        SysinfoAPITest.assertEquals((String)string, (String)sysinfo.getVersionString((String)"engine").substring(0, sysinfo.getVersionString().indexOf(32)));
        SysinfoAPITest.assertEquals((String)string, (String)sysinfo.getVersionString((String)"tools").substring(0, sysinfo.getVersionString().indexOf(32)));
        SysinfoAPITest.assertEquals((String)string, (String)sysinfo.getVersionString((String)"net").substring(0, sysinfo.getVersionString().indexOf(32)));
        SysinfoAPITest.assertEquals((String)string, (String)sysinfo.getVersionString((String)"client").substring(0, sysinfo.getVersionString().indexOf(32)));
        SysinfoAPITest.assertEquals((String)"<no name found>", (String)sysinfo.getVersionString((String)"foo"));
        SysinfoAPITest.assertEquals((String)"<no name found>", (String)sysinfo.getVersionString(null));
    }

    public void testBuildNumber() throws SQLException {
        String string = this.dm.getDatabaseProductVersion();
        string = string.substring(string.indexOf(40) + 1, string.indexOf(41));
        System.out.println(string);
        SysinfoAPITest.assertEquals((String)string, (String)sysinfo.getBuildNumber());
        SysinfoAPITest.assertEquals((String)string, (String)sysinfo.getBuildNumber((String)"engine"));
        SysinfoAPITest.assertEquals((String)string, (String)sysinfo.getBuildNumber((String)"tools"));
        SysinfoAPITest.assertEquals((String)string, (String)sysinfo.getBuildNumber((String)"net"));
        SysinfoAPITest.assertEquals((String)string, (String)sysinfo.getBuildNumber((String)"client"));
        SysinfoAPITest.assertEquals((String)"????", (String)sysinfo.getBuildNumber((String)"foo"));
        SysinfoAPITest.assertEquals((String)"????", (String)sysinfo.getBuildNumber(null));
    }

    public void testGetInfo() throws IOException {
        sysinfo_api_helper sysinfo_api_helper2 = new sysinfo_api_helper();
        sysinfo_api_helper2.start();
        PipedReader pipedReader = new PipedReader(sysinfo_api_helper2.getPipedWriter());
        BufferedReader bufferedReader = new BufferedReader(pipedReader);
        SysinfoAPITest.assertEquals((String)"------------------ Java Information ------------------", (String)bufferedReader.readLine());
        bufferedReader.close();
        pipedReader.close();
    }

    public void setUp() throws SQLException {
        this.dm = this.getConnection().getMetaData();
    }
}

