/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.BlobStoredProcedureTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.ClobStoredProcedureTest;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_3
extends UpgradeChange {
    private static final String UNKNOWN_PROCEDURE = "42Y03";

    public static Test suite(int n) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Upgrade changes for 10.3");
        baseTestSuite.addTestSuite(Changes10_3.class);
        if (n == 3 && JDBC.vmSupportsJDBC3()) {
            baseTestSuite.addTestSuite(BlobStoredProcedureTest.class);
            baseTestSuite.addTestSuite(ClobStoredProcedureTest.class);
        }
        return new SupportFilesSetup((Test)baseTestSuite);
    }

    public Changes10_3(String string) {
        super(string);
    }

    public void testCompilationSchema() throws SQLException {
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                if (this.oldAtLeast(10, 3)) break;
                return;
            }
        }
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, "SYS", "SYSSTATEMENTS", "COMPILATIONSCHEMAID");
        resultSet.next();
        Changes10_3.assertEquals((String)"SYS.SYSSTATEMENTS.COMPILATIONSCHEMAID IS_NULLABLE", (String)"YES", (String)resultSet.getString("IS_NULLABLE"));
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, "SYS", "SYSVIEWS", "COMPILATIONSCHEMAID");
        resultSet.next();
        Changes10_3.assertEquals((String)"SYS.SYSVIEWS.COMPILATIONSCHEMAID IS_NULLABLE", (String)"YES", (String)resultSet.getString("IS_NULLABLE"));
    }

    public void testNegValueSupportedLogRecord() throws SQLException {
        switch (this.getPhase()) {
            case 0: {
                Statement statement = this.createStatement();
                statement.execute("create table case606(keycol int, indcol1 int,indcol2 int, data1 char(24), data2 char(24), data3 char(24),data4 char(24), data5 char(24), data6 char(24),data7 char(24), data8 char(24), data9 char(24),data10 char(24), inddec1 decimal(8), indcol3 int,indcol4 int, data11 varchar(50))");
                statement.close();
                break;
            }
            case 1: {
                if (!this.oldAtLeast(10, 1)) {
                    return;
                }
                this.checkDataToCase606(0, 2000);
                break;
            }
            case 2: {
                if (!this.oldAtLeast(10, 1)) {
                    return;
                }
                this.checkDataToCase606(0, 1000);
                break;
            }
            case 3: {
                if (!this.oldAtLeast(10, 1)) {
                    return;
                }
                this.checkDataToCase606(0, 94000);
            }
        }
    }

    private void checkDataToCase606(int n, int n2) throws SQLException {
        int n3;
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into case606 values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        char[] cArray = new char[24];
        char[] cArray2 = new char[50];
        for (n3 = 0; n3 < cArray.length; ++n3) {
            cArray[n3] = 97;
        }
        for (n3 = 0; n3 < cArray2.length; ++n3) {
            cArray2[n3] = 122;
        }
        String string = new String(cArray);
        String string2 = new String(cArray2);
        for (int i = n; i < n2; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i * 10);
            preparedStatement.setInt(3, i * 100);
            preparedStatement.setString(4, string);
            preparedStatement.setString(5, string);
            preparedStatement.setString(6, string);
            preparedStatement.setString(7, string);
            preparedStatement.setString(8, string);
            preparedStatement.setString(9, string);
            preparedStatement.setString(10, string);
            preparedStatement.setString(11, string);
            preparedStatement.setString(12, string);
            preparedStatement.setString(13, string);
            preparedStatement.setInt(14, i * 20);
            preparedStatement.setInt(15, i * 200);
            preparedStatement.setInt(16, i * 50);
            preparedStatement.setString(17, string2);
            preparedStatement.execute();
        }
        preparedStatement.close();
        this.commit();
        statement.execute("delete from case606 where case606.keycol > 10000");
        this.commit();
        String string3 = this.getTestConfiguration().getUserName();
        statement.execute("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE('" + string3 + "', 'CASE606',1,1,1)");
        statement.close();
        this.commit();
    }

    public void testImportExportLobsProcedures() throws SQLException {
        switch (this.getPhase()) {
            case 0: {
                Statement statement = this.createStatement();
                statement.execute("create table iet1(id int , content clob , pic blob)");
                statement.executeUpdate("insert into iet1 values (1, 'SQL Tips', cast(X'4231a2' as blob))");
                statement.close();
                this.commit();
                break;
            }
            case 1: {
                Statement statement = this.createStatement();
                Changes10_3.assertStatementError(UNKNOWN_PROCEDURE, statement, "call SYSCS_UTIL.SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE(null , 'IET1' , 'iet1.del' , null, null, null, 'iet1_lobs.dat')");
                statement.close();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                String string = SupportFilesSetup.getReadWrite("iet1.del").getPath();
                String string2 = SupportFilesSetup.getReadWrite("iet1_lobs.dat").getPath();
                Statement statement = this.createStatement();
                SupportFilesSetup.deleteFile(string);
                SupportFilesSetup.deleteFile(string2);
                statement.execute("call SYSCS_UTIL.SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE(null , 'IET1' , '" + string + "' , null, null, null, '" + string2 + "')");
                statement.execute("call SYSCS_UTIL.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(null, 'IET1' , '" + string + "', null, null, null, 0)");
                SupportFilesSetup.deleteFile(string);
                SupportFilesSetup.deleteFile(string2);
                statement.execute("call SYSCS_UTIL.SYSCS_EXPORT_QUERY_LOBS_TO_EXTFILE('select * from IET1', '" + string + "' , null, null, null, '" + string2 + "')");
                statement.execute("call SYSCS_UTIL.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(null, 'IET1','ID, CONTENT, PIC', '1,2,3','" + string + "', null, null, null, 1)");
                ResultSet resultSet = statement.executeQuery("select * from iet1");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "SQL Tips", "4231a2"}, {"1", "SQL Tips", "4231a2"}});
                statement.close();
                break;
            }
        }
    }

    private void checkNewHeap(String string, String string2) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from " + string);
        JDBC.assertFullResultSet(resultSet, new String[][]{{string2}});
        statement.close();
        resultSet.close();
    }

    public void testNewHeap() throws SQLException {
        switch (this.getPhase()) {
            case 0: {
                Statement statement = this.createStatement();
                statement.execute("create table testNewHeap1(keycol char(20))");
                statement.close();
                PreparedStatement preparedStatement = this.prepareStatement("insert into testNewHeap1 values(?)");
                preparedStatement.setString(1, "create");
                preparedStatement.execute();
                preparedStatement.close();
                break;
            }
            case 1: {
                Statement statement = this.createStatement();
                statement.execute("create table testNewHeap2(keycol char(20))");
                statement.close();
                PreparedStatement preparedStatement = this.prepareStatement("insert into testNewHeap2 values(?)");
                preparedStatement.setString(1, "soft");
                preparedStatement.execute();
                preparedStatement.close();
                break;
            }
            case 3: {
                Statement statement = this.createStatement();
                statement.execute("create table testNewHeap3(keycol char(20))");
                statement.close();
                PreparedStatement preparedStatement = this.prepareStatement("insert into testNewHeap3 values(?)");
                preparedStatement.setString(1, "hard");
                preparedStatement.execute();
                preparedStatement.close();
                break;
            }
        }
        switch (this.getPhase()) {
            case 0: {
                this.checkNewHeap("testNewHeap1", "create");
                break;
            }
            case 1: {
                this.checkNewHeap("testNewHeap1", "create");
                this.checkNewHeap("testNewHeap2", "soft");
                break;
            }
            case 2: {
                this.checkNewHeap("testNewHeap1", "create");
                this.checkNewHeap("testNewHeap2", "soft");
                break;
            }
            case 3: {
                this.checkNewHeap("testNewHeap1", "create");
                this.checkNewHeap("testNewHeap2", "soft");
                this.checkNewHeap("testNewHeap3", "hard");
            }
        }
    }
}

