/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Version;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_6
extends UpgradeChange {
    private static final String BAD_SYNTAX = "42X01";
    private static final String TABLE_DOES_NOT_EXIST = "42X05";
    private static final String UPGRADE_REQUIRED = "XCL47";
    private static final String QUERY_4215 = "select r.grantor\nfrom sys.sysroutineperms r, sys.sysaliases a\nwhere r.aliasid = a.aliasid\nand a.alias = 'SYSCS_INPLACE_COMPRESS_TABLE'\n";
    private static final String CREATE_TYPE_DDL = "create type fooType external name 'mypackage.foo' language java\n";
    private static final String DROP_TYPE_DDL = "drop type fooType restrict\n";
    static final String HASH_ALGORITHM_PROPERTY = "derby.authentication.builtin.algorithm";

    public Changes10_6(String string) {
        super(string);
    }

    public static Test suite(int n) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Upgrade test for 10.6");
        baseTestSuite.addTestSuite(Changes10_6.class);
        return new SupportFilesSetup((Test)baseTestSuite);
    }

    public void testSetXplainStyleProcedure() throws SQLException {
        String[] stringArray = new String[]{"call SYSCS_UTIL.SYSCS_SET_XPLAIN_SCHEMA('XPLAIN')", "call SYSCS_UTIL.SYSCS_SET_XPLAIN_SCHEMA('')", "call SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(1)", "call SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(0)", "values SYSCS_UTIL.SYSCS_GET_XPLAIN_SCHEMA()", "values SYSCS_UTIL.SYSCS_GET_XPLAIN_MODE()"};
        switch (this.getPhase()) {
            case 1: 
            case 2: {
                Statement statement = this.createStatement();
                for (int i = 0; i < stringArray.length; ++i) {
                    Changes10_6.assertStatementError("42Y03", statement, stringArray[i]);
                }
                statement.close();
                break;
            }
            case 3: {
                Statement statement = this.createStatement();
                for (int i = 0; i < stringArray.length; ++i) {
                    statement.execute(stringArray[i]);
                }
                statement.close();
            }
        }
    }

    public void testCLOBGETSUBSTRING() throws Exception {
        Version version = new Version(this.getOldMajor(), this.getOldMinor(), 0, 0);
        Version version2 = new Version(10, 3, 0, 0);
        Version version3 = new Version(10, 5, 0, 0);
        int n = 32672;
        int n2 = 10890;
        boolean bl = version.compareTo(version2) >= 0;
        boolean bl2 = version.compareTo(version3) >= 0;
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select a.aliasinfo\nfrom sys.sysschemas s, sys.sysaliases a\nwhere s.schemaid = a.schemaid\nand s.schemaname = 'SYSIBM'\nand alias = 'CLOBGETSUBSTRING'\n");
        resultSet.next();
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                if (!bl || JVMInfo.isModuleAware()) break;
                Object object = this.getTypeDescriptor(resultSet.getObject(1));
                int n3 = this.getJDBCTypeId(object);
                int n4 = this.getMaximumWidth(object);
                int n5 = bl2 ? n2 : n;
                Changes10_6.assertEquals((int)12, (int)n3);
                Changes10_6.assertEquals((int)n5, (int)n4);
                break;
            }
            case 3: {
                RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)resultSet.getObject(1);
                TypeDescriptor typeDescriptor = routineAliasInfo.getReturnType();
                Changes10_6.assertEquals((int)12, (int)typeDescriptor.getJDBCTypeId());
                Changes10_6.assertEquals((int)n2, (int)typeDescriptor.getMaximumWidth());
            }
        }
        resultSet.close();
        statement.close();
    }

    public void testSYSCS_INPLACE_COMPRESS_TABLE() throws Exception {
        Version version;
        Version version2 = new Version(this.getOldMajor(), this.getOldMinor(), 0, 0);
        boolean bl = version2.compareTo(version = new Version(10, 2, 0, 0)) < 0;
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                if (bl) {
                    Changes10_6.assertStatementError(TABLE_DOES_NOT_EXIST, statement, QUERY_4215);
                    break;
                }
                this.vetDERBY_4215(statement);
                break;
            }
            case 3: {
                this.vetDERBY_4215(statement);
            }
        }
        statement.close();
    }

    private void vetDERBY_4215(Statement statement) throws Exception {
        String string = "APP";
        ResultSet resultSet = statement.executeQuery(QUERY_4215);
        Changes10_6.assertTrue((boolean)resultSet.next());
        String string2 = resultSet.getString(1);
        Changes10_6.assertEquals((String)string, (String)string2);
        Changes10_6.assertFalse((boolean)resultSet.next());
        resultSet.close();
    }

    public void testUDTs() throws Exception {
        Statement statement = this.createStatement();
        int n = this.getPhase();
        switch (n) {
            case 0: 
            case 2: {
                Changes10_6.assertStatementError(BAD_SYNTAX, statement, CREATE_TYPE_DDL);
                Changes10_6.assertStatementError(BAD_SYNTAX, statement, DROP_TYPE_DDL);
                break;
            }
            case 1: {
                Changes10_6.assertStatementError(UPGRADE_REQUIRED, statement, CREATE_TYPE_DDL);
                Changes10_6.assertStatementError(UPGRADE_REQUIRED, statement, DROP_TYPE_DDL);
                break;
            }
            case 3: {
                statement.execute(CREATE_TYPE_DDL);
                statement.execute(DROP_TYPE_DDL);
            }
        }
        statement.close();
    }

    private Object getTypeDescriptor(Object object) throws Exception {
        Method method = object.getClass().getMethod("getReturnType", null);
        return method.invoke(object, null);
    }

    private int getJDBCTypeId(Object object) throws Exception {
        Method method = object.getClass().getMethod("getJDBCTypeId", null);
        return (Integer)method.invoke(object, null);
    }

    private int getMaximumWidth(Object object) throws Exception {
        Method method = object.getClass().getMethod("getMaximumWidth", null);
        return (Integer)method.invoke(object, null);
    }

    public void testBuiltinAuthenticationHashNotChangedOnUpgrade() throws SQLException {
        Changes10_6.assertNull((Object)this.getDatabaseProperty(HASH_ALGORITHM_PROPERTY));
    }
}

