/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BigDecimalHandler {
    public static int representation;
    public static final int STRING_REPRESENTATION = 1;
    public static final int BIGDECIMAL_REPRESENTATION = 2;
    private static final int[] bdConvertibleTypes;

    public static String getBigDecimalString(ResultSet resultSet, int n) throws SQLException {
        String string = null;
        switch (representation) {
            case 2: {
                if (resultSet.getBigDecimal(n) == null) break;
                string = resultSet.getBigDecimal(n).toString();
                break;
            }
            case 1: {
                string = resultSet.getString(n);
                int n2 = resultSet.getMetaData().getColumnType(n);
                if (string == null || BigDecimalHandler.canConvertToDecimal(n2)) break;
                throw new SQLException("Invalid data conversion. Method not called.");
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
        return string;
    }

    public static String getBigDecimalString(ResultSet resultSet, String string, int n) throws SQLException {
        String string2 = null;
        switch (representation) {
            case 2: {
                if (resultSet.getBigDecimal(string) == null) break;
                string2 = resultSet.getBigDecimal(string).toString();
                break;
            }
            case 1: {
                string2 = resultSet.getString(string);
                int n2 = resultSet.getMetaData().getColumnType(n);
                if (string2 == null || BigDecimalHandler.canConvertToDecimal(n2)) break;
                throw new SQLException("Invalid data conversion. Method not called.");
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
        return string2;
    }

    public static String getObjectString(ResultSet resultSet, int n) throws SQLException {
        String string = null;
        switch (representation) {
            case 2: {
                if (resultSet.getObject(n) == null) break;
                string = resultSet.getObject(n).toString();
                break;
            }
            case 1: {
                int n2 = resultSet.getMetaData().getColumnType(n);
                if (n2 == 3) {
                    string = resultSet.getString(n);
                    break;
                }
                if (resultSet.getObject(n) == null) break;
                string = resultSet.getObject(n).toString();
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
        return string;
    }

    public static String getObjectString(ResultSet resultSet, String string, int n) throws SQLException {
        String string2 = null;
        switch (representation) {
            case 2: {
                if (resultSet.getObject(string) == null) break;
                string2 = resultSet.getObject(string).toString();
                break;
            }
            case 1: {
                int n2 = resultSet.getMetaData().getColumnType(n);
                if (n2 == 3) {
                    string2 = resultSet.getString(string);
                    break;
                }
                if (resultSet.getObject(string) == null) break;
                string2 = resultSet.getObject(string).toString();
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
        return string2;
    }

    public static void updateBigDecimalString(ResultSet resultSet, int n, String string) throws SQLException {
        switch (representation) {
            case 2: {
                BigDecimal bigDecimal = string == null ? null : new BigDecimal(string);
                resultSet.updateBigDecimal(n, bigDecimal);
                break;
            }
            case 1: {
                resultSet.updateString(n, string);
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
    }

    public static void updateBigDecimalString(ResultSet resultSet, String string, String string2) throws SQLException {
        switch (representation) {
            case 2: {
                BigDecimal bigDecimal = string2 == null ? null : new BigDecimal(string2);
                resultSet.updateBigDecimal(string, bigDecimal);
                break;
            }
            case 1: {
                resultSet.updateString(string, string2);
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
    }

    public static String getBigDecimalString(CallableStatement callableStatement, int n, int n2) throws SQLException {
        String string = null;
        switch (representation) {
            case 2: {
                if (callableStatement.getBigDecimal(n) == null) break;
                string = callableStatement.getBigDecimal(n).toString();
                break;
            }
            case 1: {
                string = callableStatement.getString(n);
                if (string == null || BigDecimalHandler.canConvertToDecimal(n2)) break;
                throw new SQLException("Invalid data conversion. Method not called.");
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
        return string;
    }

    public static void setBigDecimalString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        switch (representation) {
            case 2: {
                BigDecimal bigDecimal = string == null ? null : new BigDecimal(string);
                preparedStatement.setBigDecimal(n, bigDecimal);
                break;
            }
            case 1: {
                preparedStatement.setString(n, string);
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
    }

    public static void setObjectString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        switch (representation) {
            case 2: {
                BigDecimal bigDecimal = string == null ? null : new BigDecimal(string);
                preparedStatement.setObject(n, bigDecimal);
                break;
            }
            case 1: {
                preparedStatement.setObject(n, string);
                break;
            }
            default: {
                new Exception("Failed: Invalid Big Decimal representation").printStackTrace();
            }
        }
    }

    protected static boolean canConvertToDecimal(int n) throws SQLException {
        boolean bl = false;
        for (int i = 0; i < bdConvertibleTypes.length; ++i) {
            if (n != bdConvertibleTypes[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static {
        try {
            Class.forName("java.math.BigDecimal");
            representation = 2;
            Method method = ResultSet.class.getMethod("getBigDecimal", Integer.TYPE);
            representation = 2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            representation = 1;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            representation = 1;
        }
        bdConvertibleTypes = new int[]{-6, 5, 4, -5, 7, 6, 8, 3, 2, -7, 1, 12, -1};
    }
}

