/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.init;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.derbyTesting.system.nstest.NsTest;
import org.apache.derbyTesting.system.nstest.utils.DbUtil;

public class Initializer {
    private String thread_id;
    private DbUtil dbutil;

    public Initializer(String string) {
        this.thread_id = string;
        this.dbutil = new DbUtil(this.thread_id);
    }

    public void startInserts() {
        Connection connection = null;
        int n = NsTest.MAX_INITIAL_ROWS;
        try {
            NsTest.logger.println(this.thread_id + " is getting a connection to the database...");
            if (NsTest.embeddedMode) {
                connection = DriverManager.getConnection(NsTest.embedDbURL, NsTest.prop);
            } else if (NsTest.driver_type.equalsIgnoreCase("DerbyClient")) {
                NsTest.logger.println("-->Using derby client url");
                connection = DriverManager.getConnection(NsTest.clientDbURL, NsTest.prop);
            }
        }
        catch (Exception exception) {
            NsTest.logger.println("FAIL: " + this.thread_id + " could not get the database connection");
            this.printException("getting database connection in startInserts()", exception);
        }
        NsTest.addStats(NsTest.CONNECTIONS_MADE, 1);
        NsTest.logger.println("Connection number: " + NsTest.numConnections);
        if (NsTest.AUTO_COMMIT_OFF) {
            try {
                connection.setAutoCommit(false);
            }
            catch (Exception exception) {
                NsTest.logger.println("FAIL: " + this.thread_id + "'s setAutoCommit() failed:");
                this.printException("setAutoCommit() in Initializer", exception);
            }
        }
        while (n-- >= 0) {
            try {
                int n2 = this.dbutil.add_one_row(connection, this.thread_id);
            }
            catch (Exception exception) {
                NsTest.logger.println(" FAIL: " + this.thread_id + " unexpected exception:");
                this.printException("add_one_row() in Initializer", exception);
                break;
            }
        }
        if (NsTest.AUTO_COMMIT_OFF) {
            try {
                connection.commit();
            }
            catch (Exception exception) {
                NsTest.logger.println("FAIL: " + this.thread_id + "'s commit() failed:");
                this.printException("commit in Initializer", exception);
            }
        }
    }

    public synchronized void printException(String string, Exception exception) {
        if (NsTest.justCountErrors()) {
            NsTest.addError(exception);
            return;
        }
        if (exception instanceof SQLException) {
            SQLException sQLException = (SQLException)exception;
            if (sQLException.getSQLState().equals("40001")) {
                NsTest.logger.println("deadlocked detected");
            }
            if (sQLException.getSQLState().equals("40XL1")) {
                NsTest.logger.println(" lock timeout exception");
            }
            if (sQLException.getSQLState().equals("23500")) {
                NsTest.logger.println(" duplicate key violation");
            }
            if (sQLException.getNextException() != null) {
                String string2 = sQLException.getNextException().getSQLState();
                NsTest.logger.println(sQLException.getNextException().getMessage() + " SQLSTATE: " + string2);
            }
        }
        if (exception.getMessage() == null) {
            exception.printStackTrace(NsTest.logger);
        }
        NsTest.logger.println("During - " + string + ", the exception thrown was : " + exception.getMessage());
    }
}

